/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.xtext.canvas;

import java.awt.Color;
import java.awt.Graphics2D;
import org.catacomb.druid.swing.DTextCanvas;
import org.catacomb.druid.swing.dnd.Region;
import org.catacomb.druid.swing.dnd.RegionBoard;
import org.catacomb.druid.xtext.base.Block;
import org.catacomb.druid.xtext.base.Guise;
import org.catacomb.druid.xtext.base.NewlineBlock;
import org.catacomb.druid.xtext.base.PunctuationBlock;
import org.catacomb.druid.xtext.base.TextBlock;
import org.catacomb.druid.xtext.base.WordBlock;
import org.catacomb.druid.xtext.canvas.BoardRepainterDMItem;
import org.catacomb.druid.xtext.canvas.FontStore;
import org.catacomb.druid.xtext.canvas.KeyWriter;
import org.catacomb.interlish.structure.TextPainter;
import org.catacomb.report.E;

public class TextBoard
extends RegionBoard
implements TextPainter {
    Block rootBlock;
    FontStore fontStore;
    int width;
    int height;
    int itxt;
    int jtxt;
    KeyWriter keyWriter;
    public static final String PUNCTUATION = " .,;:?!\t\n";
    private boolean nextIsLinked;

    public TextBoard(DTextCanvas dtc) {
        super(dtc);
        this.canvas.setTextPainter(this);
        this.fontStore = FontStore.instance();
        this.keyWriter = new KeyWriter(this);
        this.canvas.addKeyListener(this.keyWriter);
        this.canvas.setFocusable(true);
        this.requestFocus();
    }

    public void setBlock(Block rb) {
        this.rootBlock = rb;
        this.rootBlock.setParent(new BoardRepainterDMItem(this));
        this.keyWriter.setCaretBlock(this.firstTextBlock());
        this.canvas.repaint();
    }

    public TextBlock firstTextBlock() {
        TextBlock ret = null;
        Block b = this.rootBlock;
        while (b.hasNext()) {
            if (!((b = b.next()) instanceof TextBlock)) continue;
            ret = (TextBlock)b;
            break;
        }
        return ret;
    }

    @Override
    public void repaint() {
        this.canvas.repaint();
    }

    @Override
    public void paintText(Graphics2D g) {
        this.clearRegions();
        this.width = this.canvas.getWidth();
        this.height = this.canvas.getHeight();
        this.nextIsLinked = false;
        g.setFont(this.fontStore.getActiveFont());
        g.setColor(Color.black);
        this.itxt = 10;
        this.jtxt = 30;
        if (this.rootBlock != null) {
            this.paintDoc(g);
            if (this.keyWriter.hasCaret()) {
                this.paintCaret(g);
            } else {
                E.info("not painting caret");
            }
        }
        int ofth = this.fullTextHeight;
        this.fullTextHeight = this.jtxt + 10;
        if (Math.abs(this.fullTextHeight - ofth) > 10) {
            this.canvas.contentSizeChanged();
        }
    }

    private void paintDoc(Graphics2D g) {
        Block b = this.rootBlock;
        while (b.hasNext()) {
            if (!((b = b.next()) instanceof TextBlock)) continue;
            this.paintBlock(g, (TextBlock)b);
        }
    }

    private void paintCaret(Graphics2D g) {
        TextBlock caretBlock = this.keyWriter.getCaretBlock();
        int caretPos = this.keyWriter.getCaretPos();
        int w = 0;
        if (!(caretBlock instanceof NewlineBlock)) {
            String txt = caretBlock.getText();
            String part = txt.substring(0, caretPos);
            w = this.fontStore.stringWidth(g, part);
        }
        int[] xywh = caretBlock.getCachedPosition();
        g.setColor(Color.black);
        int xo = xywh[0] + w;
        int yo = xywh[1];
        if (caretBlock instanceof NewlineBlock && caretPos > 0) {
            xo = 10;
            yo += 16;
        }
        g.drawLine(xo, yo, xo, yo - xywh[3]);
    }

    private void paintBlock(Graphics2D g, TextBlock b) {
        if (b instanceof NewlineBlock) {
            b.setCachedPosition(this.itxt, this.jtxt, 0, 16);
            this.itxt = 10;
            this.jtxt += 16;
        } else {
            Guise guise = b.getGuise();
            g.setFont(guise.getFont());
            g.setColor(guise.getColor());
            String txt = b.getText();
            int w = g.getFontMetrics().stringWidth(txt);
            if (this.itxt + w > this.width && b instanceof WordBlock) {
                this.itxt = 10;
                this.jtxt += 16;
            }
            b.setCachedPosition(this.itxt, this.jtxt + 4, w, 16);
            if (b instanceof WordBlock) {
                g.drawString(txt, this.itxt, this.jtxt);
                if (guise.underline()) {
                    g.drawLine(this.itxt, this.jtxt + 2, this.itxt + w, this.jtxt + 2);
                }
                this.addDragRegion(b.getCachedPosition(), b, null);
                this.nextIsLinked = ((WordBlock)b).hasLinkee();
            } else if (b instanceof PunctuationBlock) {
                g.drawString(txt, this.itxt, this.jtxt);
                if (this.nextIsLinked) {
                    g.setColor(Color.blue);
                    g.drawLine(this.itxt - 4, this.jtxt + 1, this.itxt + w + 4, this.jtxt + 1);
                    this.nextIsLinked = false;
                }
                if (txt.trim().equals("")) {
                    this.addLengthenedRegion(b.getCachedPosition(), b);
                }
            }
            this.itxt += w;
        }
    }

    @Override
    public void regionClicked(Region reg) {
        Object src = reg.getRef();
        if (src instanceof PunctuationBlock) {
            PunctuationBlock pb = (PunctuationBlock)src;
            WordBlock pr = pb.getPreviousWordBlock();
            WordBlock pn = pb.getNextWordBlock();
            pr.toggleLink(pn);
        } else {
            E.warning("whats this ? " + src);
        }
        this.repaint();
    }

    public void dropOn(Object src, String txt, Object tgt, String tag) {
    }
}

