/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import org.catacomb.be.Position;
import org.catacomb.datalish.Box;
import org.catacomb.datalish.SColor;
import org.catacomb.graph.gui.PointPainter;
import org.catacomb.graph.gui.Size;
import org.catacomb.graph.gui.WorldTransform;
import org.catacomb.interlish.content.IntPosition;
import org.catacomb.interlish.content.Polypoint;
import org.catacomb.report.E;

public final class Painter {
    private WorldTransform worldTransform;
    private Graphics2D g;
    private BasicStroke normalStroke;
    private BasicStroke dashedStroke;
    private PointPainter pointPainter;
    AffineTransform upTransform;
    AffineTransform normalTransform;
    private Color[] colorTable;
    private double ctMin;
    private double ctMax;
    private Box wkBox;

    public Painter(WorldTransform transform) {
        this.setWorldTransform(transform);
        this.pointPainter = new PointPainter();
        this.normalStroke = new BasicStroke(1.0f);
        this.upTransform = new AffineTransform();
        this.upTransform.setToRotation(1.5707963267948966);
        this.normalTransform = new AffineTransform();
    }

    PointPainter getPointPainter() {
        return this.pointPainter;
    }

    public boolean isShowing(double x, double y) {
        return this.worldTransform.isShowing(x, y);
    }

    public void reframe(Box box) {
        this.worldTransform.reframe(box);
    }

    public int getCanvasWidth() {
        return this.worldTransform.getCanvasWidth();
    }

    public double getWorldCanvasWidth() {
        return this.worldTransform.getWorldCanvasWidth();
    }

    public int getCanvasHeight() {
        return this.worldTransform.getCanvasHeight();
    }

    public Size getPixelSize() {
        return this.worldTransform.getPixelSize();
    }

    public double getPixelArea() {
        return this.worldTransform.getPixelArea();
    }

    public boolean isOnCanvas(Position p) {
        return this.worldTransform.isOnCanvas(p.getX(), p.getY());
    }

    public boolean isOnCanvas(double x, double y) {
        return this.worldTransform.isOnCanvas(x, y);
    }

    public boolean intIsOnCanvas(int x, int y) {
        return this.worldTransform.intIsOnCanvas(x, y);
    }

    public void setPixelScalingFromTop(double d) {
        this.worldTransform.setPixelScalingFromTop(d);
    }

    public final double[] getXYXYLimits() {
        return this.worldTransform.getXYXYLimits();
    }

    void setWorldTransform(WorldTransform transform) {
        this.worldTransform = transform;
    }

    public void setGraphics(Graphics2D g2d) {
        this.g = g2d;
        this.pointPainter.setGraphics(g2d);
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public IntPosition pow(Position p) {
        return new IntPosition(this.powx(p.getX()), this.powy(p.getY()));
    }

    public double dxydp() {
        return this.worldTransform.pubDxDpix();
    }

    public int powx(double wx) {
        return this.worldTransform.powx(wx);
    }

    public int powy(double wy) {
        return this.worldTransform.powy(wy);
    }

    public Position wop(IntPosition ip) {
        return new Position(this.wopx(ip.getX()), this.wopy(ip.getY()));
    }

    public double wopx(int x) {
        return this.worldTransform.wopx(x);
    }

    public double wopy(int y) {
        return this.worldTransform.wopy(y);
    }

    void setBasicStroke(double w) {
        if (w != 1.0) {
            this.g.setStroke(new BasicStroke((float)w));
        }
    }

    void setDashedStroke(double w) {
        if (this.dashedStroke == null) {
            float[] dashes = new float[]{8.0f, 4.0f, 8.0f, 4.0f};
            this.dashedStroke = new BasicStroke(1.0f, 0, 2, 10.0f, dashes, 0.0f);
        }
        this.g.setStroke(this.dashedStroke);
    }

    void setNormalStroke() {
        this.g.setStroke(this.normalStroke);
    }

    private void resetStroke() {
        this.g.setStroke(this.normalStroke);
    }

    public void setStroke(BasicStroke bs) {
        this.g.setStroke(bs);
    }

    public final void drawPixelLine(int x0, int y0, int x1, int y1) {
        this.g.drawLine(x0, y0, x1, y1);
    }

    void drawPolyline(double[] xp, double[] yp) {
        this.drawPolyline(xp, yp, xp.length);
    }

    public void drawPolyline(double[] xp, double[] yp, int np) {
        this.g.drawPolyline(this.worldTransform.intDeviceX(xp), this.worldTransform.intDeviceY(yp), np);
    }

    public void drawPolyline(double[] xp, double[] yp, int np, Color col, double width, boolean widthIsPixels) {
        this.setBasicStroke(width);
        this.setColor(col);
        this.g.drawPolyline(this.worldTransform.intDeviceX(xp), this.worldTransform.intDeviceY(yp), np);
        this.resetStroke();
    }

    public void drawMarks(double[] xp, double[] yp) {
        int i = 0;
        while (i < xp.length) {
            int x = this.powx(xp[i]);
            int y = this.powy(yp[i]);
            this.g.fillRect(x, y, 1, 1);
            ++i;
        }
    }

    public void drawMarks(double[] xp, double[] yp, int n) {
        int i = 0;
        while (i < n) {
            int x = this.powx(xp[i]);
            int y = this.powy(yp[i]);
            this.g.fillRect(x, y, 1, 1);
            ++i;
        }
    }

    public void drawIntMarks(double[] xp, double[] yp, int n, int w, int h) {
        int i = 0;
        while (i < n) {
            int x = this.powx(xp[i]);
            int y = this.powy(yp[i]);
            this.g.fillRect(x, y, w, h);
            ++i;
        }
    }

    public void drawAreaMarks(double[] xp, double[] yp, double diam) {
        int n = xp.length;
        int i = 0;
        while (i < n) {
            int x = this.powx(xp[i]);
            int y = this.powy(yp[i]);
            this.g.fill(new Ellipse2D.Double(x, y, diam, diam));
            ++i;
        }
    }

    public void drawPolygon(double[] xp, double[] yp) {
        this.drawPolygon(xp, yp, xp.length);
    }

    public void drawPolygon(double[] xp, double[] yp, int np) {
        this.g.drawPolygon(this.worldTransform.intDeviceX(xp), this.worldTransform.intDeviceY(yp), np);
    }

    public void drawPolygon(double[] xp, double[] yp, int np, Color col, double width, boolean widthIsPixels) {
        this.setBasicStroke(width);
        this.setColor(col);
        this.g.drawPolygon(this.worldTransform.intDeviceX(xp), this.worldTransform.intDeviceY(yp), np);
        this.resetStroke();
    }

    public void fillPolygon(double[] xp, double[] yp, int np) {
        this.g.fillPolygon(this.worldTransform.intDeviceX(xp), this.worldTransform.intDeviceY(yp), np);
    }

    public void fillPolygon(double[] xp, double[] yp, int np, Color col) {
        this.setColor(col);
        this.g.fillPolygon(this.worldTransform.intDeviceX(xp), this.worldTransform.intDeviceY(yp), np);
    }

    public void fillPolygon(double[] xp, double[] yp) {
        this.g.fillPolygon(this.worldTransform.intDeviceX(xp), this.worldTransform.intDeviceY(yp), xp.length);
    }

    public void fillPolygon(Polypoint pp, int cfill, int cline) {
        int[] ix = this.worldTransform.intDeviceX(pp.getXPts());
        int[] iy = this.worldTransform.intDeviceY(pp.getYPts());
        this.g.setColor(new Color(cfill));
        this.g.fillPolygon(ix, iy, ix.length);
        this.g.setColor(new Color(cline));
        this.g.drawPolygon(ix, iy, ix.length);
    }

    public void setColor(SColor sc) {
        this.g.setColor(sc.getColor());
    }

    public void setColor(Color c) {
        this.g.setColor(c);
    }

    public void setColorWhite() {
        this.g.setColor(Color.white);
    }

    public void setColorRed() {
        this.g.setColor(Color.red);
    }

    public void setColorGreen() {
        this.g.setColor(Color.green);
    }

    public void setColorBlue() {
        this.g.setColor(Color.blue);
    }

    public void setColorBlack() {
        this.g.setColor(Color.black);
    }

    public void setColorGray() {
        this.g.setColor(Color.gray);
    }

    public void setColorCyan() {
        this.g.setColor(Color.cyan);
    }

    public void setColorMagenta() {
        this.g.setColor(Color.magenta);
    }

    public void setColorYellow() {
        this.g.setColor(Color.yellow);
    }

    public void setColorOrange() {
        this.g.setColor(Color.orange);
    }

    public void setColorDarkGray() {
        this.g.setColor(Color.darkGray);
    }

    public void drawWhiteLine(double width, double[] xp, double[] yp) {
        this.setColor(Color.white);
        this.setBasicStroke(3.0);
        this.drawPolyline(xp, yp, xp.length);
        this.resetStroke();
    }

    public void fillRectangle(double x, double y, Color c, int size) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        this.fillPixelRectangle(ix, iy, c, size);
    }

    public void fillRectangle(double x1, double y1, double x2, double y2, Color c) {
        int ix = this.powx(x1);
        int iy = this.powy(y2);
        int dx = this.powx(x2) - ix + 1;
        int dy = this.powy(y1) - iy + 1;
        this.g.setColor(c);
        this.g.fillRect(ix, iy, dx, dy);
    }

    public void fillPixelRectangle(int ix, int iy, Color c, int size) {
        this.g.setColor(c);
        int hs = size / 2;
        this.g.fillRect(ix - hs, iy - hs, size, size);
    }

    public void drawLine(double x0, double y0, double x1, double y1, Color col, double width, boolean widthIsPixels) {
        this.setBasicStroke(width);
        this.setColor(col);
        this.drawLine(x0, y0, x1, y1);
        this.resetStroke();
    }

    public void drawLine(Position p1, Position p2) {
        this.drawLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void drawLine(double x0, double y0, double x1, double y1) {
        int ix0 = this.powx(x0);
        int iy0 = this.powy(y0);
        int ix1 = this.powx(x1);
        int iy1 = this.powy(y1);
        this.g.drawLine(ix0, iy0, ix1, iy1);
    }

    public void drawCenteredBox(Position pos, int hx, int hy) {
        int ixc = this.powx(pos.getX());
        int iyc = this.powy(pos.getY());
        this.g.drawRect(ixc - hx, iyc - hy, 2 * hx, 2 * hy);
    }

    public void fillCenteredBox(Position pos, int hx, int hy) {
        int ixc = this.powx(pos.getX());
        int iyc = this.powy(pos.getY());
        this.g.fillRect(ixc - hx, iyc - hy, 2 * hx, 2 * hy);
    }

    public void drawFixedSizeLine(double x, double y, Color c, int idx, int idy, int wfac) {
        this.g.setColor(c);
        this.resetStroke();
        int ix = this.powx(x);
        int iy = this.powy(y);
        this.setBasicStroke(wfac);
        this.g.drawLine(ix, iy, ix + idx, iy + idy);
        this.resetStroke();
    }

    public void drawText(String s, double x, double y) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        this.g.drawString(s, ix, iy);
    }

    public void drawLineOffsetText(String s, double x, double y, int dx, int dy) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        this.g.drawLine(ix, iy, ix + dx, iy + dy);
        this.g.drawString(s, ix + dx, iy + dy);
    }

    public void drawString(String s, int x, int y) {
        this.g.drawString(s, x, y);
    }

    public void drawCenteredString(String s, int x, int y) {
        int w = this.stringWidth(s);
        this.g.drawString(s, x - w / 2, y);
    }

    public void drawLabel(String s, double x, double y, Color c) {
        this.g.setColor(c);
        this.drawLabel(s, x, y);
    }

    public void drawUpLabel(String s, double x, double y, Color c) {
        this.g.setColor(c);
        this.drawUpLabel(s, x, y);
    }

    public void drawUpLabel(String s, double x, double y) {
        this.g.setTransform(this.upTransform);
        int ix = this.powx(x);
        int iy = this.powy(y);
        this.g.drawString(s, ix + 6, iy);
        this.g.setTransform(this.normalTransform);
    }

    public void drawLabel(String s, double x, double y) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        this.drawLabelAt(s, ix, iy - 6);
    }

    public void drawCenteredLabel(String s, double x, double y) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        int hw = this.stringWidth(s) / 2;
        this.drawLabelAt(s, ix - hw, iy - 6);
    }

    public void drawXCenteredYTopAlignedLabel(String s, double x, double y) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        int hw = this.stringWidth(s) / 2;
        this.g.drawString(s, ix - hw, iy + 9);
    }

    public void drawLeftAlignedLabel(String s, double x, double y) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        this.drawLabelAt(s, ix + 6, iy + 6);
    }

    public void drawRightAlignedLabel(String s, double x, double y) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        int w = this.stringWidth(s);
        this.drawLabelAt(s, ix - w - 4, iy + 6);
    }

    public void drawXCenteredYBottomAlignedLabel(String s, double x, double y) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        int hw = this.stringWidth(s) / 2;
        this.drawLabelAt(s, ix - hw, iy - 2);
    }

    public void fillCenteredRectangle(double x, double y, double rx, double ry) {
        E.missing();
    }

    public void drawCircle(double x, double y, double r) {
        int ix1 = this.powx(x - r);
        int iy1 = this.powy(y + r);
        int ix2 = this.powx(x + r);
        int iy2 = this.powy(y - r);
        this.g.drawOval(ix1, iy1, ix2 - ix1, iy2 - iy1);
    }

    public void fillCircle(double x, double y, double r) {
        int ix1 = this.powx(x - r);
        int iy1 = this.powy(y + r);
        int ix2 = this.powx(x + r);
        int iy2 = this.powy(y - r);
        this.g.fillOval(ix1, iy1, ix2 - ix1, iy2 - iy1);
    }

    public void fillIntCircle(double x, double y, int r) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        this.g.fillOval(ix - r, iy - r, 2 * r, 2 * r);
    }

    public void drawIntCircle(double x, double y, int r) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        this.g.drawOval(ix - r, iy - r, 2 * r, 2 * r);
    }

    public void fillCenteredOval(double cx, double cy, double rx, double ry, Color cfill) {
        int ix1 = this.powx(cx - rx);
        int iy1 = this.powy(cy + ry);
        int ix2 = this.powx(cx + rx);
        int iy2 = this.powy(cy - ry);
        this.setColor(cfill);
        this.g.fillOval(ix1, iy1, ix2 - ix1, iy2 - iy1);
    }

    public void fillCenteredOval(Position pos, int ir) {
        int ixc = this.powx(pos.getX());
        int iyc = this.powy(pos.getY());
        this.g.fillOval(ixc - ir, iyc - ir, 2 * ir, 2 * ir);
    }

    public void drawCenteredOval(double cx, double cy, double rx, double ry, Color clin, double width, boolean widthIsPixels) {
        int ix1 = this.powx(cx - rx);
        int iy1 = this.powy(cy + ry);
        int ix2 = this.powx(cx + rx);
        int iy2 = this.powy(cy - ry);
        this.setBasicStroke(width);
        this.setColor(clin);
        this.g.drawOval(ix1, iy1, ix2 - ix1, iy2 - iy1);
        this.resetStroke();
    }

    public void drawCenteredOval(double cx, double cy, int hx, int hy) {
        int ixc = this.powx(cx);
        int iyc = this.powy(cy);
        this.g.drawOval(ixc - hx, iyc - hy, 2 * hx, 2 * hy);
    }

    public void drawCenteredOval(Position pos, int hx, int hy) {
        int ixc = this.powx(pos.getX());
        int iyc = this.powy(pos.getY());
        this.g.drawOval(ixc - hx, iyc - hy, 2 * hx, 2 * hy);
    }

    public void drawFilledOval(double cx, double cy, double rx, double ry, Color cfill, Color cborder, double width, boolean widthIsPixels) {
        int ix1 = this.powx(cx - rx);
        int iy1 = this.powy(cy + ry);
        int ix2 = this.powx(cx + rx);
        int iy2 = this.powy(cy - ry);
        this.setColor(cfill);
        this.g.fillOval(ix1, iy1, ix2 - ix1, iy2 - iy1);
        if (width > 0.5) {
            this.setBasicStroke(width);
            this.setColor(cborder);
            this.g.drawOval(ix1, iy1, ix2 - ix1, iy2 - iy1);
            this.resetStroke();
        }
    }

    public void drawFilledRectangle(double cx, double cy, int w, int h, Color cfill) {
        int ix = this.powx(cx);
        int iy = this.powy(cy);
        this.setColor(cfill);
        this.g.fillRect(ix - w / 2, iy - h / 2, w, h);
    }

    public void drawFilledRectangle(double cx, double cy, double rx, double ry, Color cfill, Color cborder, double width, boolean widthIsPixels) {
        int ix1 = this.powx(cx - rx);
        int iy1 = this.powy(cy + ry);
        int ix2 = this.powx(cx + rx);
        int iy2 = this.powy(cy - ry);
        this.setColor(cfill);
        this.g.fillRect(ix1, iy1, ix2 - ix1, iy2 - iy1);
        if (width > 0.5) {
            this.setBasicStroke(width);
            this.setColor(cborder);
            this.g.drawRect(ix1, iy1, ix2 - ix1, iy2 - iy1);
            this.resetStroke();
        }
    }

    public void drawRectangle(double cx, double cy, double rx, double ry, Color cborder, double width, boolean widthIsPixels) {
        int ix1 = this.powx(cx - rx);
        int iy1 = this.powy(cy + ry);
        int ix2 = this.powx(cx + rx);
        int iy2 = this.powy(cy - ry);
        this.setColor(cborder);
        this.g.drawRect(ix1, iy1, ix2 - ix1, iy2 - iy1);
    }

    public void drawRectangle(int[] xyxy) {
        this.g.drawRect(xyxy[0], xyxy[1], xyxy[2] - xyxy[0], xyxy[3] - xyxy[1]);
    }

    public void drawDashedRectangle(double cx, double cy, double rx, double ry) {
        int ix1 = this.powx(cx - rx);
        int iy1 = this.powy(cy + ry);
        int ix2 = this.powx(cx + rx);
        int iy2 = this.powy(cy - ry);
        this.setDashedStroke(1.0);
        this.g.drawRect(ix1, iy1, ix2 - ix1, iy2 - iy1);
        this.setNormalStroke();
    }

    public void drawOval(double cx, double cy, double rx, double ry, Color cborder, double width, boolean widthIsPixels) {
        int ix1 = this.powx(cx - rx);
        int iy1 = this.powy(cy + ry);
        int ix2 = this.powx(cx + rx);
        int iy2 = this.powy(cy - ry);
        this.setColor(cborder);
        this.g.drawOval(ix1, iy1, ix2 - ix1, iy2 - iy1);
    }

    public void drawCarrotSides(double xa, double ya, double ra, double xb, double yb, double rb) {
        double vx = -(yb - ya);
        double vy = xb - xa;
        double vl = Math.sqrt(vx * vx + vy * vy);
        if (vl <= 0.0) {
            vl = 1.0E-6;
        }
        this.drawLine(xa - ra * (vx /= vl), ya - ra * (vy /= vl), xb - rb * vx, yb - rb * vy);
        this.drawLine(xa + ra * vx, ya + ra * vy, xb + rb * vx, yb + rb * vy);
    }

    public int getLabelPoint(double[] xpts, double[] ypts) {
        int n = xpts.length;
        int iret = 0;
        int i = 0;
        while (i < n) {
            if (this.isShowing(xpts[i], ypts[i])) {
                iret = i;
                break;
            }
            ++i;
        }
        return iret;
    }

    public void drawOffsetCenteredLabel(String s, double x, double y) {
        int ix = this.powx(x);
        int iy = this.powy(y);
        iy += 8;
        int sw = this.stringWidth(s);
        if ((ix += 16) + sw > this.worldTransform.getCanvasWidth()) {
            ix = this.worldTransform.getCanvasWidth() - sw - 20;
        }
        this.g.setColor(Color.orange);
        this.g.fillRect(ix, iy - 16, sw + 10, 16);
        this.g.setColor(Color.black);
        this.g.drawRect(ix, iy - 16, sw + 10, 16);
        this.g.drawString(s, ix + 5, iy - 3);
    }

    public void drawLabelAt(String s, int ix, int iy) {
        int sw = this.stringWidth(s);
        this.g.setColor(Color.white);
        this.g.fillRect(ix, iy - 16, sw + 10, 16);
        this.g.setColor(Color.gray);
        this.g.drawRect(ix, iy - 16, sw + 10, 16);
        this.g.setColor(Color.black);
        this.g.drawString(s, ix + 5, iy - 3);
    }

    public int stringWidth(String s) {
        return this.g.getFontMetrics().stringWidth(s);
    }

    public void drawFilledTriangle(double x0, double y0, double x1, double y1, double x2, double y2, Color fillColor, Color color, double width, boolean b) {
        double[] xpts = new double[]{x0, x1, x2};
        double[] ypts = new double[]{y0, y1, y2};
        int[] ipx = this.worldTransform.intDeviceX(xpts);
        int[] ipy = this.worldTransform.intDeviceY(ypts);
        this.setColor(fillColor);
        this.g.fillPolygon(ipx, ipy, 3);
        this.setColor(color);
        if (!b) {
            E.warning("cant do world width lines");
        }
        if (width > 0.5) {
            this.setBasicStroke(width);
            this.g.drawPolygon(ipx, ipy, 3);
            this.resetStroke();
        }
    }

    public void drawCircle(Position position, double radius) {
        this.drawCircle(position.getX(), position.getY(), radius);
    }

    public void fillCircle(Position position, double radius) {
        this.fillCircle(position.getX(), position.getY(), radius);
    }

    public void paintTrash() {
        this.paintTrash(false);
    }

    public void paintTrash(boolean live) {
        int w = this.worldTransform.getCanvasWidth();
        int h = this.worldTransform.getCanvasHeight();
        int[][] xy = new int[][]{{w - 22, w - 4, w - 7, w - 19}, {h - 22, h - 22, h - 6, h - 6}};
        this.g.setColor(new Color(60, 190, 40));
        this.g.fillPolygon(xy[0], xy[1], xy[0].length);
        this.g.fillOval(w - 19, h - 8, 12, 5);
        if (live) {
            this.g.setColor(Color.red);
        } else {
            this.g.setColor(Color.darkGray);
        }
        this.g.fillOval(w - 22, h - 25, 18, 6);
        this.g.setColor(new Color(100, 240, 100));
        this.g.drawOval(w - 22, h - 25, 18, 6);
    }

    public void paintLiveTrash() {
        this.paintTrash(true);
    }

    public void fillBackground(Color c) {
        this.g.setColor(c);
        this.g.fillRect(0, 0, this.getCanvasWidth(), this.getCanvasHeight());
    }

    public void fillIntRectangle(int x, int y, int cw, int ch, Color color) {
        this.g.setColor(color);
        this.g.fillRect(x, y, cw, ch);
    }

    public void drawCenteredPixelLine(double x, double y, int[] xpts, int[] ypts) {
        int cx = this.powx(x);
        int cy = this.powy(y);
        int[] xp = new int[xpts.length];
        int[] yp = new int[xpts.length];
        int i = 0;
        while (i < xpts.length) {
            xp[i] = cx + xpts[i];
            yp[i] = cy + ypts[i];
            ++i;
        }
        this.g.drawPolyline(xp, yp, xp.length);
    }

    public void setIntColor(int icol) {
        this.setColor(new Color(icol));
    }

    public final void drawCable(Position pa, Position pcenter, Position pb) {
        double ax = pa.getX();
        double ay = pa.getY();
        double bx = pb.getX();
        double by = pb.getY();
        double cx = pcenter.getX();
        double cy = pcenter.getY();
        this.drawHalfCable(cx, cy, bx - ax, by - ay, bx, by, 14);
        this.drawHalfCable(cx, cy, ax - bx, ay - by, ax, ay, 14);
    }

    public final void drawHalfCable(double x0, double y0, double dx0, double dy0, double x1, double y1, int n) {
        double r = 0.03;
        double alpa = 0.1;
        double alpb = 0.4;
        double[] xp = new double[n];
        double[] yp = new double[n];
        xp[0] = x0;
        yp[0] = y0;
        double dx = dx0;
        double dy = dy0;
        int i = 1;
        while (i < n) {
            double alp0 = alpa + alpb * (double)i / (double)(n - 1);
            double vx = x1 - xp[i - 1];
            double vy = y1 - yp[i - 1];
            double vl = Math.sqrt(vx * vx + vy * vy);
            double alp = i == 1 ? alp0 / 2.0 : (i == n - 1 ? 1.0 : alp0);
            double dl = Math.sqrt(dx * dx + dy * dy);
            dx = (1.0 - alp) * dx / dl + alp * vx / vl;
            dy = (1.0 - alp) * dy / dl + alp * vy / vl;
            double f = (vl - r) / (double)(n - i);
            xp[i] = xp[i - 1] + f * dx;
            yp[i] = yp[i - 1] + f * dy;
            ++i;
        }
        this.drawPolyline(xp, yp, n);
    }

    public void setColorRange(double ca, double cb) {
        this.ctMin = ca;
        this.ctMax = cb;
    }

    public void setColorTable(Color[] ct) {
        this.colorTable = ct;
    }

    public void setDefaultColorTable() {
        this.colorTable = new Color[256];
        int i = 0;
        while (i < this.colorTable.length) {
            this.colorTable[i] = new Color(i, i, i);
            ++i;
        }
    }

    public void drawColoredCells(double[][][] mesh, double[] dat) {
        double dc;
        int nel = dat.length;
        if (this.colorTable == null) {
            this.setDefaultColorTable();
        }
        if ((dc = this.ctMax - this.ctMin) <= 0.0) {
            dc = 1.0;
        }
        int i = 0;
        while (i < nel) {
            int ic;
            double[] xb = mesh[i][0];
            double[] yb = mesh[i][1];
            double fc = (dat[i] - this.ctMin) / dc;
            if (fc < 0.0) {
                fc = 0.0;
            }
            if ((ic = (int)(255.0 * fc)) > 255) {
                ic = 255;
            }
            if (ic < 0) {
                ic = 0;
            }
            this.fillPolygon(xb, yb, xb.length, this.colorTable[ic]);
            ++i;
        }
    }

    public void drawColoredCells(double[][][] mesh, double[] dat, boolean[] mask) {
        double dc;
        int nel = dat.length;
        if (this.colorTable == null) {
            this.setDefaultColorTable();
        }
        if ((dc = this.ctMax - this.ctMin) <= 0.0) {
            dc = 1.0;
        }
        int i = 0;
        while (i < nel) {
            if (mask[i]) {
                int ic;
                double[] xb = mesh[i][0];
                double[] yb = mesh[i][1];
                double fc = (dat[i] - this.ctMin) / dc;
                if (fc < 0.0) {
                    fc = 0.0;
                }
                if ((ic = (int)(255.0 * fc)) > 255) {
                    ic = 255;
                }
                if (ic < 0) {
                    ic = 0;
                }
                this.fillPolygon(xb, yb, xb.length, this.colorTable[ic]);
            }
            ++i;
        }
    }

    public void paintLegend(int ileg, String s) {
        int w = this.worldTransform.getCanvasWidth();
        this.g.drawString(s, w - 80, 30 + 20 * ileg);
    }

    public double getXProj(double[] c) {
        return this.xProj(c[0], c[1], c[2]);
    }

    public double getYProj(double[] c) {
        return this.yProj(c[0], c[1], c[2]);
    }

    public double getZProj(double[] c) {
        return this.zProj(c[0], c[1], c[2]);
    }

    public double getXProj(float[] c) {
        return this.xProj(c[0], c[1], c[2]);
    }

    public double getYProj(float[] c) {
        return this.yProj(c[0], c[1], c[2]);
    }

    public double getZProj(float[] c) {
        return this.zProj(c[0], c[1], c[2]);
    }

    public double getZProj(double x, double y, double z) {
        return this.zProj(x, y, z);
    }

    public int getXProjPixel(double x, double y, double z) {
        double wx = this.xProj(x, y, z);
        int ix = this.powx(wx);
        return ix;
    }

    public int getYProjPixel(double x, double y, double z) {
        double wy = this.yProj(x, y, z);
        int iy = this.powy(wy);
        return iy;
    }

    double xProj(double x, double y, double z) {
        return this.worldTransform.xProj(x, y, z);
    }

    double yProj(double x, double y, double z) {
        return this.worldTransform.yProj(x, y, z);
    }

    private double zProj(double x, double y, double z) {
        return this.worldTransform.zProj(x, y, z);
    }

    public final void draw3DPoint(double x, double y, double z) {
        this.g.drawOval(this.powx(this.xProj(x, y, z)) - 2, this.powy(this.yProj(x, y, z)) - 2, 4, 4);
    }

    public final void fill3DOval(double x, double y, double z, int hw, int hh) {
        this.g.fillOval(this.powx(this.xProj(x, y, z)) - hw, this.powy(this.yProj(x, y, z)) - hh, 2 * hw, 2 * hh);
    }

    public final void draw3DCircle(double x, double y, double z, double r) {
        this.drawCircle(this.xProj(x, y, z), this.yProj(x, y, z), r);
    }

    public final void fill3DCircle(double x, double y, double z, double r) {
        this.fillCircle(this.xProj(x, y, z), this.yProj(x, y, z), r);
    }

    public final void draw3DMark(double x, double y, double z, int ityp, int isize) {
        int ix = this.powx(this.xProj(x, y, z));
        int iy = this.powy(this.yProj(x, y, z));
        this.g.drawLine(ix - isize, iy, ix + isize, iy);
        this.g.drawLine(ix, iy - isize, ix, iy + isize);
    }

    public final void draw3DZOffsetLine(double xa, double ya, double za, double xb, double yb, double zb, double z0, double dpdz) {
        double zpa = this.zProj(xa, ya, za);
        double zpb = this.zProj(xb, yb, zb);
        this.drawLine(this.xProj(xa, ya, za) + dpdz * (zpa - z0), this.yProj(xa, ya, za), this.xProj(xb, yb, zb) + dpdz * (zpb - z0), this.yProj(xb, yb, zb));
    }

    final void drawOutline(double xa, double ya, double ra, double xb, double yb, double rb) {
        double vx = -(yb - ya);
        double vy = xb - xa;
        double vl = Math.sqrt(vx * vx + vy * vy);
        if (vl <= 0.0) {
            vl = 1.0E-6;
        }
        this.drawLine(xa - ra * (vx /= vl), ya - ra * (vy /= vl), xb - rb * vx, yb - rb * vy);
        this.drawLine(xa + ra * vx, ya + ra * vy, xb + rb * vx, yb + rb * vy);
        this.drawLine(xa - ra * vx, ya - ra * vy, xa + ra * vx, ya + ra * vy);
        this.drawLine(xb - rb * vx, yb - rb * vy, xb + rb * vx, yb + rb * vy);
    }

    final void drawSides(double xa, double ya, double ra, double xb, double yb, double rb) {
        double vx = -(yb - ya);
        double vy = xb - xa;
        double vl = Math.sqrt(vx * vx + vy * vy);
        if (vl <= 0.0) {
            vl = 1.0E-6;
        }
        this.drawLine(xa - ra * (vx /= vl), ya - ra * (vy /= vl), xb - rb * vx, yb - rb * vy);
        this.drawLine(xa + ra * vx, ya + ra * vy, xb + rb * vx, yb + rb * vy);
    }

    final void fillOutline(double xa, double ya, double ra, double xb, double yb, double rb) {
        double vx = -(yb - ya);
        double vy = xb - xa;
        double vl = Math.sqrt(vx * vx + vy * vy);
        if (vl <= 0.0) {
            vl = 1.0E-6;
        }
        this.drawLine(xa - ra * (vx /= vl), ya - ra * (vy /= vl), xb - rb * vx, yb - rb * vy);
        this.drawLine(xa + ra * vx, ya + ra * vy, xb + rb * vx, yb + rb * vy);
        double[] xx = new double[]{xa - ra * vx, xb - rb * vx, xb + rb * vx, xa + ra * vx, xa - ra * vx};
        double[] yy = new double[]{ya - ra * vy, yb - rb * vy, yb + rb * vy, ya + ra * vy, ya - ra * vy};
        this.fillPolygon(xx, yy, 5);
    }

    public final void draw3DLine(double xa, double ya, double za, double xb, double yb, double zb) {
        this.drawLine(this.xProj(xa, ya, za), this.yProj(xa, ya, za), this.xProj(xb, yb, zb), this.yProj(xb, yb, zb));
    }

    public final void draw3DOutline(double xa, double ya, double za, double ra, double xb, double yb, double zb, double rb) {
        this.drawOutline(this.xProj(xa, ya, za), this.yProj(xa, ya, za), ra, this.xProj(xb, yb, zb), this.yProj(xb, yb, zb), rb);
    }

    public final void fill3DSegment(double xa, double ya, double za, double ra, double xb, double yb, double zb, double rb) {
        this.fillOutline(this.xProj(xa, ya, za), this.yProj(xa, ya, za), ra, this.xProj(xb, yb, zb), this.yProj(xb, yb, zb), rb);
    }

    public final void draw3DCarrot(double xa, double ya, double za, double ra, double xb, double yb, double zb, double rb) {
        double x2a = this.xProj(xa, ya, za);
        double y2a = this.yProj(xa, ya, za);
        double x2b = this.xProj(xb, yb, zb);
        double y2b = this.yProj(xb, yb, zb);
        this.drawSides(x2a, y2a, ra, x2b, y2b, rb);
        this.drawCircle(x2a, y2a, ra);
        this.drawCircle(x2b, y2b, rb);
    }

    public final void draw3DSegment(double xa, double ya, double za, double ra, double xb, double yb, double zb, double rb) {
        double x2a = this.xProj(xa, ya, za);
        double y2a = this.yProj(xa, ya, za);
        double x2b = this.xProj(xb, yb, zb);
        double y2b = this.yProj(xb, yb, zb);
        this.drawOutline(x2a, y2a, ra, x2b, y2b, rb);
    }

    public void drawString3D(double x, double y, double z, String lbl) {
        double x2a = this.xProj(x, y, z);
        double y2a = this.yProj(x, y, z);
        this.drawString(lbl, this.powx(x2a), this.powy(y2a));
    }

    public void drawString3DOffset(double x, double y, double z, String lbl, int idx, int idy) {
        double x2a = this.xProj(x, y, z);
        double y2a = this.yProj(x, y, z);
        this.drawString(lbl, this.powx(x2a) + idx, this.powy(y2a) + idy);
    }

    public final boolean visible3D(double x, double y, double z) {
        return this.worldTransform.visible3D(x, y, z);
    }

    public void draw3DMarks(float[][] ca, int n) {
        int i = 0;
        while (i < n) {
            int x = this.powx(this.xProj(ca[i][0], ca[i][1], ca[i][2]));
            int y = this.powy(this.yProj(ca[i][0], ca[i][1], ca[i][2]));
            this.g.fillRect(x, y, 1, 1);
            ++i;
        }
    }

    public void drawSome3DMarks(float[][] ca, int n, double pas) {
        double d = 0.0;
        while (d < (double)n) {
            int i = (int)d;
            int x = this.powx(this.xProj(ca[i][0], ca[i][1], ca[i][2]));
            int y = this.powy(this.yProj(ca[i][0], ca[i][1], ca[i][2]));
            this.g.fillRect(x, y, 1, 1);
            d += pas;
        }
    }

    public void draw3DIntMarks(float[][] ca, int n, int w, int h) {
        int i = 0;
        while (i < n) {
            int x = this.powx(this.xProj(ca[i][0], ca[i][1], ca[i][2]));
            int y = this.powy(this.yProj(ca[i][0], ca[i][1], ca[i][2]));
            this.g.fillRect(x, y, w, h);
            ++i;
        }
    }

    public void draw3DAreaMarks(float[][] ca, int n, double diam) {
        int i = 0;
        while (i < n) {
            int x = this.powx(this.xProj(ca[i][0], ca[i][1], ca[i][2]));
            int y = this.powy(this.yProj(ca[i][0], ca[i][1], ca[i][2]));
            this.g.fill(new Ellipse2D.Double(x, y, diam, diam));
            ++i;
        }
    }

    public void drawUpperSome3DMarks(float[][] ca, int n, double pas, double zp, double zd) {
        double d = 0.0;
        while (d < (double)n) {
            double f;
            int i = (int)d;
            double z = this.zProj(ca[i][0], ca[i][1], ca[i][2]);
            if (z < (f = (double)ca[i][4]) * zd + (1.0 - f) * zp) {
                int x = this.powx(this.xProj(ca[i][0], ca[i][1], ca[i][2]));
                int y = this.powy(this.yProj(ca[i][0], ca[i][1], ca[i][2]));
                this.g.fillRect(x, y, 1, 1);
            }
            d += pas;
        }
    }

    public void drawUpper3DIntMarks(float[][] ca, int n, int w, int h, double zp, double zd) {
        int i = 0;
        while (i < n) {
            double f;
            double z = this.zProj(ca[i][0], ca[i][1], ca[i][2]);
            if (z < (f = (double)ca[i][4]) * zd + (1.0 - f) * zp) {
                int x = this.powx(this.xProj(ca[i][0], ca[i][1], ca[i][2]));
                int y = this.powy(this.yProj(ca[i][0], ca[i][1], ca[i][2]));
                this.g.fillRect(x, y, w, h);
            }
            ++i;
        }
    }

    public void drawUpper3DAreaMarks(float[][] ca, int n, double diam, double zp, double zd) {
        int i = 0;
        while (i < n) {
            double f;
            double z = this.zProj(ca[i][0], ca[i][1], ca[i][2]);
            if (z < (f = (double)ca[i][4]) * zd + (1.0 - f) * zp) {
                int x = this.powx(this.xProj(ca[i][0], ca[i][1], ca[i][2]));
                int y = this.powy(this.yProj(ca[i][0], ca[i][1], ca[i][2]));
                this.g.fill(new Ellipse2D.Double(x, y, diam, diam));
            }
            ++i;
        }
    }

    public void draw3DPolygon(double[][] da) {
        int n = da.length;
        int[] xp = new int[n];
        int[] yp = new int[n];
        int i = 0;
        while (i < n) {
            xp[i] = this.powx(this.xProj(da[i][0], da[i][1], da[i][2]));
            yp[i] = this.powy(this.yProj(da[i][0], da[i][1], da[i][2]));
            ++i;
        }
        this.g.drawPolygon(xp, yp, n);
    }

    public void startBox() {
        this.wkBox = new Box();
    }

    public Box getBox() {
        return this.wkBox;
    }

    public void push3D(double x, double y, double z) {
        this.wkBox.push(this.xProj(x, y, z), this.yProj(x, y, z));
    }

    public void push(double x, double y) {
        this.wkBox.push(x, y);
    }

    public void drawAxes() {
    }

    public int screenDistance2(double x, double y, double z, int x2, int y2) {
        int xs = this.powx(this.xProj(x, y, z));
        int ys = this.powy(this.yProj(x, y, z));
        int dx = xs - x2;
        int dy = ys - y2;
        int d2 = dx * dx + dy * dy;
        return d2;
    }
}

