/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.content;

import org.catacomb.interlish.content.PrimitiveValue;

public class DoubleValue
extends PrimitiveValue {
    private double dble;
    private DoubleValue peer;

    public DoubleValue() {
        this.dble = 0.0;
    }

    public DoubleValue(double d) {
        this.dble = d;
    }

    public String toString() {
        return String.format("%.3g", new Double(this.dble));
    }

    public void setPeer(DoubleValue dv) {
        this.peer = dv;
        this.peer.reportableSetDouble(this.dble, this);
    }

    public void releasePeer() {
        this.peer = null;
    }

    public void silentSetDouble(double d) {
        this.dble = d;
        this.logChange();
        if (this.peer != null) {
            this.peer.silentSetDouble(d);
        }
    }

    public double getDouble() {
        double ret = 0.0;
        if (this.peer != null) {
            this.dble = ret = this.peer.getDouble();
        } else {
            ret = this.dble;
        }
        return ret;
    }

    public void setValue(double d) {
        this.reportableSetDouble(d, null);
    }

    public void reportableSetDouble(double d, Object src) {
        this.silentSetDouble(d);
        this.reportValueChange(src);
        if (this.peer != null) {
            this.peer.reportableSetDouble(d, src);
        }
    }

    public void copyFrom(DoubleValue src) {
        this.silentSetDouble(src.getDouble());
    }
}

