/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.content;

import java.util.ArrayList;
import org.catacomb.be.ChangeEvent;
import org.catacomb.interlish.content.BasicTouchTime;
import org.catacomb.interlish.structure.ChildListener;
import org.catacomb.interlish.structure.ParentReporter;
import org.catacomb.interlish.structure.TouchTimed;
import org.catacomb.interlish.structure.UseWatcher;
import org.catacomb.interlish.structure.Value;
import org.catacomb.interlish.structure.ValueWatcher;
import org.catacomb.report.E;

public class PrimitiveValue
implements Value,
TouchTimed,
ParentReporter {
    private BasicTouchTime touchTime = new BasicTouchTime();
    private ArrayList<ValueWatcher> watchers;
    private ArrayList<UseWatcher> useWatchers;
    private ChildListener childListener;
    String reportableID;
    private boolean able;
    private boolean reportingUse;

    public PrimitiveValue() {
        this.able = true;
    }

    public PrimitiveValue(boolean b) {
        this.able = b;
    }

    public void setAble(boolean b) {
        if (b != this.able) {
            this.able = b;
            this.reportValueChange(this);
        }
    }

    public boolean isAble() {
        return this.able;
    }

    @Override
    public void setChildListener(ChildListener cl, String srcid) {
        this.childListener = cl;
        this.reportableID = srcid;
    }

    public void removeChildListener() {
        this.childListener = null;
    }

    public void addValueWatcher(ValueWatcher vw) {
        if (this.watchers == null) {
            this.watchers = new ArrayList();
        }
        this.watchers.add(vw);
    }

    public void removeValueWatcher(ValueWatcher vw) {
        if (this.watchers == null) {
            E.warning("cant remove - not present");
        } else if (this.watchers.contains(vw)) {
            this.watchers.remove(vw);
        } else {
            E.warning("attempted to remove a watcher that isnt in the list");
        }
    }

    public void addUseWatcher(UseWatcher vw) {
        if (this.useWatchers == null) {
            this.useWatchers = new ArrayList();
        }
        this.useWatchers.add(vw);
    }

    public void removeUseWatcher(UseWatcher vw) {
        if (this.useWatchers == null) {
            E.warning("cant remove - not present");
        } else if (this.useWatchers.contains(vw)) {
            this.useWatchers.remove(vw);
        } else {
            E.warning("attempted to remove a watcher that isnt in the list");
        }
    }

    @Override
    public BasicTouchTime getTouchTime() {
        return this.touchTime;
    }

    public void reportValueChange(Object src) {
        if (this.watchers != null) {
            for (ValueWatcher w : this.watchers) {
                w.valueChangedBy(this, src);
            }
        }
        this.valueChanged();
    }

    public void reportUse(Object src) {
        if (!this.reportingUse) {
            this.reportingUse = true;
            if (this.useWatchers != null) {
                for (UseWatcher w : this.useWatchers) {
                    w.usedBy(this, src);
                }
            }
            this.reportingUse = false;
        }
    }

    public void logChange() {
        this.touchTime.now();
    }

    public boolean changedSince(TouchTimed tt) {
        return this.touchTime.isAfter(tt.getTouchTime());
    }

    public void editCompleted() {
        this.touchTime.now();
    }

    public void valueChanged() {
        if (this.childListener != null) {
            this.childListener.childChanged(new ChangeEvent(this.reportableID, this));
        }
    }
}

