/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.content;

import java.util.ArrayList;
import org.catacomb.datalish.SColor;

public class RShape {
    public static final int OPEN = 0;
    public static final int CLOSED = 1;
    public static final int FILLED = 2;
    double[] xpts;
    double[] ypts;
    double lineWidth;
    SColor lineColor;
    SColor fillColor;
    int closure;

    public RShape(double[] x, double[] y, double lineW, SColor lineC, SColor fillC, int rsc) {
        this.xpts = x;
        this.ypts = y;
        this.lineWidth = lineW;
        this.lineColor = lineC;
        this.fillColor = fillC;
        this.closure = rsc;
    }

    public double[] getXPts() {
        return this.xpts;
    }

    public double[] getYPts() {
        return this.ypts;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public SColor getLineColor() {
        return this.lineColor;
    }

    public SColor getFillColor() {
        return this.fillColor;
    }

    public int getOCF() {
        return this.closure;
    }

    public double meanRadius() {
        double d = 0.0;
        int i = 0;
        while (i < this.xpts.length) {
            d += Math.sqrt(this.xpts[i] * this.xpts[i] + this.ypts[i] * this.ypts[i]);
            ++i;
        }
        return d /= (double)this.xpts.length;
    }

    public ArrayList<double[]> getBoundarySegments() {
        ArrayList<double[]> ret = new ArrayList<double[]>();
        int i = 0;
        while (i < this.xpts.length - 1) {
            double[] seg = new double[]{this.xpts[i], this.ypts[i], this.xpts[i + 1], this.ypts[i + 1]};
            ret.add(seg);
            ++i;
        }
        if (this.closure == 1 || this.closure == 2) {
            int n = this.xpts.length;
            double[] cseg = new double[]{this.xpts[n - 1], this.ypts[n - 1], this.xpts[0], this.ypts[0]};
            ret.add(cseg);
        }
        return ret;
    }
}

