/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import org.catacomb.datalish.Box;
import org.catacomb.datalish.array.Array;
import org.catacomb.numeric.data.NumDataItem;

public class EventSequence
implements NumDataItem {
    String name;
    int nevent;
    double[] times;
    int[] channels;
    int maxch;

    public EventSequence(String s) {
        this.name = s;
        this.times = new double[10];
        this.channels = new int[10];
        this.maxch = 0;
    }

    @Override
    public String getUnit() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.name;
    }

    public void addEvent(double t, int ich) {
        if (this.nevent >= this.times.length) {
            int nn = this.nevent + this.nevent / 2 + 10;
            this.times = Array.extendDArray(this.times, this.nevent, nn);
            this.channels = Array.extendIArray(this.channels, this.nevent, nn);
        }
        this.times[this.nevent] = t;
        this.channels[this.nevent] = ich;
        ++this.nevent;
        if (ich > this.maxch) {
            this.maxch = ich;
        }
    }

    public int getNEvent() {
        return this.nevent;
    }

    public int[] getChannels() {
        return this.channels;
    }

    public double[] getTimes() {
        return this.times;
    }

    public Box getLimitBox() {
        Box ret = null;
        ret = this.nevent == 0 ? new Box() : new Box(this.times[0], 0.0, this.times[this.nevent - 1], (double)this.maxch + 1.0);
        return ret;
    }
}

