/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.difnet.calc;

import org.catacomb.be.Timestep;
import org.catacomb.numeric.difnet.DiffusibleQuantity;
import org.catacomb.numeric.difnet.DiffusionCalculator;
import org.catacomb.numeric.difnet.NetState;
import org.catacomb.numeric.difnet.NetStructure;
import org.catacomb.numeric.difnet.calc.NetMapLink;
import org.catacomb.numeric.difnet.calc.NetMapNode;
import org.catacomb.numeric.difnet.calc.OrderedNetMap;
import org.catacomb.numeric.math.Matrix;

public class NetDiffuser
implements DiffusionCalculator {
    int icall = 0;
    static final int IOK = 0;
    static final int IERROR = 1;
    OrderedNetMap orderedNetMap;

    public NetDiffuser(NetStructure dnetprop) {
        this.init(dnetprop);
    }

    @Override
    public void init(NetStructure dnetprop) {
        this.orderedNetMap = new OrderedNetMap(dnetprop);
    }

    public void printNet() {
        this.orderedNetMap.print();
    }

    public void printNet(NetState ns) {
        this.orderedNetMap.readState(ns);
        this.orderedNetMap.print();
    }

    @Override
    public void advance(NetState difnet, DiffusibleQuantity dq, Timestep tstep) {
        double dt = tstep.getDeltaT();
        difnet.setTime(difnet.getTime() + dt);
        if (difnet.isError()) {
            return;
        }
        this.orderedNetMap.readState(difnet);
        int ires = 0;
        ires = this.orderedNetMap.isAcyclic() && !difnet.forceFullMatrix() ? this.sparseNetDiffuse(this.orderedNetMap, dt) : this.fullNetDiffuse(this.orderedNetMap, dt);
        if (ires == 1) {
            this.orderedNetMap.print();
            difnet.setError();
        } else {
            this.orderedNetMap.writeState(difnet);
        }
        ++this.icall;
    }

    private int fullNetDiffuse(OrderedNetMap ordNM, double dt) {
        int iret = 0;
        NetMapNode[] node = ordNM.getNodes();
        int nnode = node.length;
        double[] rhs = new double[nnode];
        double[][] a = new double[nnode][nnode];
        boolean useIntrinsics = ordNM.getUseIntrinsics();
        int i = 0;
        while (i < nnode) {
            NetMapNode p = node[i];
            if (p.isFree()) {
                rhs[i] = p.appliedFlux * dt;
                int ndownLink = p.downLink.length;
                int j = 0;
                while (j < ndownLink) {
                    NetMapLink c = p.downLink[j];
                    double gdt = dt * c.conductance;
                    int n = i;
                    rhs[n] = rhs[n] + gdt * (c.nodeA.value - p.value - c.drive);
                    double cpgt = c.capacitance + gdt;
                    double[] dArray = a[i];
                    int n2 = i;
                    dArray[n2] = dArray[n2] + cpgt;
                    a[i][c.nodeA.index] = -cpgt;
                    if (useIntrinsics) {
                        int n3 = i;
                        rhs[n3] = rhs[n3] + dt * c.current;
                    }
                    ++j;
                }
                int nupLink = p.upLink.length;
                int j2 = 0;
                while (j2 < nupLink) {
                    NetMapLink c = p.upLink[j2];
                    double gdt = dt * c.conductance;
                    int n = i;
                    rhs[n] = rhs[n] + gdt * (c.nodeB.value - p.value + c.drive);
                    double cpgt = c.capacitance + gdt;
                    double[] dArray = a[i];
                    int n4 = i;
                    dArray[n4] = dArray[n4] + cpgt;
                    a[i][c.nodeB.index] = -cpgt;
                    if (useIntrinsics) {
                        int n5 = i;
                        rhs[n5] = rhs[n5] - dt * c.current;
                    }
                    ++j2;
                }
                if (p.appliedConductance > 0.0) {
                    double gdt = dt * p.appliedConductance;
                    int n = i;
                    rhs[n] = rhs[n] + gdt * (p.appliedDrive - p.value);
                    double[] dArray = a[i];
                    int n6 = i;
                    dArray[n6] = dArray[n6] + gdt;
                }
            } else {
                p.value = p.appliedValue;
                a[i][i] = 1.0;
            }
            ++i;
        }
        double[] d = Matrix.LUSolve(a, rhs);
        int i2 = 0;
        while (i2 < nnode) {
            ordNM.node[i2].value += d[i2];
            ++i2;
        }
        this.calculateFixedNodeCurrents(node);
        return iret;
    }

    private int sparseNetDiffuse(OrderedNetMap ordNM, double dt) {
        int ndownLink;
        NetMapNode p;
        int iret = 0;
        NetMapNode[] node = ordNM.getNodes();
        node[0].rhs = 0.0;
        int nnode = node.length;
        boolean useIntrinsics = ordNM.getUseIntrinsics();
        int i = nnode - 1;
        while (i >= 0) {
            p = node[i];
            ndownLink = p.downLink.length;
            int nupLink = p.upLink.length;
            if (p.isFree()) {
                double cpgt;
                double gdt;
                NetMapLink c;
                p.diag = 0.0;
                p.rhs = p.appliedFlux * dt;
                int j = 0;
                while (j < ndownLink) {
                    c = p.downLink[j];
                    gdt = dt * c.conductance;
                    p.rhs += gdt * (c.nodeA.value - p.value - c.drive);
                    cpgt = c.capacitance + gdt;
                    p.diag += cpgt;
                    c.wsB = -cpgt;
                    if (useIntrinsics) {
                        p.rhs += dt * c.current;
                    }
                    ++j;
                }
                j = 0;
                while (j < nupLink) {
                    c = p.upLink[j];
                    gdt = dt * c.conductance;
                    p.rhs += gdt * (c.nodeB.value - p.value + c.drive);
                    cpgt = c.capacitance + gdt;
                    p.diag += cpgt;
                    c.wsA = -cpgt;
                    if (useIntrinsics) {
                        p.rhs -= dt * c.current;
                    }
                    ++j;
                }
                if (p.appliedConductance > 0.0) {
                    double gdt2 = dt * p.appliedConductance;
                    p.rhs += gdt2 * (p.appliedDrive - p.value);
                    p.diag += gdt2;
                }
                j = nupLink - 1;
                while (j >= 0) {
                    c = p.upLink[j];
                    NetMapNode pk = c.nodeB;
                    if (pk.diag == 0.0) {
                        System.out.println("error - zero diag elt " + c);
                        iret = 1;
                    }
                    double ff = c.wsB / pk.diag;
                    p.rhs -= ff * pk.rhs;
                    int nkl = pk.downLink.length;
                    int m = 0;
                    while (m < nkl) {
                        p.diag -= ff * pk.downLink[m].wsA;
                        ++m;
                    }
                    --j;
                }
            } else {
                p.value = p.appliedValue;
                p.diag = 1.0;
                p.rhs = 0.0;
            }
            --i;
        }
        i = 0;
        while (i < nnode) {
            p = node[i];
            ndownLink = p.downLink.length;
            int j = 0;
            while (j < ndownLink) {
                p.rhs -= p.downLink[j].wsB * p.downLink[j].nodeA.rhs;
                ++j;
            }
            p.rhs /= p.diag;
            p.value += p.rhs;
            ++i;
        }
        this.calculateFixedNodeCurrents(node);
        return iret;
    }

    private void calculateFixedNodeCurrents(NetMapNode[] node) {
        int i = 0;
        while (i < node.length) {
            NetMapNode p = node[i];
            if (!p.isFree()) {
                NetMapLink c;
                p.flux = 0.0;
                int ndownLink = p.downLink.length;
                int nupLink = p.upLink.length;
                int j = 0;
                while (j < ndownLink) {
                    c = p.downLink[j];
                    p.flux -= c.conductance * (c.nodeA.value - p.value - c.drive);
                    ++j;
                }
                j = 0;
                while (j < nupLink) {
                    c = p.upLink[j];
                    p.flux -= c.conductance * (c.nodeB.value - p.value + c.drive);
                    ++j;
                }
            }
            ++i;
        }
    }
}

