/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.difnet.model;

import org.catacomb.numeric.difnet.DiffusibleQuantity;
import org.catacomb.numeric.difnet.StateLink;
import org.catacomb.numeric.difnet.StateNode;
import org.catacomb.numeric.difnet.StructureLink;
import org.catacomb.numeric.difnet.model.BasicStateNode;
import org.catacomb.numeric.difnet.model.BasicStructureLink;

public class BasicStateLink
implements StateLink {
    BasicStructureLink structure;
    BasicStateNode nodeA;
    BasicStateNode nodeB;
    double conductance;
    double capacitance;
    double drive;
    double intrinsicCurrent;

    public BasicStateLink(BasicStructureLink bsl, BasicStateNode bsna, BasicStateNode bsnb) {
        this.structure = bsl;
        this.nodeA = bsna;
        this.nodeB = bsnb;
        this.conductance = this.structure.getConductance();
        this.capacitance = this.structure.getCapacitance();
    }

    @Override
    public StateNode getNodeA() {
        return this.nodeA;
    }

    @Override
    public StateNode getNodeB() {
        return this.nodeB;
    }

    @Override
    public double getConductance(DiffusibleQuantity dq) {
        return this.conductance;
    }

    @Override
    public double getCapacitance(DiffusibleQuantity dq) {
        return this.capacitance;
    }

    @Override
    public double getIntrinsicCurrent(DiffusibleQuantity dq) {
        return this.intrinsicCurrent;
    }

    @Override
    public double getDrive(DiffusibleQuantity dq) {
        return this.drive;
    }

    @Override
    public StructureLink getStructureLink() {
        return this.structure;
    }
}

