/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.disc;

import java.util.ArrayList;
import java.util.HashMap;
import org.textensor.report.E;
import org.textensor.stochdiff.disc.Resolution;
import org.textensor.stochdiff.numeric.morph.TreePoint;

public class SegmentSlicer {
    TreePoint[] srcPoints;
    static final int FIXED = 1;
    static final int BALANCED = 2;
    int sdstyle;
    int maxnp;
    TreePoint[] outPoints;
    Resolution resolution;

    public SegmentSlicer(TreePoint[] sp) {
        this.srcPoints = sp;
    }

    public TreePoint[] getFixedWidthSlices(double dx, HashMap<String, Double> resHM) {
        this.sdstyle = 1;
        this.resolution = new Resolution(dx, resHM);
        this.maxnp = 20000;
        this.discretize();
        return this.getSlices();
    }

    public TreePoint[] getBalancedSlices(double disqrtr, int mnp) {
        this.sdstyle = 2;
        this.resolution = new Resolution(disqrtr, null);
        this.maxnp = mnp;
        this.discretize();
        return this.getSlices();
    }

    private TreePoint[] getSlices() {
        return this.outPoints;
    }

    private void discretize() {
        int np = this.srcPoints.length;
        double[][][] subdiv = new double[np][6][];
        int i = 0;
        while (i < np) {
            this.srcPoints[i].setWork(i);
            ++i;
        }
        int nnp = 0;
        int i2 = 0;
        while (i2 < np) {
            TreePoint cpa = this.srcPoints[i2];
            int j = 0;
            while (j < cpa.nnbr) {
                TreePoint cpb = cpa.nbr[j];
                if (cpa.getWork() < cpb.getWork()) {
                    if (this.sdstyle == 1) {
                        double localDelta;
                        double dab = cpa.distanceTo(cpb);
                        double distance_over_delta = dab / (localDelta = this.resolution.getLocalDelta(cpa, cpb));
                        int nadd = (int)distance_over_delta - 1;
                        if (nadd < 0) {
                            if (dab < 0.01) {
                                cpb.setSubAreaOf(cpa);
                                cpb.alignTop(cpa, cpa.largestNeighborNot(cpb), cpa.partBranchOffset);
                                cpa.partBranchOffset += 2.0 * cpb.r;
                            } else {
                                E.warning("distance between points is smaller than the desired element size " + dab + " " + localDelta + " " + cpa + " " + cpb);
                            }
                            nadd = 0;
                        }
                        double[] dpos = new double[nadd];
                        if (nadd > 0) {
                            int ii = 0;
                            while (ii < nadd) {
                                dpos[ii] = (1.0 + (double)ii) / ((double)nadd + 1.0);
                                ++ii;
                            }
                        }
                        subdiv[i2][j] = dpos;
                    } else if (this.sdstyle == 2) {
                        subdiv[i2][j] = this.getBalancedSubdivision(cpa, cpb);
                    } else {
                        E.error("unknown subdib style " + this.sdstyle);
                    }
                    nnp += subdiv[i2][j].length;
                }
                ++j;
            }
            ++i2;
        }
        if (np + nnp > this.maxnp) {
            E.error("not discretizing: needs too many points (" + (np + nnp) + ")");
            return;
        }
        TreePoint[] pr = new TreePoint[np + nnp];
        int i3 = 0;
        while (i3 < np) {
            pr[i3] = this.srcPoints[i3];
            ++i3;
        }
        int nxp = np;
        int i4 = 0;
        while (i4 < np) {
            TreePoint cpa = this.srcPoints[i4];
            int j = 0;
            while (j < cpa.nnbr) {
                double[] div = subdiv[i4][j];
                if (div != null && div.length > 0) {
                    TreePoint cpb = cpa.nbr[j];
                    String newRegion = cpa.regionClassWith(cpb);
                    String newID = cpa.segmentIDWith(cpb);
                    TreePoint clast = cpa;
                    int id = 0;
                    while (id < div.length) {
                        TreePoint cp = new TreePoint();
                        cp.locateBetween(cpa, cpb, div[id]);
                        cp.addNeighbor(clast);
                        pr[nxp++] = cp;
                        if (id == 0) {
                            cpa.replaceNeighbor(cpb, cp);
                        } else {
                            clast.addNeighbor(cp);
                        }
                        if (id == div.length - 1) {
                            cpb.replaceNeighbor(cpa, cp);
                            cp.addNeighbor(cpb);
                            cp.setIDWith(cpb, newID);
                            cp.setRegionWith(cpb, newRegion);
                        }
                        clast.setIDWith(cp, newID);
                        clast.setRegionWith(cp, newRegion);
                        cp.setIDWith(clast, newID);
                        cp.setRegionWith(clast, newRegion);
                        clast = cp;
                        ++id;
                    }
                }
                ++j;
            }
            ++i4;
        }
        ArrayList<TreePoint[]> cns = new ArrayList<TreePoint[]>();
        int i5 = 0;
        while (i5 < np) {
            TreePoint cpa = this.srcPoints[i5];
            if (cpa.hasOffsetChildren()) {
                for (TreePoint tpoc : cpa.getOffsetChildren()) {
                    TreePoint tpn = this.findNearest(cpa, tpoc);
                    if (tpn == null) continue;
                    TreePoint[] tpa = new TreePoint[]{tpn, tpoc};
                    cns.add(tpa);
                }
            }
            ++i5;
        }
        for (TreePoint[] tpa : cns) {
            E.info("patching in " + tpa[1] + " as child of nearest in parent segment: " + tpa[0]);
            TreePoint.neighborize(tpa[0], tpa[1]);
        }
        this.outPoints = pr;
    }

    private double[] getFixedSubdivision(TreePoint cpa, TreePoint cpb) {
        double dab = cpa.distanceTo(cpb);
        double localDelta = this.resolution.getLocalDelta(cpa, cpb);
        int nadd = (int)Math.round(dab / localDelta) - 1;
        double[] dpos = new double[nadd];
        if (nadd > 0) {
            int i = 0;
            while (i < nadd) {
                dpos[i] = (1.0 + (double)i) / ((double)nadd + 1.0);
                ++i;
            }
        }
        return dpos;
    }

    private double[] getBalancedSubdivision(TreePoint cpa, TreePoint cpb) {
        double dab = cpa.distanceTo(cpb);
        double ra = cpa.r;
        double rb = cpb.r;
        double localDelta = this.resolution.getLocalDelta(cpa, cpb);
        double fdist = 0.0;
        fdist = rb != ra ? 0.6666666666666666 * dab / (rb - ra) * (Math.pow(rb, 1.5) - Math.pow(ra, 1.5)) : dab * Math.sqrt(ra);
        int nadd = (int)(fdist / localDelta);
        double[] dpos = new double[nadd];
        if (nadd > 0) {
            if (Math.abs((ra - rb) / (ra + rb)) < 0.01) {
                int i = 0;
                while (i < nadd) {
                    dpos[i] = (1.0 + (double)i) / ((double)nadd + 1.0);
                    ++i;
                }
            } else {
                double delf = fdist / (double)(nadd + 1);
                double ffa = (rb - ra) / dab;
                double xa = ra / ffa;
                double xb = rb / ffa;
                double x = xa;
                int i = 0;
                while (i < nadd + 1) {
                    double ttt = delf * ffa * 3.0 / 2.0 + Math.pow(ffa * x, 1.5);
                    double dx = Math.pow(ttt, 0.6666666666666666) / ffa - x;
                    x += dx;
                    if (i < nadd) {
                        dpos[i] = (x - xa) / dab;
                    }
                    ++i;
                }
                if (Math.abs(xb - x) > 1.0E-5) {
                    E.error("segment division " + xa + " " + xb + " " + x + " " + nadd + " " + dab + " " + ra + " " + rb);
                }
            }
        }
        return dpos;
    }

    public TreePoint findNearest(TreePoint rt, TreePoint tgt) {
        TreePoint ret = rt;
        double dg = rt.distanceTo(tgt);
        int i = 0;
        while (i < rt.nnbr) {
            double ds = rt.distanceTo(tgt);
            TreePoint tpp = rt;
            TreePoint tpn = rt.nbr[i];
            while (tpn != null && tpn.distanceTo(tgt) < ds) {
                ds = tpn.distanceTo(tgt);
                TreePoint tpprev = tpp;
                tpp = tpn;
                tpn = tpn.oppositeNeighbor(tpprev);
            }
            if (ds < dg) {
                ret = tpp;
                dg = ds;
            }
            ++i;
        }
        return ret;
    }
}

