/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import java.util.HashMap;
import org.textensor.report.E;
import org.textensor.stochdiff.model.MorphPoint;
import org.textensor.stochdiff.model.Segment;

public class EndPoint
extends MorphPoint {
    public String on;
    public String at;
    public double atFraction;

    public EndPoint() {
        this.atFraction = -1.0;
    }

    public EndPoint(String id, double x, double y, double z, double r) {
        super(id, x, y, z, r);
    }

    public void resolve(HashMap<String, Segment> segmentHM, MorphPoint ep) {
        if (this.on != null) {
            if (segmentHM.containsKey(this.on)) {
                Segment tgtSeg = segmentHM.get(this.on);
                if (this.at != null) {
                    if (this.at.equals("start")) {
                        this.pointConnect(tgtSeg.getStart());
                    } else if (this.at.equals("end")) {
                        this.pointConnect(tgtSeg.getEnd());
                    } else {
                        E.error("connection to segment: at value can only be 'start' or 'end', not " + this.at);
                    }
                } else if (this.atFraction < 0.0) {
                    E.error("must either set 'at' or 'atFraction' if 'on' is specified");
                } else if (this.atFraction < 1.0E-4) {
                    this.pointConnect(tgtSeg.getStart());
                } else if (this.atFraction > 0.9999) {
                    this.pointConnect(tgtSeg.getEnd());
                } else {
                    tgtSeg.checkResolved(segmentHM);
                    tgtSeg.checkHasPositions();
                    this.interiorPointConnect(tgtSeg, this.atFraction, ep);
                }
            } else {
                E.error("point refers to segment " + this.on + " but that segment cant be found");
            }
        }
    }

    private void supplySize(double xp, double yp, double zp, double rp) {
        if (Double.isNaN(this.x)) {
            this.x = xp;
        }
        if (Double.isNaN(this.y)) {
            this.y = yp;
        }
        if (Double.isNaN(this.z)) {
            this.z = zp;
        }
        if (Double.isNaN(this.r)) {
            this.r = rp;
        }
    }

    public boolean radiiDiffer(MorphPoint mp) {
        boolean ret = true;
        if (Math.abs((this.r - mp.r) / (this.r + mp.r)) < 1.0E-4) {
            ret = false;
        }
        return ret;
    }

    private void pointConnect(MorphPoint tgtEP) {
        this.supplySize(tgtEP.x, tgtEP.y, tgtEP.z, tgtEP.r);
        if (this.radiiDiffer(tgtEP)) {
            tgtEP.addNeighbor(this);
            this.addNeighbor(tgtEP);
        } else {
            this.r_peerPoint = tgtEP;
        }
    }

    public void interiorPointConnect(Segment tgtSeg, double f, MorphPoint twds) {
        EndPoint st = tgtSeg.getStart();
        EndPoint ed = tgtSeg.getEnd();
        double wf = 1.0 - f;
        double cx = wf * st.x + f * ed.x;
        double cy = wf * st.y + f * ed.y;
        double cz = wf * st.z + f * ed.z;
        double cr = wf * st.r + f * ed.r;
        double dx = twds.x - cx;
        double dy = twds.y - cy;
        double dz = twds.z - cz;
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.supplySize(cx + cr * dx / d, cy + cr * dy / d, cz * cr * dz / d, cr);
        st.addOffsetChild(this);
    }

    public String writePos() {
        return "(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }
}

