/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.textensor.report.E;
import org.textensor.stochdiff.ResultWriter;
import org.textensor.stochdiff.disc.SpineLocator;
import org.textensor.stochdiff.disc.TreeBoxDiscretizer;
import org.textensor.stochdiff.inter.SDState;
import org.textensor.stochdiff.inter.StateReader;
import org.textensor.stochdiff.model.Discretization;
import org.textensor.stochdiff.model.InitialConditions;
import org.textensor.stochdiff.model.Morphology;
import org.textensor.stochdiff.model.OutputScheme;
import org.textensor.stochdiff.model.OutputSet;
import org.textensor.stochdiff.model.ReactionScheme;
import org.textensor.stochdiff.model.SDRun;
import org.textensor.stochdiff.model.StimulationSet;
import org.textensor.stochdiff.numeric.chem.ReactionTable;
import org.textensor.stochdiff.numeric.chem.StimulationTable;
import org.textensor.stochdiff.numeric.morph.TreePoint;
import org.textensor.stochdiff.numeric.morph.VolumeGrid;
import org.textensor.util.ArrayUtil;

public abstract class BaseCalc {
    public SDRun sdRun;
    ReactionTable reactionTable;
    VolumeGrid volumeGrid;
    StimulationTable stimulationTable;
    double[] baseConcentrations;
    double[][] regionConcentrations;
    double[][] regionSurfaceDensities;
    protected ResultWriter resultWriter;
    String[] speciesList;
    public int[] ispecout;
    public static final int BINOMIAL = 0;
    public static final int POISSON = 1;
    public static final int INDEPENDENT = 0;
    public static final int SHARED = 1;
    public static final int PARTICLE = 2;
    int distID = 0;
    protected int algoID = 0;
    public boolean writeConcentration = false;
    public String n_list;
    public String dt_list;
    public String filename_list;
    public String specie_names_list;
    public String region_list;
    protected int[][] specIndexesOut;
    protected String[] regionsOut;
    protected double[] dtsOut;
    protected String[] fnmsOut;
    protected String[][] specNamesOut;

    public BaseCalc(SDRun sdr) {
        this.sdRun = sdr;
    }

    protected String stringd(double d) {
        if (d == 0.0) {
            return "0.0 ";
        }
        return String.format("%.5g ", new Double(d));
    }

    protected String stringi(int d) {
        if (d == 0) {
            return "00 ";
        }
        return String.format("%d ", new Integer(d));
    }

    public void extractTables() {
        this.distID = this.sdRun.getDistributionID();
        this.algoID = this.sdRun.getAlgorithmID();
        ReactionScheme rsch = this.sdRun.getReactionScheme();
        this.reactionTable = rsch.makeReactionTable();
        StimulationSet stim = this.sdRun.getStimulationSet();
        this.stimulationTable = stim.makeStimulationTable(this.reactionTable);
        InitialConditions icons = this.sdRun.getInitialConditions();
        this.speciesList = this.reactionTable.getSpeciesIDs();
        this.baseConcentrations = icons.getDefaultNanoMolarConcentrations(this.speciesList);
        String specout = this.sdRun.outputSpecies;
        if (specout == null || specout.equals("all")) {
            this.ispecout = new int[this.speciesList.length];
            int i = 0;
            while (i < this.speciesList.length) {
                this.ispecout[i] = i;
                ++i;
            }
        } else {
            this.ispecout = specout.length() == 0 || specout.equals("none") ? new int[0] : this.getIndices(specout, this.speciesList);
        }
        String oq = this.sdRun.outputQuantity;
        if (oq != null) {
            if (oq.equals("NUMBER")) {
                this.writeConcentration = false;
            } else if (oq.equals("CONCENTRATION")) {
                this.writeConcentration = true;
            } else {
                E.warning("Unrecognized output quantity: " + oq + " - need either NUMBER or CONCENTRATION");
            }
        }
    }

    public int[] getIndices(String matchString, String[] idlist) {
        HashMap<String, Integer> isdhm = new HashMap<String, Integer>();
        int i = 0;
        while (i < idlist.length) {
            isdhm.put(idlist[i], i);
            ++i;
        }
        StringTokenizer st = new StringTokenizer(matchString, " ,");
        ArrayList<Integer> wk = new ArrayList<Integer>();
        while (st.hasMoreTokens()) {
            String so = st.nextToken();
            if (isdhm.containsKey(so)) {
                wk.add((Integer)isdhm.get(so));
                continue;
            }
            E.warning("Unknown output species " + so + " (requested or output but not in reaction scheme)");
        }
        int[] ret = new int[wk.size()];
        int i2 = 0;
        while (i2 < wk.size()) {
            ret[i2] = (Integer)wk.get(i2);
            ++i2;
        }
        return ret;
    }

    public void extractOutputScheme(ReactionTable rtab) {
        OutputScheme os = this.sdRun.getOutputScheme();
        int nos = os.outputSets.size();
        this.regionsOut = new String[nos];
        this.dtsOut = new double[nos];
        this.fnmsOut = new String[nos];
        this.specNamesOut = new String[nos][];
        this.specIndexesOut = new int[nos][];
        String[] specieIDs = rtab.getSpeciesIDs();
        int nspec = specieIDs.length;
        E.info("extracting output scheme " + os.outputSets.size() + " " + nspec);
        int i = 0;
        while (i < os.outputSets.size()) {
            OutputSet oset = os.outputSets.get(i);
            if (oset.hasdt()) {
                this.dtsOut[i] = oset.getdt();
            } else {
                int n = i;
                this.dtsOut[n] = this.dtsOut[n] + this.sdRun.fixedStepDt;
            }
            this.fnmsOut[i] = oset.getFname();
            this.specNamesOut[i] = oset.getNamesOfOutputSpecies();
            this.regionsOut[i] = oset.hasRegion() ? oset.getRegion() : "default";
            this.specIndexesOut[i] = new int[this.specNamesOut[i].length];
            int k = 0;
            while (k < this.specNamesOut[i].length) {
                int kq = 0;
                while (kq < nspec) {
                    if (this.specNamesOut[i][k].equalsIgnoreCase(specieIDs[kq])) {
                        this.specIndexesOut[i][k] = kq;
                    }
                    ++kq;
                }
                ++k;
            }
            ++i;
        }
    }

    public void extractGrid() {
        double d2d;
        Morphology morph = this.sdRun.getMorphology();
        TreePoint[] tpa = morph.getTreePoints();
        Discretization disc = this.sdRun.getDiscretization();
        double d = disc.defaultMaxElementSide;
        if (d <= 0.0) {
            d = 1.0;
        }
        double[] candidate_grid_sizes = new double[tpa.length];
        int i = 0;
        while (i < tpa.length) {
            double diameter = tpa[i].r * 2.0;
            double denominator = 1.0;
            while (diameter / denominator > d) {
                denominator += 2.0;
            }
            candidate_grid_sizes[i] = diameter / denominator;
            ++i;
        }
        double min_grid_size = d;
        int i2 = 0;
        while (i2 < tpa.length) {
            if (candidate_grid_sizes[i2] < min_grid_size) {
                min_grid_size = candidate_grid_sizes[i2];
            }
            ++i2;
        }
        d = min_grid_size;
        E.info("subvolume grid size is: " + min_grid_size);
        TreeBoxDiscretizer tbd = new TreeBoxDiscretizer(tpa);
        int vgg = 0;
        String sg = this.sdRun.geometry;
        if (sg != null) {
            if (sg.toLowerCase().equals("2d")) {
                vgg = 0;
            } else if (sg.toLowerCase().equals("3d")) {
                vgg = 1;
            } else {
                E.warning("unrecognized geometry " + sg + " should be 2D or 3D");
            }
        }
        if ((d2d = this.sdRun.depth2D) <= 0.0) {
            d2d = 0.5;
        }
        this.volumeGrid = tbd.buildGrid(d, disc.getResolutionHM(), vgg, d2d);
        SpineLocator spineloc = new SpineLocator(this.sdRun.spineSeed, morph.getSpineDistribution(), disc.spineDeltaX);
        spineloc.addSpinesTo(this.volumeGrid);
        this.volumeGrid.fix();
        this.makeRegionConcentrations(this.volumeGrid.getRegionLabels());
        this.makeRegionSurfaceDensities(this.volumeGrid.getRegionLabels());
    }

    public final boolean useBinomial() {
        return this.distID == 0;
    }

    public final boolean usePoisson() {
        return this.distID == 1;
    }

    public final boolean doIndependent() {
        return this.algoID == 0;
    }

    public final boolean doShared() {
        return this.algoID == 1;
    }

    public final boolean doParticle() {
        return this.algoID == 2;
    }

    public double[] getNanoMolarConcentrations() {
        return this.baseConcentrations;
    }

    public double[][] getRegionConcentrations() {
        if (this.regionConcentrations == null) {
            this.extractGrid();
        }
        return this.regionConcentrations;
    }

    public double[][] getRegionSurfaceDensities() {
        return this.regionSurfaceDensities;
    }

    public double[][] getRevisedRegionConcentrations() {
        if (this.regionConcentrations == null) {
            this.extractGrid();
        }
        this.makeRegionConcentrations(this.volumeGrid.getRegionLabels());
        return this.regionConcentrations;
    }

    public double[][] getRevisedRegionSurfaceDensities() {
        this.makeRegionSurfaceDensities(this.volumeGrid.getRegionLabels());
        return this.regionSurfaceDensities;
    }

    private void makeRegionConcentrations(String[] sra) {
        InitialConditions icons = this.sdRun.getInitialConditions();
        int nc = this.baseConcentrations.length;
        double[][] ret = new double[sra.length][];
        int i = 0;
        while (i < sra.length) {
            ret[i] = new double[this.baseConcentrations.length];
            int j = 0;
            while (j < nc) {
                ret[i][j] = this.baseConcentrations[j];
                ++j;
            }
            if (icons.hasConcentrationsFor(sra[i])) {
                double[] wk = icons.getRegionConcentrations(sra[i], this.speciesList);
                int j2 = 0;
                while (j2 < nc) {
                    if (wk[j2] >= 0.0) {
                        ret[i][j2] = wk[j2];
                    }
                    ++j2;
                }
            }
            ++i;
        }
        this.regionConcentrations = ret;
    }

    private void makeRegionSurfaceDensities(String[] sra) {
        InitialConditions icons = this.sdRun.getInitialConditions();
        double[][] ret = new double[sra.length][];
        int i = 0;
        while (i < sra.length) {
            ret[i] = (double[])(icons.hasSurfaceDensitiesFor(sra[i]) ? icons.getRegionSurfaceDensities(sra[i], this.speciesList) : null);
            ++i;
        }
        this.regionSurfaceDensities = ret;
    }

    public long getCalculationSeed() {
        long ret = this.sdRun.simulationSeed;
        if (ret <= 0L) {
            ret = (long)(100000.0 * Math.random());
        }
        return ret;
    }

    public ReactionTable getReactionTable() {
        if (this.reactionTable == null) {
            this.extractTables();
        }
        return this.reactionTable;
    }

    public StimulationTable getStimulationTable() {
        if (this.stimulationTable == null) {
            this.extractTables();
        }
        return this.stimulationTable;
    }

    public VolumeGrid getVolumeGrid() {
        if (this.volumeGrid == null) {
            this.extractGrid();
        }
        return this.volumeGrid;
    }

    public void setResultWriter(ResultWriter rw) {
        this.resultWriter = rw;
        this.resultWriter.init("cctdif2d", 1);
    }

    public abstract void run();

    public abstract long getParticleCount();

    public double[][] readInitialState(String fnm, int nel, int nspec, String[] specids) {
        String sdata = this.resultWriter.readSibling(fnm);
        SDState sds = StateReader.readStateString(sdata);
        double[][] ret = null;
        if (sds.nel == nel && sds.nspec == nspec) {
            if (ArrayUtil.arraysMatch(sds.specids, specids)) {
                ret = sds.getData();
            } else {
                E.error("initial conditions species mismatch ");
                int i = 0;
                while (i < specids.length) {
                    E.info("species " + i + " " + specids[i] + " " + sds.specids[i]);
                    ++i;
                }
            }
        } else {
            E.error("initial conditions file does not match model: elements " + nel + ", " + sds.nel + "  species: " + nspec + ", " + sds.nspec);
        }
        return ret;
    }
}

