/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.morph;

import java.util.ArrayList;
import org.textensor.report.E;
import org.textensor.stochdiff.geom.Position;
import org.textensor.stochdiff.numeric.morph.ElementConnection;

public class VolumeElement {
    String label;
    String region;
    double cx;
    double cy;
    double cz;
    double volume;
    double deltaZ;
    double exposedArea;
    private int icache;
    ArrayList<ElementConnection> connections = new ArrayList();
    Position[] boundary;
    Position[] surfaceBoundary = null;
    boolean fixcon = false;
    boolean submembrane = false;
    String groupID = null;
    double alongArea;
    double sideArea;
    double topArea;

    public boolean isSubmembrane() {
        return this.submembrane;
    }

    public void setSubmembrane() {
        this.submembrane = true;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public String getLabel() {
        return this.label;
    }

    public void setRegion(String s) {
        this.region = s;
    }

    public String getRegion() {
        return this.region;
    }

    public ArrayList<ElementConnection> getConnections() {
        this.fixcon = true;
        return this.connections;
    }

    public void setCenterPosition(double x, double y, double z) {
        this.cx = x;
        this.cy = y;
        this.cz = z;
    }

    public void setVolume(double v) {
        this.volume = v;
    }

    public void setDeltaZ(double d) {
        this.deltaZ = d;
    }

    public void setExposedArea(double ea) {
        this.exposedArea = ea;
    }

    public void coupleTo(VolumeElement vx, double ca) {
        if (this.fixcon) {
            E.warning("adding a connection after they've already been used?");
        }
        this.connections.add(new ElementConnection(this, vx, ca));
    }

    public double getVolume() {
        return this.volume;
    }

    public double getExposedArea() {
        return this.exposedArea;
    }

    public double getX() {
        return this.cx;
    }

    public double getY() {
        return this.cy;
    }

    public double getZ() {
        return this.cz;
    }

    public boolean getSubmembrane() {
        return this.submembrane;
    }

    public void cache(int ind) {
        this.icache = ind;
    }

    public int getCached() {
        return this.icache;
    }

    public void setBoundary(Position[] pbdry) {
        this.boundary = pbdry;
    }

    public void setSurfaceBoundary(Position[] psb) {
        this.surfaceBoundary = psb;
    }

    public Position[] getSurfaceBoundary() {
        return this.surfaceBoundary;
    }

    public String getAsText() {
        StringBuffer sb = new StringBuffer();
        if (this.boundary != null) {
            Position[] positionArray = this.boundary;
            int n = this.boundary.length;
            int n2 = 0;
            while (n2 < n) {
                Position p = positionArray[n2];
                sb.append(String.format(" (%.5g %.5g %.5g) ", p.getX(), p.getY(), p.getZ()));
                ++n2;
            }
        } else {
            sb.append(String.format(" (%.5g %.5g %.5g) ", this.cx, this.cy, this.cz));
        }
        return sb.toString();
    }

    public String getAsPlainText() {
        StringBuffer sb = new StringBuffer();
        if (this.boundary != null) {
            Position[] positionArray = this.boundary;
            int n = this.boundary.length;
            int n2 = 0;
            while (n2 < n) {
                Position p = positionArray[n2];
                sb.append(String.format(" %.5g %.5g %.5g", p.getX(), p.getY(), p.getZ()));
                ++n2;
            }
        } else {
            sb.append(String.format(" %.5g %.5g %.5g", this.cx, this.cy, this.cz));
        }
        sb.append(String.format(" %.5g %.5g", this.volume, this.deltaZ));
        return sb.toString();
    }

    public String getHeadings() {
        StringBuffer sb = new StringBuffer();
        if (this.boundary != null) {
            int i = 0;
            while (i < this.boundary.length) {
                sb.append(" x" + i + " y" + i + " z" + i);
                ++i;
            }
        } else {
            sb.append(" cx cy cz");
        }
        sb.append(" volume deltaZ");
        return sb.toString();
    }

    public void setAlongArea(double d) {
        this.alongArea = d;
    }

    public double getAlongArea() {
        return this.alongArea;
    }

    public void setSideArea(double d) {
        this.sideArea = d;
    }

    public double getSideArea() {
        return this.sideArea;
    }

    public void setTopArea(double d) {
        this.topArea = d;
    }

    public double getTopArea() {
        return this.topArea;
    }

    public void setGroupID(String lroot) {
        this.groupID = lroot;
    }

    public String getGroupID() {
        return this.groupID;
    }
}

