/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.pool;

import org.textensor.report.E;
import org.textensor.stochdiff.model.SDRun;
import org.textensor.stochdiff.numeric.math.Column;
import org.textensor.stochdiff.numeric.pool.DeterministicPoolCalc;

public class ForwardEulerPoolCalc
extends DeterministicPoolCalc {
    public ForwardEulerPoolCalc(SDRun sdm) {
        super(sdm);
    }

    @Override
    public double advance() {
        Column rates = this.rtab.getRateColumn(this.mconc);
        Column prod = this.rtab.getProductionMatrix().times(rates);
        this.mconc.incrementBy(prod.times(this.dt));
        this.mconc.positivize();
        E.info(" advanced fepc " + this.time);
        this.mconc.print();
        return this.dt;
    }

    @Override
    public long getParticleCount() {
        return 0L;
    }
}

