/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.stochastic;

import org.textensor.report.E;
import org.textensor.stochdiff.numeric.stochastic.BinomialTable;

public final class NGoTable {
    double lnp;
    int nparticle;
    double[] cprob;
    int ncprob;
    int mode;

    public NGoTable(int n, double lnp0, int m) {
        this.lnp = lnp0;
        this.nparticle = n;
        this.mode = m;
        double p = Math.exp(this.lnp);
        double q = 1.0 - p;
        double lnq = Math.log(q);
        if (this.mode == 0) {
            BinomialTable btab = BinomialTable.getTable();
            double[] wk = new double[n + 1];
            double c = 0.0;
            this.ncprob = -1;
            int i = n;
            while (i >= 0) {
                double pn = Math.exp((double)i * this.lnp + (double)(n - i) * lnq) * btab.ncm(n, i);
                wk[i] = c += pn;
                if (this.ncprob < 0 && c > 1.0E-11) {
                    this.ncprob = i;
                }
                --i;
            }
            if (Math.abs(1.0 - c) > 1.0E-11) {
                E.error("cumulative probability miscount? " + c + " for n, p, nkept " + n + " " + p + " " + this.ncprob);
            }
            this.cprob = new double[this.ncprob + 1];
            i = 0;
            while (i < this.ncprob) {
                this.cprob[i] = 1.0 - wk[i + 1];
                ++i;
            }
            this.cprob[this.ncprob] = 2.0;
        } else if (this.mode == 1) {
            double lambda = (double)n * Math.exp(lnp0);
            double emlambda = Math.exp(-1.0 * lambda);
            this.ncprob = -1;
            int nmax = 4 * n + 20;
            double[] wk = new double[nmax];
            double lampnbynfac = 1.0;
            int i = 0;
            while (i < nmax) {
                double pn = emlambda * lampnbynfac;
                lampnbynfac *= lambda / (double)(i + 1);
                wk[i] = pn;
                if ((double)i > lambda && this.ncprob < 0 && pn < 1.0E-11) {
                    this.ncprob = i;
                }
                ++i;
            }
            if (this.ncprob < 0) {
                E.error("never terminated tabled? " + n + " " + lambda + " " + emlambda * lampnbynfac);
            }
            this.cprob = new double[this.ncprob + 1];
            this.cprob[0] = wk[0];
            i = 1;
            while (i < this.ncprob) {
                this.cprob[i] = this.cprob[i - 1] + wk[i];
                ++i;
            }
            this.cprob[this.ncprob] = 2.0;
        } else {
            E.warning("unrecognized distribution " + this.mode);
        }
    }

    public int nGoSeq(double r) {
        int ret = 0;
        while (this.cprob[ret] < r) {
            ++ret;
        }
        return ret;
    }

    public int nGoBS(double r) {
        int bot = 0;
        int top = this.ncprob;
        while (top - bot > 1) {
            int ic = (bot + top) / 2;
            if (r < this.cprob[ic]) {
                top = ic;
                continue;
            }
            bot = ic;
        }
        return bot;
    }

    public int nGo(double r) {
        int ret = 0;
        while (this.cprob[ret] < r) {
            ++ret;
        }
        return ret;
    }

    public double rnGo(double r) {
        double ret = 0.0;
        if (r < this.cprob[0]) {
            ret = r / this.cprob[0];
        } else {
            int ia = 1;
            while (this.cprob[ia] < r) {
                ++ia;
            }
            ret = (double)ia + (r - this.cprob[ia - 1]) / (this.cprob[ia] - this.cprob[ia - 1]);
        }
        return ret;
    }

    public void print() {
        StringBuffer sb = new StringBuffer();
        sb.append("n=" + this.nparticle + " p=" + Math.exp(this.lnp) + " njmax=" + this.ncprob + " mode=" + this.mode + "\n");
        sb.append("p(n < i): ");
        int i = 0;
        while (i < this.ncprob) {
            sb.append(String.valueOf(this.cprob[i]) + ", ");
            ++i;
        }
        sb.append("\n");
        sb.append("ngo, rngo for ten equally spaced randoms starting at 0.001 ");
        i = 0;
        while (i < 10) {
            double r = 0.001 + 0.99 * ((double)i / 9.0);
            sb.append("(" + this.nGo(r) + ",  " + this.rnGo(r) + ") ");
            ++i;
        }
        sb.append("\n");
        System.out.println(sb.toString());
    }

    private void lookupCheck() {
        int i = 0;
        while (i <= 50) {
            int n2;
            double r = 1.0 * (double)i / 50.0;
            int n1 = this.nGoSeq(r);
            if (n1 != (n2 = this.nGoBS(r))) {
                E.error("different results in lookup check " + this.nparticle + " " + Math.exp(this.lnp) + " " + n1 + " " + n2);
            }
            ++i;
        }
    }

    private long lookupTimeSeq() {
        long t0 = System.currentTimeMillis();
        double rnx = 1.0E7;
        int njt = 0;
        int i = 0;
        while ((double)i < rnx) {
            njt += this.nGoSeq((double)i / rnx);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private long lookupTimeBS() {
        long t0 = System.currentTimeMillis();
        double rnx = 1.0E7;
        int njt = 0;
        int i = 0;
        while ((double)i < rnx) {
            njt += this.nGoBS((double)i / rnx);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private long lookupTimeSwitch() {
        long t0 = System.currentTimeMillis();
        double rnx = 1.0E7;
        int njt = 0;
        int i = 0;
        while ((double)i < rnx) {
            njt += this.nGo((double)i / rnx);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static void lookupTest() {
        long tstot = 0L;
        long tbtot = 0L;
        long tctot = 0L;
        int m = 0;
        int i = 10;
        while (i <= 90) {
            int ip = -6;
            while (ip < -1) {
                double lp = 2.0 * (double)ip;
                NGoTable jc = new NGoTable(i, lp, m);
                jc.lookupCheck();
                long ts = jc.lookupTimeSeq();
                long tb = jc.lookupTimeBS();
                long tc = jc.lookupTimeSwitch();
                tstot += ts;
                tbtot += tb;
                tctot += tc;
                double p = Math.exp(lp);
                System.out.println("timings " + i + " " + p + " " + ts + " " + tb + " " + tc);
                ++ip;
            }
            i += 10;
        }
        E.info("seq " + tstot + "   bs " + tbtot + " " + tctot);
    }

    private static void dumpExamples() {
        int mb = 0;
        int mp = 1;
        new NGoTable(10, Math.log(0.1), mb).print();
        new NGoTable(10, Math.log(0.1), mp).print();
        new NGoTable(90, Math.log(0.1), mb).print();
        new NGoTable(90, Math.log(0.1), mp).print();
        new NGoTable(10, Math.log(0.01), mb).print();
        new NGoTable(10, Math.log(0.01), mp).print();
        new NGoTable(90, Math.log(0.01), mb).print();
        new NGoTable(90, Math.log(0.01), mp).print();
        new NGoTable(10, Math.log(0.001), mb).print();
        new NGoTable(10, Math.log(0.001), mp).print();
        new NGoTable(90, Math.log(0.001), mb).print();
        new NGoTable(90, Math.log(0.001), mp).print();
        new NGoTable(10, Math.log(1.0E-4), mb).print();
        new NGoTable(10, Math.log(1.0E-4), mp).print();
        new NGoTable(90, Math.log(1.0E-4), mb).print();
        new NGoTable(90, Math.log(1.0E-4), mp).print();
    }

    public static void main(String[] argv) {
        NGoTable.dumpExamples();
    }
}

