'''
Function:     my_2d_hist

Arguments:    x - Length N list of horizontal coordinates of points
              y - Length M list of vertical coordinates of points
              x_edges - Length H+1 list of horizontal bin edges
              y_edges - Length V+1 list of vertical bin edges
           
Output:       A size VxH binary array, with a 1 in an entry indicating that a point in the list of ordered pairs (x,y)
              fell into the corresponding pair of horizontal and vertical bins.
           
Description:  This program is specialized to not count the number of points which lie in each bin, but instead just
              detects whether at least one point lies in each bin. Used when generating bar images.

Authors:      James Trousdale - jamest212@gmail.com
'''

__all__ = ["my_2d_hist",]

import numpy as np

def my_2d_hist(x,y,x_edges,y_edges):

    out = np.zeros((len(y_edges)-1,len(x_edges)-1))

    x_inds = np.mod(np.int64(np.floor((x-x_edges[0])/(x_edges[1]-x_edges[0]))),360)
    y_inds = np.mod(np.int64(np.floor((y-y_edges[0])/(y_edges[1]-y_edges[0]))),180)


    
    out[y_inds,x_inds] = 1
        
    return out


