'''
Function:     axis_rot_mat

Arguments:    u - Unit vector in the direction of the axis of rotation.
              th - Magnitude of rotation. Positive values yield a clockwise rotation.
           
Output:       A size (3,3) rectangular coordinate rotation matrix.
           
Description:  When applied to a rectangular coordinate, the returned matrix rotates that point about the axis in the 
              direction of u, clockwise by an amount th.

Authors:     James Trousdale - jamest212@gmail.com
'''

import numpy as np

from numpy import sin as sin
from numpy import cos as cos

def axis_rot_mat(u,th):
    
    rotmat = [[cos(th)+u[0]**2*(1-cos(th)),u[0]*u[1]*(1-cos(th))-u[2]*sin(th),u[0]*u[2]*(1-cos(th))+u[1]*sin(th)],
          [u[1]*u[0]*(1-cos(th))+u[2]*sin(th),cos(th)+u[1]**2*(1-cos(th)),u[1]*u[2]*(1-cos(th))-u[0]*sin(th)],
          [u[2]*u[0]*(1-cos(th))-u[1]*sin(th),u[2]*u[1]*(1-cos(th))+u[0]*sin(th),cos(th)+u[2]**2*(1-cos(th))]];
          
    return np.array(rotmat)