'''
Function:     repmat_3d

Arguments:    input_mat - a two-dimensional, NxM array
              reps - number of times to duplicate mat along the 3rd axis
           
Output:       A three-dimensional, size (N,M,reps) array for which each matrix output[:,:,i] is a copy of the matrix
              mat.
           
Description: Similar to MATLAB's repmat function, but specialized to simply take an NxM matrix

Authors:     James Trousdale - jamest212@gmail.com
'''

import numpy as np

def repmat_3d(input_mat,reps):
    return np.reshape(np.tile(np.reshape(input_mat,(np.size(input_mat,0)*np.size(input_mat,1),1)),(1,reps)),(np.size(input_mat,0),np.size(input_mat,1),reps))
