'''
Function:     ang_dist

Arguments:    th1 - scalar angle, or vector of angles (in degrees)
              th2 - scalar angle, or vector of angles (in degrees)
           
Output:       * If th1, th2 are both scalars, returns the angular distance between them
              * If one of th1 or th2 is a vector, and the other a scalar, returns a vector with the distances between
                each entry of the vector of angles and the scalar angle.
              * If th1, th2 are both vectors of equal length, then returns the vector of distances between each
                pair of angles th1[i], th2[i]
           
Description: Computes angular distances in degrees

Authors:     James Trousdale - jamest212@gmail.com
'''

import numpy as np

def ang_dist(th1,th2):
    return np.min(np.mod([np.array(th1)-np.array(th2),np.array(th2)-np.array(th1)],360),0)