% initialize the GUI
%
% the TREES toolbox: edit, visualize and analyze neuronal trees
% Copyright (C) 2009  Hermann Cuntz

clear cgui

% special gui related global structure containing all handles and variables
global cgui

% initializing colors of GUI-elements
cgui.NColor.text =       [.7  .7  .7 ];
cgui.NColor.btext =      [.8  .8  .8 ];
cgui.NColor.fltext =     [.5  .7  .7 ];
cgui.NColor.edit =       [.8  .7  .7 ];
cgui.NColor.screen =     [.7  .7  .8 ];
cgui.NColor.button =     [.7  .8  .7 ];
cgui.NColor.toggle =     [.6  .8   1 ];
cgui.NColor.graph =      [.7  .7  .8 ]; % bluey axis
cgui.NColor.popup =      [.6  .7  .7 ];
cgui.NColor.slider =     [.7  .7  .7 ];
cgui.NColor.box =        [.8  .8  .7 ];
cgui.NColor.radio =      [.3  .5  .7 ];
cgui.NColor.frame1 =     [.75 .75 .75];
cgui.NColor.list =       [.8  .8  .7 ];
cgui.NColor.background = [.8  .8  .8 ]; % grey background

% FIGURE
cgui.ui.F = figure ('Name', ['CONTROL CENTER - the TREES toolbox - '...
    'Copyright (C) 2009  Hermann Cuntz'], 'NumberTitle', 'off', ...
    'DefaultLineLineWidth', 2, 'Visible', 'on', 'menubar', 'none', ...
    'units', 'normalized', 'paperorientation', 'landscape', ...
    'color', cgui.NColor.background, ...
    'outerPosition', [0 0.025 1 .95]);

% activate keyboard-shortcuts
set (cgui.ui.F, 'KeyPressFcn', 'cgui_tree(''keymap'')');

% load keyboard map from cgui_tree_keys, custom changes can be made
% there:
cgui_tree_keys;

% activate mouse wheel
try
    set (cgui.ui.F, 'WindowScrollWheelFcn', {@cgui_mouse_tree, 'mouse_wheel'});
catch
    warndlg ({'No mouse wheel support,', 'use keyboard for zooming', ...
        'DEFAULT: q/Q e/E'});
end

% prevent closing
set (cgui.ui.F, 'CloseRequestFcn', '');

% activate mouse button
set (cgui.ui.F, 'WindowButtonDownFcn', {@cgui_mouse_tree, 'mouse_bdown'});
set (cgui.ui.F, 'WindowButtonUpFcn',   {@cgui_mouse_tree, 'mouse_udown'});

% AXES
cgui.ui.gpos = [.05 .15 .675 .75]; % position of graph
cgui.ui.ppos = [.15 .15 .675 .75]; % position of graph for printing
cgui.ui.g1   = axes ('position', cgui.ui.gpos, 'color', cgui.NColor.graph);
cgui.ui.xrel = .035;   % x-size of basic gui elements relative to full graph
cgui.ui.yrel = .025;   % y-size of basic gui elements relative to full graph (but see below!)
% strings containing all panel names:
cgui.ui.panels = {...
    'vis', 'plt', 'slt', 'ele', 'cat', ...
    'stk', 'thr', 'skl', 'mtr', 'ged'};
set (cgui.ui.F, 'units', 'pixel'); pos = get (cgui.ui.F, 'position');
% display resolution dependent size of control elements:
if pos (3) < 1500, cgui.ui.xrel = 0.045; end
if pos (4) < 1000, cgui.ui.yrel = 0.03; end
set (cgui.ui.F, 'units', 'normalized');
% MENU
cgui.ui.mu0 = uimenu (cgui.ui.F, 'label', '&File');
uimenu (cgui.ui.mu0,  'label', 'load TREES workspace', ...
    'callback', 'cgui_tree (''ui_load'')');
uimenu (cgui.ui.mu0,  'label', 'save TREES workspace', ...
    'callback', 'cgui_tree (''ui_save'')');
uimenu (cgui.ui.mu0,  'label', 'clear all', ...
    'callback', 'cgui_tree (''ui_clear_all'')');
uimenu (cgui.ui.mu0,  'label', 'close', ...
    'callback', 'cgui_tree (''ui_close'')');
cgui.ui.mu1 = uimenu (cgui.ui.F, 'label', '&Stacks');
uimenu (cgui.ui.mu1,  'label', 'load TREES stack', ...
    'callback', 'cgui_tree (''stk_load'')');
uimenu (cgui.ui.mu1,  'label', 'load image sequence', ...
    'callback', 'cgui_tree (''stk_dirload'')');
uimenu (cgui.ui.mu1,  'label', 'load multi-frame TIF', ...
    'callback', 'cgui_tree (''stk_tifsload'')');
uimenu (cgui.ui.mu1,  'label', 'load single image', ...
    'callback', 'cgui_tree (''stk_imload'')');
uimenu (cgui.ui.mu1,  'label', 'save stacks', ...
    'callback', 'cgui_tree (''stk_save'')',      'enable', 'off');
uimenu (cgui.ui.mu1,  'label', 'clear stacks', ...
    'callback', 'cgui_tree (''stk_clear_all'')', 'enable', 'off');
cgui.ui.mu2 = uimenu (cgui.ui.F, 'label', '&Trees');
uimenu (cgui.ui.mu2,  'label', 'load trees', ...
    'callback', 'cgui_tree (''cat_load'')');
uimenu (cgui.ui.mu2,  'label', 'load neurolucida', ...
    'callback', 'cgui_tree (''cat_nlucida'')');
uimenu (cgui.ui.mu2,  'label', 'load neurolucida one soma',...
    'callback', 'cgui_tree (''cat_nlucida_onesoma'')');
uimenu (cgui.ui.mu2,  'label', 'save active tree', ...
    'callback', 'cgui_tree (''cat_save'')',      'enable', 'off');
uimenu (cgui.ui.mu2,  'label', 'save active tree group', ...
    'callback', 'cgui_tree (''cat_gsave'')',     'enable', 'off');
uimenu (cgui.ui.mu2,  'label', 'save all trees', ...
    'callback', 'cgui_tree (''cat_allsave'')',   'enable', 'off');
uimenu (cgui.ui.mu2,  'label', 'clear all trees', ...
    'callback', 'cgui_tree (''cat_clear_all'')', 'enable', 'off');
uimenu (cgui.ui.mu2,  'label', '------', ...
    'callback', '');
uimenu (cgui.ui.mu2,  'label', 'duplicate tree', ...
    'callback', 'cgui_tree (''cat_duplicate'')');
uimenu (cgui.ui.mu2,  'label', '------', ...
    'callback', '');
uimenu (cgui.ui.mu2,  'label', 'export swc', ...
    'callback', 'cgui_tree (''cat_swc'')',       'enable', 'off');
uimenu (cgui.ui.mu2,  'label', 'export to NEURON', ...
    'callback', 'cgui_tree (''cat_neuron'')',    'enable', 'off');
uimenu (cgui.ui.mu2,  'label', 'export NeuroML v1.x Level 1 (MorphML)', ...
    'callback', 'cgui_tree (''cat_nml_v1_l1'')',       'enable', 'off');
uimenu (cgui.ui.mu2,  'label', 'export NeuroML v2alpha', ...
    'callback', 'cgui_tree (''cat_nml_v2a'')',       'enable', 'off');
cgui.ui.mu3 = uimenu (cgui.ui.F, 'label', '&Toolbars');
uimenu (cgui.ui.mu3,  'label', 'all on', ...
    'callback', 'cgui_tree (''ui_allvisible'')');
uimenu (cgui.ui.mu3,  'label', 'all off', ...
    'callback', 'cgui_tree (''ui_allinvisible'')');
uimenu (cgui.ui.mu3,  'label', 'editors on', ...
    'callback', 'cgui_tree (''ui_editorsvisible'')');
uimenu (cgui.ui.mu3,  'label', 'editors off', ...
    'callback', 'cgui_tree (''ui_editorsinvisible'')');
uimenu (cgui.ui.mu3,  'label', 'undock all', ...
    'callback', 'cgui_tree (''ui_undock'')');
cgui.ui.mu4 = uimenu (cgui.ui.F, 'label', '&Visualize', 'enable', 'off');
uimenu (cgui.ui.mu4,  'label', 'statistics', ...
    'callback', 'cgui_tree (''plx_stats'')');
uimenu (cgui.ui.mu4,  'label', '------', ...
    'callback', '');
uimenu (cgui.ui.mu4,  'label', 'dA',...
    'callback', 'cgui_tree (''plx_dA'')');
uimenu (cgui.ui.mu4,  'label', 'dendrogram', ...
    'callback', 'cgui_tree (''plx_dend'')');
uimenu (cgui.ui.mu4,  'label', 'sholl', ...
    'callback', 'cgui_tree (''plx_sholl'')');
uimenu (cgui.ui.mu4,  'label', '3D plot of sholl', ...
    'callback', 'cgui_tree (''plx_sholl3D'')');
uimenu (cgui.ui.mu4,  'label', 'sse', ...
    'callback', 'cgui_tree (''plx_sse'')');
uimenu (cgui.ui.mu4,  'label', '------', ...
    'callback', '');
uimenu (cgui.ui.mu4,  'label', 'send away as x3d o', ...
    'callback', 'cgui_tree (''plx_x3d'')');
uimenu (cgui.ui.mu4,  'label', 'send away as x3d', ...
    'callback', 'cgui_tree (''plx_x3d2'')');
uimenu (cgui.ui.mu4,  'label', 'send to neuron', ...
    'callback', 'cgui_tree (''plx_neuron'')');
uimenu (cgui.ui.mu4,  'label', '------', ...
    'callback', '');
cgui.ui.mu41 = uimenu (cgui.ui.mu4, 'label', 'send to povray', ...
    'callback','');
uimenu (cgui.ui.mu41, 'label', 'GFP', ...
    'callback', 'cgui_tree (''plx_pov'')');
uimenu (cgui.ui.mu41, 'label', 'parchment', ...
    'callback', 'cgui_tree (''plx_pov2'')');
uimenu (cgui.ui.mu41, 'label', 'black on white', ...
    'callback', 'cgui_tree (''plx_pov3'')');
uimenu (cgui.ui.mu41, 'label', 'alien', ...
    'callback', 'cgui_tree (''plx_pov4'')');
uimenu (cgui.ui.mu41, 'label', 'glass on cork', ...
    'callback', 'cgui_tree (''plx_pov5'')');
uimenu (cgui.ui.mu41, 'label', 'red coral', ...
    'callback', 'cgui_tree (''plx_pov6'')');
cgui.ui.mu42 = uimenu (cgui.ui.mu4, 'label', 'send group to povray', ...
    'callback', '');
uimenu (cgui.ui.mu42, 'label', 'brainbow', ...
    'callback', 'cgui_tree (''plx_pov7'')');
uimenu (cgui.ui.mu42, 'label', 'GFP', ...
    'callback', 'cgui_tree (''plx_pov8'')');
uimenu (cgui.ui.mu42, 'label', 'parchment', ...
    'callback', 'cgui_tree (''plx_pov9'')');
uimenu (cgui.ui.mu42, 'label', 'black and white', ...
    'callback', 'cgui_tree (''plx_pov10'')');
uimenu (cgui.ui.mu42, 'label', 'alien', ...
    'callback', 'cgui_tree (''plx_pov11'')');
uimenu (cgui.ui.mu42, 'label', 'glass on cork', ...
    'callback', 'cgui_tree (''plx_pov12'')');
uimenu (cgui.ui.mu42, 'label', 'red coral', ...
    'callback', 'cgui_tree (''plx_pov13'')');
uimenu (cgui.ui.mu4,  'label', 'send all to povray - brainbow', ...
    'callback', 'cgui_tree (''plx_pov14'')');
uimenu (cgui.ui.mu4,  'label', '------', ...
    'callback', '');
cgui.ui.mu43 = uimenu (cgui.ui.mu4, 'label', 'set cylinder resolution', ...
    'callback', '');
uimenu (cgui.ui.mu43, 'label', '4 points', ...
    'callback', 'cgui_tree (''vis_resx4'')');
uimenu (cgui.ui.mu43, 'label', '8 points', ...
    'callback', 'cgui_tree (''vis_resx8'')','checked','on');
uimenu (cgui.ui.mu43, 'label', '32 points', ...
    'callback', 'cgui_tree (''vis_resx32'')');
cgui.ui.mu5 = uimenu (cgui.ui.F, 'label', '&Colormaps');
uimenu (cgui.ui.mu5,  'label', 'hot color scale', ...
    'callback', 'cgui_tree (''vis_cmap1'')',...
    'checked','on'); colormap hot;
uimenu (cgui.ui.mu5,  'label', 'inverse hot color scale', ...
    'callback', 'cgui_tree (''vis_cmapi1'')');
uimenu (cgui.ui.mu5,  'label', 'gray color scale', ...
    'callback', 'cgui_tree (''vis_cmap2'')');
uimenu (cgui.ui.mu5,  'label', 'inverse gray color scale', ...
    'callback', 'cgui_tree (''vis_cmapi2'')');
uimenu (cgui.ui.mu5,  'label', 'jet color scale', ...
    'callback', 'cgui_tree (''vis_cmap3'')');
uimenu (cgui.ui.mu5,  'label', 'bone color scale', ...
    'callback', 'cgui_tree (''vis_cmap4'')');
uimenu (cgui.ui.mu5,  'label', 'copper color scale', ...
    'callback', 'cgui_tree (''vis_cmap5'')');
uimenu (cgui.ui.mu5,  'label', 'autumn color scale', ...
    'callback', 'cgui_tree (''vis_cmap6'')');
uimenu (cgui.ui.mu5,  'label', 'spring color scale', ...
    'callback', 'cgui_tree (''vis_cmap7'')');
uimenu (cgui.ui.mu5,  'label', 'winter color scale', ...
    'callback', 'cgui_tree (''vis_cmap8'')');
uimenu (cgui.ui.mu5,  'label', 'summer color scale', ...
    'callback', 'cgui_tree (''vis_cmap9'')');
uimenu (cgui.ui.mu5,  'label', '------', ...
    'callback', '');
uimenu (cgui.ui.mu5,  'label', 'transparent', ...
    'callback', 'cgui_tree (''vis_cmap_t5'')', 'checked', 'on');
uimenu (cgui.ui.mu5,  'label', 'opaque', ...
    'callback', 'cgui_tree (''vis_cmap_t0'')');
cgui.ui.mu6 = uimenu (cgui.ui.F, 'label', '&Print');
uimenu (cgui.ui.mu6,  'label', 'snapshot', ...
    'callback','cgui_tree (''vis_print'')');
uimenu (cgui.ui.mu6,  'label', 'print tif', ...
    'callback', 'cgui_tree (''vis_tif'')');
uimenu (cgui.ui.mu6,  'label', 'print eps', ...
    'callback', 'cgui_tree (''vis_eps'')');
uimenu (cgui.ui.mu6,  'label', 'print jpg', ...
    'callback', 'cgui_tree (''vis_jpg'')');

% vis_ controler
%    top right coordinates:
cgui.vis.ui.cX = .99; cgui.vis.ui.cY = .975;
cgui.vis.ui.c = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.frame1, 'Style', 'frame', ...
    'Position', [cgui.vis.ui.cX-3.05*cgui.ui.xrel cgui.vis.ui.cY-12.05*cgui.ui.yrel ...
    3.1*cgui.ui.xrel 12.1*cgui.ui.yrel]);
cgui.vis.ui.r1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.5 .5 .5], 'Style', 'radiobutton', 'value', 1, ...
    'Position', [cgui.vis.ui.cX-3*cgui.ui.xrel cgui.vis.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'callback', 'cgui_tree(''vis_xy'')', 'tooltipstring', 'toggle XY/XYZ view');
cgui.vis.ui.r2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.5 .5 .5], 'Style', 'radiobutton', 'value', 0, ...
    'Position', [cgui.vis.ui.cX-2.5*cgui.ui.xrel cgui.vis.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'callback', 'cgui_tree(''vis_xz'')', 'tooltipstring', 'toggle XZ/XYZ view');
cgui.vis.ui.r3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.5 .5 .5], 'Style', 'radiobutton', 'value', 0, ...
    'Position', [cgui.vis.ui.cX-2*cgui.ui.xrel cgui.vis.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'callback', 'cgui_tree(''vis_yz'')', 'tooltipstring', 'toggle YZ/XYZ view');
cgui.vis.ui.b1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-1.5*cgui.ui.xrel cgui.vis.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', 'x', 'callback', 'cgui_tree(''vis_tight'')', ...
    'tooltipstring', 'axis tight');
cgui.vis.ui.b2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-cgui.ui.xrel cgui.vis.ui.cY-cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], ...
    'String', 'cla', 'callback', 'cgui_tree(''vis_cla'')', ...
    'tooltipstring', 'redraw full axis');
cgui.vis.ui.txt1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.text, 'Style', 'text', ...
    'Position', [cgui.vis.ui.cX-3*cgui.ui.xrel+0.0025 cgui.vis.ui.cY-3*cgui.ui.yrel ...
    3*cgui.ui.xrel-0.005 2*cgui.ui.yrel-0.0025], ...
    'String', {'load image stack', 'or tree to start'}, ...
    'tooltipstring', 'echo last action');
cgui.vis.ui.txt2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.text, 'Style', 'text', ...
    'Position', [cgui.vis.ui.cX-3*cgui.ui.xrel+0.0025 cgui.vis.ui.cY-7*cgui.ui.yrel ...
    3*cgui.ui.xrel-0.005 4*cgui.ui.yrel-0.0025], ...
    'String', {'', '', '', '', ''}, 'tooltipstring', 'data information');
cgui.vis.ui.b3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', 'enable', 'off', ...
    'Position', [cgui.vis.ui.cX-3*cgui.ui.xrel cgui.vis.ui.cY-8*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], ...
    'String', 'AUTO', 'callback', 'cgui_tree(''stk_auto'')', ...
    'tooltipstring', 'fully automated reconstruction');
cgui.vis.ui.t1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.vis.ui.cX-2*cgui.ui.xrel cgui.vis.ui.cY-8*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], ...
    'String', 'edit', 'callback', 'cgui_tree(''ui_editor'')', ...
    'tooltipstring', 'toggle edit mode');
cgui.vis.ui.t2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.vis.ui.cX-cgui.ui.xrel cgui.vis.ui.cY-8*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], ...
    'String', 'edit2', 'callback', 'cgui_tree(''ui_selector'')', ...
    'tooltipstring', 'toggle selection edit mode');
cgui.vis.ui.b4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-3*cgui.ui.xrel cgui.vis.ui.cY-9*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '2d', 'callback', 'cgui_tree(''vis_2d3d'')', ...
    'tooltipstring', 'switch views');
cgui.vis.ui.b5 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-2.5*cgui.ui.xrel cgui.vis.ui.cY-9*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '/ \', 'callback', 'cgui_tree(''vis_projection'')', ...
    'tooltipstring', 'toggle view projection');
cgui.vis.ui.b6 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-2*cgui.ui.xrel cgui.vis.ui.cY-9*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '^ov', 'callback', 'cgui_tree(''vis_rshow'')', ...
    'tooltipstring', 'round-show');
cgui.vis.ui.b7 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-1.5*cgui.ui.xrel cgui.vis.ui.cY-9*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '_', 'callback', 'cgui_tree(''vis_scale'')', ...
    'tooltipstring', 'toggle scalebar on/off');
cgui.vis.ui.b8 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-cgui.ui.xrel cgui.vis.ui.cY-9*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', 'sun', 'callback', 'cgui_tree(''vis_shine'')', ...
    'tooltipstring', 'add sunshine');
cgui.vis.ui.b9 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-.5*cgui.ui.xrel cgui.vis.ui.cY-9*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', 'ax', 'callback', 'cgui_tree(''vis_axoff'')', ...
    'tooltipstring', 'toggle axis on/off');
cgui.vis.ui.b10 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-3*cgui.ui.xrel cgui.vis.ui.cY-10*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '||', 'callback', 'cgui_tree(''vis_cbar'')', ...
    'tooltipstring', 'toggle display colorbar');
cgui.vis.ui.ed_cbar1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.vis.ui.cX-2.5*cgui.ui.xrel cgui.vis.ui.cY-10*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], ...
    'String', '0', 'callback', 'cgui_tree(''vis_clim'')', ...
    'tooltipstring', 'colormap min');
cgui.vis.ui.ed_cbar2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.vis.ui.cX-1.5*cgui.ui.xrel cgui.vis.ui.cY-10*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], ...
    'String', '255', 'callback', 'cgui_tree(''vis_clim'')', ...
    'tooltipstring', 'colormap max');
cgui.vis.ui.b11 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-.5*cgui.ui.xrel cgui.vis.ui.cY-10*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', 'x', 'callback', 'cgui_tree(''vis_climauto'')', ...
    'tooltipstring', 'colormap tight limits');
cgui.vis.ui.b12 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-3*cgui.ui.xrel cgui.vis.ui.cY-11*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '[+]', 'callback', 'cgui_tree(''vis_grid'')', ...
    'tooltipstring', 'toggle grid on/off');
cgui.vis.ui.ed_grid1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.vis.ui.cX-2.5*cgui.ui.xrel cgui.vis.ui.cY-11*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '-50', 'callback', 'cgui_tree(''vis_rebuildgrid'')', ...
    'tooltipstring', 'grid 1. dim start pos');
cgui.vis.ui.ed_grid2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.vis.ui.cX-2*cgui.ui.xrel cgui.vis.ui.cY-11*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '-50', 'callback', 'cgui_tree(''vis_rebuildgrid'')', ...
    'tooltipstring', 'grid 2. dim start pos');
cgui.vis.ui.ed_grid3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.vis.ui.cX-1.5*cgui.ui.xrel cgui.vis.ui.cY-11*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '10', 'callback', 'cgui_tree(''vis_rebuildgrid'')', ...
    'tooltipstring', 'grid 1. dim # squares');
cgui.vis.ui.ed_grid4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.vis.ui.cX-cgui.ui.xrel cgui.vis.ui.cY-11*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '10', 'callback', 'cgui_tree(''vis_rebuildgrid'')', ...
    'tooltipstring', 'grid 2. dim # squares');
cgui.vis.ui.ed_grid5 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.vis.ui.cX-.5*cgui.ui.xrel cgui.vis.ui.cY-11*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '10', 'callback', 'cgui_tree(''vis_rebuildgrid'')', ...
    'tooltipstring', 'grid spacing');
cgui.vis.ui.b13 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-3*cgui.ui.xrel cgui.vis.ui.cY-12*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '-', 'callback', 'cgui_tree(''vis_iMm1'')', ...
    'tooltipstring', 'third dimension plane - 1');
cgui.vis.ui.b14 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.vis.ui.cX-2.5*cgui.ui.xrel cgui.vis.ui.cY-12*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], ...
    'String', '+', 'callback', 'cgui_tree(''vis_iMp1'')', ...
    'tooltipstring', 'third dimension plane + 1');
cgui.vis.ui.ed_setz = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '0', 'Style', 'edit', ...
    'Position', [cgui.vis.ui.cX-2*cgui.ui.xrel cgui.vis.ui.cY-12*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], ...
    'callback', 'cgui_tree(''vis_setz'')', 'tooltipstring', 'set third dimension plane');

% plt_ controler
%    top right coordinates:
cgui.plt.ui.cX = .99; cgui.plt.ui.cY = .975-12.5*cgui.ui.yrel;
cgui.plt.ui.c = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.frame1, 'Style', 'frame', ...
    'Position', [cgui.plt.ui.cX-3.05*cgui.ui.xrel cgui.plt.ui.cY-3.05*cgui.ui.yrel-.0225 ...
    3.1*cgui.ui.xrel 3.1*cgui.ui.yrel+.0225]);
cgui.plt.ui.pop = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.popup, 'Style', 'popup', ...
    'Position', [cgui.plt.ui.cX-3*cgui.ui.xrel cgui.plt.ui.cY-cgui.ui.yrel ...
    2*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'none', 'callback', 'cgui_tree(''plt_pop'')', ...
    'tooltipstring', 'select active graphic handle');
cgui.plt.ui.b1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-cgui.ui.xrel cgui.plt.ui.cY-cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'clear', 'callback', 'cgui_tree(''plt_clear'')', ...
    'tooltipstring', 'clear current handle');
cgui.plt.ui.b2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-3*cgui.ui.xrel cgui.plt.ui.cY-.0225-cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'plot', 'callback', 'cgui_tree(''plt_plot'')', ...
    'tooltipstring', 'simple plot');
cgui.plt.ui.b3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-2.25*cgui.ui.xrel cgui.plt.ui.cY-.0225-cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '.', 'callback', 'cgui_tree(''plt_pplot'')', ...
    'tooltipstring', 'real cylinder plot');
cgui.plt.ui.b4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-2*cgui.ui.xrel cgui.plt.ui.cY-.0225-cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'q', 'callback', 'cgui_tree(''plt_qplot'')', ...
    'tooltipstring', 'real cylinder plot');
cgui.plt.ui.b5 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-1.75*cgui.ui.xrel cgui.plt.ui.cY-.0225-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'vtext', 'callback', 'cgui_tree(''plt_vtext'')', ...
    'tooltipstring', 'text values to nodes');
cgui.plt.ui.b6 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-1.25*cgui.ui.xrel cgui.plt.ui.cY-.0225-cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '2', 'callback', 'cgui_tree(''plt_vtext2'')', ...
    'tooltipstring', 'text values to nodes');
cgui.plt.ui.b7 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-cgui.ui.xrel cgui.plt.ui.cY-.0225-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'o', 'callback', 'cgui_tree(''plt_pointer'')', ...
    'tooltipstring', 'point to selected nodes');
cgui.plt.ui.b8 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-.5*cgui.ui.xrel cgui.plt.ui.cY-.0225-cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '|', 'callback', 'cgui_tree(''plt_electrode'')', ...
    'tooltipstring', 'thin electrode to selected nodes');
cgui.plt.ui.b9 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-.25*cgui.ui.xrel cgui.plt.ui.cY-.0225-cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'V', 'callback', 'cgui_tree(''plt_electrode2'')', ...
    'tooltipstring', 'patch electrode on selected nodes');
cgui.plt.ui.b10 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-3*cgui.ui.xrel cgui.plt.ui.cY-.0225-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'hull', 'callback', 'cgui_tree(''plt_dhull'')', ...
    'tooltipstring', 'iso-distance hull');
cgui.plt.ui.b11 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-2.5*cgui.ui.xrel cgui.plt.ui.cY-.0225-2*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '2', 'callback', 'cgui_tree(''plt_dhull2'')', ...
    'tooltipstring', '2D iso-distance hull');
cgui.plt.ui.ed_hull1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '25', 'Style', 'edit', ...
    'Position', [cgui.plt.ui.cX-2.25*cgui.ui.xrel cgui.plt.ui.cY-.0225-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''plt_dist'')', ...
    'tooltipstring', 'iso-distance threshold/sampling [um]');
cgui.plt.ui.b12 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-1.75*cgui.ui.xrel cgui.plt.ui.cY-.0225-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'vhull', 'callback', 'cgui_tree(''plt_vhull'')', ...
    'tooltipstring', 'voronoi hull');
cgui.plt.ui.b13 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-1.25*cgui.ui.xrel cgui.plt.ui.cY-.0225-2*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '2', 'callback', 'cgui_tree(''plt_vhull2'')', ...
    'tooltipstring', '2D voronoi hull');
cgui.plt.ui.b14 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-cgui.ui.xrel cgui.plt.ui.cY-.0225-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'dens', 'callback', 'cgui_tree(''plt_gdens'')', ...
    'tooltipstring', 'density representation');
cgui.plt.ui.b15 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-.5*cgui.ui.xrel cgui.plt.ui.cY-.0225-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'toy', 'callback', 'cgui_tree(''plt_lego'')', ...
    'tooltipstring', 'lego representation');
cgui.plt.ui.b16 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-3*cgui.ui.xrel cgui.plt.ui.cY-.0225-3*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'col', 'callback', 'cgui_tree(''plt_color'')', ...
    'tooltipstring', 'change color attributes');
cgui.plt.ui.b17 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-2.25*cgui.ui.xrel cgui.plt.ui.cY-.0225-3*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '.', 'callback', 'cgui_tree(''plt_color2'')', ...
    'tooltipstring', 'change line color attributes');
cgui.plt.ui.b18 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-2*cgui.ui.xrel cgui.plt.ui.cY-.0225-3*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '<', 'callback', 'cgui_tree(''plt_trans1'')', ...
    'tooltipstring', 'decrease transparency');
cgui.plt.ui.b19 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-1.75*cgui.ui.xrel cgui.plt.ui.cY-.0225-3*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '>', 'callback', 'cgui_tree(''plt_trans2'')', ...
    'tooltipstring', 'increase transparency');
cgui.plt.ui.b20 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-1.5*cgui.ui.xrel cgui.plt.ui.cY-.0225-3*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'font', 'callback', 'cgui_tree(''plt_font'')', ...
    'tooltipstring', 'change font');
cgui.plt.ui.b21 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-cgui.ui.xrel cgui.plt.ui.cY-.0225-3*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'l-', 'callback', 'cgui_tree(''plt_linem'')', ...
    'tooltipstring', 'thin line');
cgui.plt.ui.b22 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.plt.ui.cX-.75*cgui.ui.xrel cgui.plt.ui.cY-.0225-3*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'l+', 'callback', 'cgui_tree(''plt_linep'')', ...
    'tooltipstring', 'thick line');
cgui.plt.ui.r1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.7 .7 .7], 'Style', 'radiobutton', 'value', 0, ...
    'Position', [cgui.plt.ui.cX-.5*cgui.ui.xrel cgui.plt.ui.cY-.0225-3*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''plt_r1'')', ...
    'tooltipstring', 'toggle handle show while rotation');

% slt_ controler
%    top right coordinates:
cgui.slt.ui.cX = .99; cgui.slt.ui.cY = .975-.0225-16*cgui.ui.yrel;
cgui.slt.ui.c = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.frame1, 'Style', 'frame', ...
    'Position', [cgui.slt.ui.cX-3.05*cgui.ui.xrel cgui.slt.ui.cY-2.05*cgui.ui.yrel-.0675 ...
    3.1*cgui.ui.xrel 2.1*cgui.ui.yrel+.0675]);
cgui.slt.ui.pop1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.popup, 'Style', 'popup', ...
    'Position', [cgui.slt.ui.cX-3*cgui.ui.xrel cgui.slt.ui.cY-cgui.ui.yrel ...
    3*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String',  cgui.slt.svec, 'callback', 'cgui_tree(''slt_vecpop'')', ...
    'tooltipstring', 'select per node info');
cgui.slt.ui.b1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.slt.ui.cX-3*cgui.ui.xrel cgui.slt.ui.cY-cgui.ui.yrel-.0225 ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'Pvec', 'callback', 'cgui_tree(''slt_pvec'')', ...
    'tooltipstring', 'accumulate values over paths');
cgui.slt.ui.b2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.slt.ui.cX-2.25*cgui.ui.xrel cgui.slt.ui.cY-cgui.ui.yrel-.0225 ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'child', 'callback', 'cgui_tree(''slt_child'')', ...
    'tooltipstring', 'accumulate values over children');
cgui.slt.ui.b3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.slt.ui.cX-1.5*cgui.ui.xrel cgui.slt.ui.cY-cgui.ui.yrel-.0225 ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'ratio', 'callback', 'cgui_tree(''slt_ratio'')', ...
    'tooltipstring', 'ratio values to parent node');
cgui.slt.ui.b4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.slt.ui.cX-.75*cgui.ui.xrel cgui.slt.ui.cY-cgui.ui.yrel-.0225 ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'asym', 'callback', 'cgui_tree(''slt_asym'')', ...
    'tooltipstring', 'asymmetry of values at branch points');
cgui.slt.ui.pop2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.popup, 'Style', 'popup', ...
    'Position', [cgui.slt.ui.cX-3*cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.0225 ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String',  cgui.slt.sind, 'callback', 'cgui_tree(''slt_indpop'')', ...
    'tooltipstring', 'node subgroup selector');
cgui.slt.ui.b5 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.slt.ui.cX-2*cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.0225 ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 't<', 'callback', 'cgui_tree(''slt_thr1'')', ...
    'tooltipstring', 'select nodes with values smaller than');
cgui.slt.ui.ed_thred1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '10', 'Style', 'edit', ...
    'Position', [cgui.slt.ui.cX-1.5*cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.0225 ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''slt_thred'')', ...
    'tooltipstring', 'threshold value');
cgui.slt.ui.b6 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.slt.ui.cX-.5*cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.0225 ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '<t', 'callback', 'cgui_tree(''slt_thr2'')', ...
    'tooltipstring', 'select nodes with values larger than');
cgui.slt.ui.pop3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.popup, 'Style', 'popup', ...
    'Position', [cgui.slt.ui.cX-3*cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.045 ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String',  'none', 'callback', 'cgui_tree(''slt_regpop'')', ...
    'tooltipstring', 'region selector');
cgui.slt.ui.ed_name1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '', 'Style', 'edit', ...
    'Position', [cgui.slt.ui.cX-2.5*cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.045 ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''slt_name'')', ...
    'tooltipstring', 'region name');
cgui.slt.ui.b7 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.slt.ui.cX-1.5*cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.045 ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'assign', 'callback', 'cgui_tree(''slt_assign'')', ...
    'tooltipstring', 'assign region # to selected nodes');
cgui.slt.ui.b8 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.slt.ui.cX-.75*cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.045 ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'NEW', 'callback', 'cgui_tree(''slt_assignN'')', ...
    'tooltipstring', 'assign NEW region to selected nodes');
cgui.slt.ui.b9 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.slt.ui.cX-.25*cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.045 ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'c', 'callback', 'cgui_tree(''slt_delreg'')', ...
    'tooltipstring', 'clear empty region');
cgui.slt.ui.t1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.slt.ui.cX-3*cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.0675 ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 1, ...
    'String', 'cyl', 'callback', 'cgui_tree(''slt_cyl'')', ...
    'tooltipstring', 'segments consist of cylinders');
cgui.slt.ui.t2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.slt.ui.cX-2.5*cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.0675 ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 0, ...
    'String', 'frus', 'callback', 'cgui_tree(''slt_frustum'')', ...
    'tooltipstring', 'segments have start and end diameter (frustum)');
cgui.slt.ui.b10 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.slt.ui.cX-2*cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.0675 ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'subtree', 'callback', 'cgui_tree(''slt_subtree'')', ...
    'tooltipstring', 'select subtree from last node');
cgui.slt.ui.b11 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.slt.ui.cX-cgui.ui.xrel cgui.slt.ui.cY-2*cgui.ui.yrel-.0675 ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'delete', 'callback', 'cgui_tree(''slt_delete'')', ...
    'tooltipstring', 'delete selected nodes');

% ele_ controler
%    top right coordinates:
cgui.ele.ui.cX = .99; cgui.ele.ui.cY = .975-21.5*cgui.ui.yrel-.0225;
cgui.ele.ui.c = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.frame1, 'Style', 'frame', ...
    'Position', [cgui.ele.ui.cX-3.05*cgui.ui.xrel cgui.ele.ui.cY-1.05*cgui.ui.yrel ...
    3.1*cgui.ui.xrel 1.1*cgui.ui.yrel]);
cgui.ele.ui.ed_elec1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '100', 'Style', 'edit', ...
    'Position', [cgui.ele.ui.cX-3*cgui.ui.xrel cgui.ele.ui.cY-cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''ele_Ri'')', ...
    'tooltipstring', 'axial resistance [\Omega cm]');
cgui.ele.ui.ed_elec2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '.0005', 'Style', 'edit', ...
    'Position', [cgui.ele.ui.cX-2*cgui.ui.xrel cgui.ele.ui.cY-cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''ele_Gm'')', ...
    'tooltipstring', 'membrane conductance [S/cm^2]');
cgui.ele.ui.ed_elec3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '1', 'Style', 'edit', ...
    'Position', [cgui.ele.ui.cX-cgui.ui.xrel cgui.ele.ui.cY-cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''ele_Cm'')', ...
    'tooltipstring', 'membrane capacity Cm (unused for now)');

% cat_ controler
%    top right coordinates:
cgui.cat.ui.cX = .99; cgui.cat.ui.cY = .975-23.5*cgui.ui.yrel-.0225;
cgui.cat.ui.c = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.frame1, 'Style', 'frame', ...
    'Position', [cgui.cat.ui.cX-3.05*cgui.ui.xrel cgui.cat.ui.cY-8.05*cgui.ui.yrel ...
    3.1*cgui.ui.xrel 8.1*cgui.ui.yrel]);
cgui.cat.ui.b1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.cat.ui.cX-3*cgui.ui.xrel cgui.cat.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '^', 'callback', 'cgui_tree(''cat_uptree'')', ...
    'tooltipstring', 'move tree up');
cgui.cat.ui.b2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.cat.ui.cX-2.5*cgui.ui.xrel cgui.cat.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'v', 'callback', 'cgui_tree(''cat_downtree'')', ...
    'tooltipstring', 'move tree down');
cgui.cat.ui.ed_name1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '', 'Style', 'edit', ...
    'Position', [cgui.cat.ui.cX-2*cgui.ui.xrel cgui.cat.ui.cY-cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''cat_name'')', ...
    'tooltipstring', 'change name');
cgui.cat.ui.b3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.cat.ui.cX-cgui.ui.xrel cgui.cat.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'u', 'callback', 'cgui_tree(''cat_undo'')', ...
    'tooltipstring', 'undo last action: tree');
cgui.cat.ui.b4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.cat.ui.cX-.5*cgui.ui.xrel cgui.cat.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'clr', 'callback', 'cgui_tree(''cat_cleartree'')', ...
    'tooltipstring', 'clear active tree');
cgui.cat.ui.f2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.popup, 'Style', 'list', ...
    'Position', [cgui.cat.ui.cX-3*cgui.ui.xrel cgui.cat.ui.cY-8*cgui.ui.yrel ...
    cgui.ui.xrel 7*cgui.ui.yrel], 'enable', 'off', ...
    'String', 'x', 'callback', 'cgui_tree(''cat_selectgroup'')', ...
    'tooltipstring', 'tree groups');
cgui.cat.ui.f1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.list, 'Style', 'list', ...
    'Position', [cgui.cat.ui.cX-2*cgui.ui.xrel cgui.cat.ui.cY-8*cgui.ui.yrel ...
    2*cgui.ui.xrel 7*cgui.ui.yrel], 'enable', 'off', ...
    'String', 'none', 'callback', 'cgui_tree(''cat_selecttree'')', ...
    'tooltipstring', 'tree group elements');

% stk_ controler
%    top right coordinates:
cgui.stk.ui.cX = .99-.01-3*cgui.ui.xrel; cgui.stk.ui.cY = .975;
cgui.stk.ui.c = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.7 .7 .7], 'Style', 'frame', ...
    'Position', [cgui.stk.ui.cX-3.05*cgui.ui.xrel cgui.stk.ui.cY-4.05*cgui.ui.yrel-.0225 ...
    3.1*cgui.ui.xrel 4.1*cgui.ui.yrel+.0225], 'tooltipstring', 'stack panel');
cgui.stk.ui.r1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.7 .7 .7], 'Style', 'radiobutton', 'value', 1, ...
    'Position', [cgui.stk.ui.cX-3*cgui.ui.xrel cgui.stk.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''stk_r1'')', ...
    'tooltipstring', 'max. intensity projection');
cgui.stk.ui.r2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.7 .7 .7], 'Style', 'radiobutton', 'value', 0, ...
    'Position', [cgui.stk.ui.cX-2.5*cgui.ui.xrel cgui.stk.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''stk_r2'')', ...
    'tooltipstring', 'single slice representation');
cgui.stk.ui.b1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.stk.ui.cX-2*cgui.ui.xrel cgui.stk.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'filt', 'callback', 'cgui_tree(''stk_filter'')', ...
    'tooltipstring', 'not implemented yet : filter');
cgui.stk.ui.b2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.stk.ui.cX-1.5*cgui.ui.xrel cgui.stk.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'v', 'callback', 'cgui_tree(''stk_downsize'')', ...
    'tooltipstring', 'downsample 50%');
cgui.stk.ui.b3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.stk.ui.cX-cgui.ui.xrel cgui.stk.ui.cY-cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'clear', 'callback', 'cgui_tree(''stk_clear'')', ...
    'tooltipstring', 'clear current stack');
cgui.stk.ui.pop = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.popup, 'String', 'none', 'Style', 'popup', ...
    'Position', [cgui.stk.ui.cX-3*cgui.ui.xrel cgui.stk.ui.cY-2*cgui.ui.yrel ...
    2*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'value', 1, 'callback', 'cgui_tree(''stk_pop'')', ...
    'tooltipstring', 'select active stack');
cgui.stk.ui.b4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.stk.ui.cX-cgui.ui.xrel cgui.stk.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '0', 'callback', 'cgui_tree(''stk_zero'')', ...
    'tooltipstring', 'zero coordinates of current stack');
cgui.stk.ui.b5 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.stk.ui.cX-.5*cgui.ui.xrel cgui.stk.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'ali.', 'callback', 'cgui_tree(''stk_align'')', ...
    'tooltipstring', 'align current stack with previous');
cgui.stk.ui.b6 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.stk.ui.cX-3*cgui.ui.xrel cgui.stk.ui.cY-2*cgui.ui.yrel-.0225 ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '<', 'callback', 'cgui_tree(''stk_bmx'')', ...
    'tooltipstring', 'move stack x-1/mum');
cgui.stk.ui.b7 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.stk.ui.cX-2.5*cgui.ui.xrel cgui.stk.ui.cY-2*cgui.ui.yrel-.0225 ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '>', 'callback', 'cgui_tree(''stk_bpx'')', ...
    'tooltipstring', 'move stack x+1um');
cgui.stk.ui.b8 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.stk.ui.cX-2*cgui.ui.xrel cgui.stk.ui.cY-2*cgui.ui.yrel-.0225 ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '<', 'callback', 'cgui_tree(''stk_bmy'')', ...
    'tooltipstring', 'move stack y-1um');
cgui.stk.ui.b9 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.stk.ui.cX-1.5*cgui.ui.xrel cgui.stk.ui.cY-2*cgui.ui.yrel-.0225 ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '>', 'callback', 'cgui_tree(''stk_bpy'')', ...
    'tooltipstring', 'move stack y+1um');
cgui.stk.ui.b10 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.stk.ui.cX-cgui.ui.xrel cgui.stk.ui.cY-2*cgui.ui.yrel-.0225 ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '<', 'callback', 'cgui_tree(''stk_bmz'')', ...
    'tooltipstring', 'move stack z-1um');
cgui.stk.ui.b11 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.stk.ui.cX-.5*cgui.ui.xrel cgui.stk.ui.cY-2*cgui.ui.yrel-.0225 ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '>', 'callback', 'cgui_tree(''stk_bpz'')', ...
    'tooltipstring', 'move stack z+1um');
cgui.stk.ui.ed_tran1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '0', 'Style', 'edit', ...
    'Position', [cgui.stk.ui.cX-3*cgui.ui.xrel cgui.stk.ui.cY-3*cgui.ui.yrel-.0225 ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''stk_setcoord'')', ...
    'tooltipstring', 'set stack x-coord');
cgui.stk.ui.ed_tran2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '0', 'Style', 'edit', ...
    'Position', [cgui.stk.ui.cX-2*cgui.ui.xrel cgui.stk.ui.cY-3*cgui.ui.yrel-.0225 ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''stk_setcoord'')', ...
    'tooltipstring', 'set stack y-coord');
cgui.stk.ui.ed_tran3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '0', 'Style', 'edit', ...
    'Position', [cgui.stk.ui.cX-cgui.ui.xrel cgui.stk.ui.cY-3*cgui.ui.yrel-.0225 ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''stk_setcoord'')', ...
    'tooltipstring', 'set stack z-coord');
cgui.stk.ui.ed_vox1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '1', 'Style', 'edit', ...
    'Position', [cgui.stk.ui.cX-3*cgui.ui.xrel cgui.stk.ui.cY-4*cgui.ui.yrel-.0225 ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''stk_setvoxel'')', ...
    'tooltipstring', 'set voxel x size [um]');
cgui.stk.ui.ed_vox2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '1', 'Style', 'edit', ...
    'Position', [cgui.stk.ui.cX-2*cgui.ui.xrel cgui.stk.ui.cY-4*cgui.ui.yrel-.0225 ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''stk_setvoxel'')', ...
    'tooltipstring', 'set voxel y size [um]');
cgui.stk.ui.ed_vox3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '1', 'Style', 'edit', ...
    'Position', [cgui.stk.ui.cX-cgui.ui.xrel cgui.stk.ui.cY-4*cgui.ui.yrel-.0225 ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''stk_setvoxel'')', ...
    'tooltipstring', 'set voxel z size [um]');

% thr_ controler
%    top right coordinates:
cgui.thr.ui.cX = .99-.01-3*cgui.ui.xrel; cgui.thr.ui.cY = .975-4.5*cgui.ui.yrel-.0225;
cgui.thr.ui.c = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.7 .7 1], 'Style', 'frame', ...
    'Position', [cgui.thr.ui.cX-3.05*cgui.ui.xrel cgui.thr.ui.cY-2.05*cgui.ui.yrel ...
    3.1*cgui.ui.xrel 2.1*cgui.ui.yrel], ...
    'tooltipstring', 'thresholding panel');
cgui.thr.ui.r1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.7 .7 1], 'Style', 'radiobutton', 'value', 1, ...
    'Position', [cgui.thr.ui.cX-3*cgui.ui.xrel cgui.thr.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''thr_r1'')', ...
    'tooltipstring', 'toggle projection view on/off');
cgui.thr.ui.r2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.7 .7 1], 'Style', 'radiobutton', 'value', 0, ...
    'Position', [cgui.thr.ui.cX-2.5*cgui.ui.xrel cgui.thr.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''thr_r2'')', ...
    'tooltipstring', 'toggle lego view on/off');
cgui.thr.ui.r3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.7 .7 1], 'Style', 'radiobutton', 'value', 0, ...
    'Position', [cgui.thr.ui.cX-2*cgui.ui.xrel cgui.thr.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''stk_image'')', ...
    'tooltipstring', 'toggle thresholded stack maximum index view');
cgui.thr.ui.b1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.thr.ui.cX-1.5*cgui.ui.xrel cgui.thr.ui.cY-cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'clean', 'callback', 'cgui_tree(''thr_clean'')', 'tooltipstring', ...
    'clean continuous parts smaller than (requires image processing toolbox)');
cgui.thr.ui.ed_clean1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '100', 'Style', 'edit', ...
    'Position', [cgui.thr.ui.cX-.75*cgui.ui.xrel cgui.thr.ui.cY-cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'tooltipstring', 'cleaning threshold');
cgui.thr.ui.b2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.thr.ui.cX-3*cgui.ui.xrel cgui.thr.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 't>', 'callback', 'cgui_tree(''thr_thr'')', ...
    'tooltipstring', 'simple threshold larger than');
cgui.thr.ui.ed_thr1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '0', 'Style', 'edit', ...
    'Position', [cgui.thr.ui.cX-2.5*cgui.ui.xrel cgui.thr.ui.cY-2*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'callback', 'cgui_tree(''thr_image'')', ...
    'tooltipstring', 'brightness threshold value');
cgui.thr.ui.b3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.thr.ui.cX-1.5*cgui.ui.xrel cgui.thr.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '>t', 'callback', 'cgui_tree(''thr_thr2'')', ...
    'tooltipstring', 'simple threshold smaller than');
cgui.thr.ui.t_dyn = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.thr.ui.cX-cgui.ui.xrel cgui.thr.ui.cY-2*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 1, ...
    'String', 'dyn.', 'callback', '', ...
    'tooltipstring', 'dynamic threshold (depends on neighbourhood)');

% skl_ controler
%    top right coordinates:
cgui.skl.ui.cX = .99-.01-3*cgui.ui.xrel; cgui.skl.ui.cY = .975-7*cgui.ui.yrel-.0225;
cgui.skl.ui.c = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.7 1 .7], 'Style', 'frame', ...
    'Position', [cgui.skl.ui.cX-3.05*cgui.ui.xrel cgui.skl.ui.cY-3.05*cgui.ui.yrel ...
    3.1*cgui.ui.xrel 3.1*cgui.ui.yrel], ...
    'tooltipstring', 'skeletonization panel');
cgui.skl.ui.r1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.7 1 .7], 'Style', 'radiobutton', 'value', 1, ...
    'Position', [cgui.skl.ui.cX-3*cgui.ui.xrel cgui.skl.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''skl_image'')', ...
    'tooltipstring', 'toggle points on/off');
cgui.skl.ui.b1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.skl.ui.cX-2.5*cgui.ui.xrel cgui.skl.ui.cY-cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'skel', 'callback', 'cgui_tree(''skl_skel'')', ...
    'tooltipstring', 'skeletonize thresholded image stacks');
cgui.skl.ui.t_close = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.skl.ui.cX-1.75*cgui.ui.xrel cgui.skl.ui.cY-cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 1, ...
    'String', '.', 'callback', '', 'tooltipstring', ...
    'skeletonize with preceding image closure (requires image processing toolbox)');
cgui.skl.ui.b3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.skl.ui.cX-1.5*cgui.ui.xrel cgui.skl.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'clean', 'callback', 'cgui_tree(''skl_clean'')', ...
    'tooltipstring', 'set minimum distance between points');
cgui.skl.ui.ed_clean1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '3', 'Style', 'edit', ...
    'Position', [cgui.skl.ui.cX-cgui.ui.xrel cgui.skl.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'tooltipstring', 'minimum distance between points');
cgui.skl.ui.t_D = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.skl.ui.cX-.5*cgui.ui.xrel cgui.skl.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'D', 'callback', 'cgui_tree(''skl_clearpoints'')', 'value', 1, ...
    'tooltipstring', 'extract diameters when skeletonizing');
cgui.skl.ui.r2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.7 1 .7], 'Style', 'radiobutton', 'value', 1, ...
    'Position', [cgui.skl.ui.cX-3*cgui.ui.xrel cgui.skl.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''skl_image'')', ...
    'tooltipstring', 'toggle somata on/off');
cgui.skl.ui.b4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.skl.ui.cX-2.5*cgui.ui.xrel cgui.skl.ui.cY-2*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'soma', 'callback', 'cgui_tree(''skl_soma'')', ...
    'tooltipstring', 'find somata automatically');
cgui.skl.ui.ed_soma1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '5', 'Style', 'edit', ...
    'Position', [cgui.skl.ui.cX-1.5*cgui.ui.xrel cgui.skl.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', '', 'tooltipstring', 'soma set size');
cgui.skl.ui.b5 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.skl.ui.cX-cgui.ui.xrel cgui.skl.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'cls', 'callback', 'cgui_tree(''skl_clear'')', ...
    'tooltipstring', 'clear somata locations');
cgui.skl.ui.t_L = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.skl.ui.cX-.5*cgui.ui.xrel cgui.skl.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 1, ...
    'String', 'L', 'callback', 'cgui_tree(''skl_clearpoints'')', ...
    'tooltipstring', 'label: extract threshold floodfill connection when skeletonizing');
cgui.skl.ui.r3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [.7 1 .7], 'Style', 'radiobutton', 'value', 1, ...
    'Position', [cgui.skl.ui.cX-3*cgui.ui.xrel cgui.skl.ui.cY-3*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''skl_image'')', ...
    'tooltipstring', 'toggle connectivity matrix on/off');
cgui.skl.ui.b6 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.skl.ui.cX-2.5*cgui.ui.xrel cgui.skl.ui.cY-3*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '_|-', 'callback', 'cgui_tree(''skl_tCN'')', ...
    'tooltipstring', 'calculating floodfill connectivity from label');
cgui.skl.ui.b7 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.skl.ui.cX-2*cgui.ui.xrel cgui.skl.ui.cY-3*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '.', 'callback', 'cgui_tree(''skl_tCN_L'')', ...
    'tooltipstring', 'calculating floodfill connectivity with label anew');
cgui.skl.ui.ed_tCN = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'String', '2', 'Style', 'edit', ...
    'Position', [cgui.skl.ui.cX-1.75*cgui.ui.xrel cgui.skl.ui.cY-3*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''skl_updateCN'')', ...
    'tooltipstring', 'weighting floodfill connection for connection matrix');
% % add example button for additional connectivity component (orientation
% % similarity)
% cgui.skl.ui.b7 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
%     'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
%     'Position', [cgui.skl.ui.cX-1.25*cgui.ui.xrel cgui.skl.ui.cY-3*cgui.ui.yrel ...
%     .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
%     'String', '->', 'callback', 'cgui_tree(''skl_dCN'')', ...
%     'tooltipstring', 'extract gradient orientation when skeletonizing');
% cgui.skl.ui.ed_dCN = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
%     'BackgroundColor', cgui.NColor.edit, 'String', '100', 'Style', 'edit', ...
%     'Position', [cgui.skl.ui.cX-.75*cgui.ui.xrel cgui.skl.ui.cY-3*cgui.ui.yrel ...
%     .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
%     'callback', 'cgui_tree(''skl_updateCN'')', ...
%     'tooltipstring', 'weighting orientation similarity for connection matrix');

% mtr_ controler
%    top right coordinates:
cgui.mtr.ui.cX = .99-.01-3*cgui.ui.xrel; cgui.mtr.ui.cY = .975-11.5*cgui.ui.yrel-.0225;
cgui.mtr.ui.c = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [1 .7 .7], 'Style', 'frame', ...
    'Position', [cgui.mtr.ui.cX-3.05*cgui.ui.xrel cgui.mtr.ui.cY-11.55*cgui.ui.yrel ...
    3.1*cgui.ui.xrel 11.6*cgui.ui.yrel], ...
    'tooltipstring', 'tree panel');
cgui.mtr.ui.r1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [1 .7 .7], 'Style', 'radiobutton', 'value', 1, ...
    'Position', [cgui.mtr.ui.cX-3*cgui.ui.xrel cgui.mtr.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''mtr_r1'')', ...
    'tooltipstring', 'toggle skeleton plot on/off');
cgui.mtr.ui.r2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [1 .7 .7], 'Style', 'radiobutton', 'value', 0, ...
    'Position', [cgui.mtr.ui.cX-2.5*cgui.ui.xrel cgui.mtr.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''mtr_r2'')', ...
    'tooltipstring', 'toggle filled plot on/off');
cgui.mtr.ui.r3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [1 .7 .7], 'Style', 'radiobutton', 'value', 0, ...
    'Position', [cgui.mtr.ui.cX-2*cgui.ui.xrel cgui.mtr.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''mtr_r3'')', ...
    'tooltipstring', 'toggle dir. graph on/off');
cgui.mtr.ui.r4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [1 .7 .7], 'Style', 'radiobutton', 'value', 0, ...
    'Position', [cgui.mtr.ui.cX-1.5*cgui.ui.xrel cgui.mtr.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''mtr_r4'')', ...
    'tooltipstring', 'toggle values plot on/off');
cgui.mtr.ui.r5 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [1 .7 .7], 'Style', 'radiobutton', 'value', 1, ...
    'Position', [cgui.mtr.ui.cX-.5*cgui.ui.xrel cgui.mtr.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''mtr_r5'')', ...
    'tooltipstring', 'toggle plot transparency on/off');
cgui.mtr.ui.b1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-3*cgui.ui.xrel cgui.mtr.ui.cY-2*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'MST', 'callback', 'cgui_tree(''mtr_MST'')', ...
    'tooltipstring', 'construct tree from skeletonized points');
cgui.mtr.ui.ed_mst1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-2*cgui.ui.xrel cgui.mtr.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '0.2', 'callback', '', ...
    'tooltipstring', 'MST balancing factor');
cgui.mtr.ui.ed_mst2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-1.5*cgui.ui.xrel cgui.mtr.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '20', 'callback', '', ...
    'tooltipstring', 'MST maximum distance connection');
cgui.mtr.ui.ed_mst3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-cgui.ui.xrel cgui.mtr.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '10000', 'callback', '', ...
    'tooltipstring', 'MST maximum path distance');
cgui.mtr.ui.t_rst = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.mtr.ui.cX-.5*cgui.ui.xrel cgui.mtr.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 1, ...
    'String', 'RST', 'callback', '', ...
    'tooltipstring', 'MST construction using thresholded image data');
cgui.mtr.ui.b3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-3*cgui.ui.xrel cgui.mtr.ui.cY-3*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'clean', 'callback', 'cgui_tree(''mtr_clean'')', ...
    'tooltipstring', 'clean unrealistic branches');
cgui.mtr.ui.ed_clean1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-2*cgui.ui.xrel cgui.mtr.ui.cY-3*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '10', 'callback', 'cgui_tree(''mtr_ed9'')', ...
    'tooltipstring', 'cleaning intensity');
cgui.mtr.ui.b4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-1.5*cgui.ui.xrel cgui.mtr.ui.cY-3*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'res.', 'callback', 'cgui_tree(''mtr_resample'')', ...
    'tooltipstring', 'resample nodes to imprecise constant internode distance');
cgui.mtr.ui.b5 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-.75*cgui.ui.xrel cgui.mtr.ui.cY-3*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '.', 'callback', 'cgui_tree(''mtr_resamplelong'')', ...
    'tooltipstring', 'resample nodes for length conservation');
cgui.mtr.ui.ed_resample1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-.5*cgui.ui.xrel cgui.mtr.ui.cY-3*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '2', 'callback', 'cgui_tree(''mtr_ed7'')', ...
    'tooltipstring', 'internode distance');
cgui.mtr.ui.b6 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-3*cgui.ui.xrel cgui.mtr.ui.cY-4*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'repair', 'callback', 'cgui_tree(''mtr_repair'')', ...
    'tooltipstring', 'repair connectivity matrix (dA) of the tree');
cgui.mtr.ui.b7 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-2*cgui.ui.xrel cgui.mtr.ui.cY-4*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'redir.', 'callback', 'cgui_tree(''mtr_redirect'')', ...
    'tooltipstring', 'set a new root to the graph');
cgui.mtr.ui.b8 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-cgui.ui.xrel cgui.mtr.ui.cY-4*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'BCT', 'callback', 'cgui_tree(''mtr_BCT'')', ...
    'tooltipstring', 'construct equivalent tree');
cgui.mtr.ui.b9 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-3*cgui.ui.xrel cgui.mtr.ui.cY-5*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 's--', 'callback', 'cgui_tree(''mtr_smooth'')', ...
    'tooltipstring', 'smoothen tree along heavy branches');
cgui.mtr.ui.ed_smooth1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-2.5*cgui.ui.xrel cgui.mtr.ui.cY-5*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '.5', 'callback', '', ...
    'tooltipstring', 'smoothing strength');
cgui.mtr.ui.ed_smooth2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-2*cgui.ui.xrel cgui.mtr.ui.cY-5*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '2', 'callback', '', ...
    'tooltipstring', 'smoothing number of iterations');
cgui.mtr.ui.b10 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-1.5*cgui.ui.xrel cgui.mtr.ui.cY-5*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'j~~', 'callback', 'cgui_tree(''mtr_jitter'')', ...
    'tooltipstring', 'add spatial noise to node coordinates');
cgui.mtr.ui.ed_jitter1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-cgui.ui.xrel cgui.mtr.ui.cY-5*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '.1', 'callback', '', ...
    'tooltipstring', 'noise amplitude');
cgui.mtr.ui.ed_jitter2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-.5*cgui.ui.xrel cgui.mtr.ui.cY-5*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '10', 'callback', '', ...
    'tooltipstring', 'noise filter length constant');
cgui.mtr.ui.b11 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-3*cgui.ui.xrel cgui.mtr.ui.cY-6*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'morph', 'callback', 'cgui_tree(''mtr_morph'')', ...
    'tooltipstring', 'change segment lengths according to values vector');
cgui.mtr.ui.b12 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-2.25*cgui.ui.xrel cgui.mtr.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '2', 'callback', 'cgui_tree(''mtr_flat'')', ...
    'tooltipstring', 'flatten tree to XY plane conserving length values');
cgui.mtr.ui.b13 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-2*cgui.ui.xrel cgui.mtr.ui.cY-6*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'zcorr', 'callback', 'cgui_tree(''mtr_zcorr'')', ...
    'tooltipstring', 'cut jumps in z larger than threshold');
cgui.mtr.ui.ed_zcorr1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-1.5*cgui.ui.xrel cgui.mtr.ui.cY-6*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '5', 'callback', '', ...
    'tooltipstring', 'zcorr threshold');
cgui.mtr.ui.b14 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-cgui.ui.xrel cgui.mtr.ui.cY-6*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'discon', 'callback', 'cgui_tree(''mtr_discon'')', ...
    'tooltipstring', 'disconnect subtree');
cgui.mtr.ui.b15 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-3*cgui.ui.xrel cgui.mtr.ui.cY-7*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'qdiam', 'callback', 'cgui_tree(''mtr_quaddiameter'')', ...
    'tooltipstring', 'map quadratic diameter decay');
cgui.mtr.ui.b16 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-2.25*cgui.ui.xrel cgui.mtr.ui.cY-7*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '.', 'callback', 'cgui_tree(''mtr_quadfit'')', ...
    'tooltipstring', 'automatic mapping quadratic diameter decay');
cgui.mtr.ui.ed_qdiam1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-2*cgui.ui.xrel cgui.mtr.ui.cY-7*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '0.3', 'callback', 'cgui_tree(''mtr_ed5'')', ...
    'tooltipstring', 'diameter decay scaling');
cgui.mtr.ui.ed_qdiam2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-1.5*cgui.ui.xrel cgui.mtr.ui.cY-7*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '3', 'callback', 'cgui_tree(''mtr_ed6'')', ...
    'tooltipstring', 'diameter decay offset');
cgui.mtr.ui.b17 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-cgui.ui.xrel cgui.mtr.ui.cY-7*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'c', 'callback', 'cgui_tree(''mtr_constD'')', ...
    'tooltipstring', 'maps constant diameter,  uses offset parameter');
cgui.mtr.ui.b18 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-.5*cgui.ui.xrel cgui.mtr.ui.cY-7*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'F', 'callback', 'cgui_tree(''mtr_friedrichD'')', ...
    'tooltipstring', 'maps diameter from image stack maximum intensity projections');
cgui.mtr.ui.b19 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-3*cgui.ui.xrel cgui.mtr.ui.cY-8*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'spines', 'callback', 'cgui_tree(''mtr_spines'')', ...
    'tooltipstring', 'add spines');
cgui.mtr.ui.b20 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-2.25*cgui.ui.xrel cgui.mtr.ui.cY-8*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '.', 'callback', 'cgui_tree(''mtr_spines2'')', ...
    'tooltipstring', 'add spines from skeletonized points');
cgui.mtr.ui.ed_spines1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-2*cgui.ui.xrel cgui.mtr.ui.cY-8*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '1000', 'callback', '', ...
    'tooltipstring', 'number of spines');
cgui.mtr.ui.ed_spines2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-1.5*cgui.ui.xrel cgui.mtr.ui.cY-8*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '.5', 'callback', '', ...
    'tooltipstring', 'neck diameter');
cgui.mtr.ui.ed_spines3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-cgui.ui.xrel cgui.mtr.ui.cY-8*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '1', 'callback', '', ...
    'tooltipstring', 'head diameter');
cgui.mtr.ui.ed_spines4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-.5*cgui.ui.xrel cgui.mtr.ui.cY-8*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '2', 'callback', '', ...
    'tooltipstring', 'neck length');
cgui.mtr.ui.b21 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-3*cgui.ui.xrel cgui.mtr.ui.cY-9*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'som', 'callback', 'cgui_tree(''mtr_soma'')', ...
    'tooltipstring', 'add soma diameter');
cgui.mtr.ui.ed_soma1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-2.5*cgui.ui.xrel cgui.mtr.ui.cY-9*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '50', 'callback', '', ...
    'tooltipstring', 'soma diameter');
cgui.mtr.ui.ed_soma2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-2*cgui.ui.xrel cgui.mtr.ui.cY-9*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '50', 'callback', '', ...
    'tooltipstring', 'soma length');
cgui.mtr.ui.b22 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-1.5*cgui.ui.xrel cgui.mtr.ui.cY-9*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'clone', 'callback', 'cgui_tree(''mtr_clone'')', ...
    'tooltipstring', 'clone tree using MST');
cgui.mtr.ui.ed_clone1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.mtr.ui.cX-.5*cgui.ui.xrel cgui.mtr.ui.cY-9*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '1', 'callback', '', ...
    'tooltipstring', 'number of clones');

% mtr_ controler - manual editing
cgui.mtr.ui.t_snap1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.mtr.ui.cX-3*cgui.ui.xrel cgui.mtr.ui.cY-10.5*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 0, ...
    'String', 'snap', 'callback', 'cgui_tree(''mtr_t_snap1'')', ...
    'tooltipstring', 'snap to threshold');
cgui.mtr.ui.t_snap2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.mtr.ui.cX-2.25*cgui.ui.xrel cgui.mtr.ui.cY-10.5*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 0, ...
    'String', '.', 'callback', 'cgui_tree(''mtr_t_snap2'')', ...
    'tooltipstring', 'snap to skeletonized');
cgui.mtr.ui.t_snap3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.mtr.ui.cX-2*cgui.ui.xrel cgui.mtr.ui.cY-10.5*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 0, ...
    'String', 'zmax', 'callback', 'cgui_tree(''mtr_t_snap3'')', ...
    'tooltipstring', 'snap to third dimension maximum');
cgui.mtr.ui.t_snap4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.mtr.ui.cX-1.25*cgui.ui.xrel cgui.mtr.ui.cY-10.5*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 0, ...
    'String', '.', 'callback', 'cgui_tree(''mtr_t_snap4'')', ...
    'tooltipstring', 'snap third dimension to tree');
cgui.mtr.ui.t_selp = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.mtr.ui.cX-cgui.ui.xrel cgui.mtr.ui.cY-10.5*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 0, ...
    'String', 'sel+', 'callback', '', 'tooltipstring', 'add to selection');
cgui.mtr.ui.b23 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.mtr.ui.cX-.5*cgui.ui.xrel cgui.mtr.ui.cY-10.5*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'new', 'callback', 'cgui_tree(''mtr_empty'')', ...
    'tooltipstring', 'start reconstruction with empty tree');
cgui.mtr.ui.t_move1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.mtr.ui.cX-3*cgui.ui.xrel cgui.mtr.ui.cY-11.5*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 1, ...
    'String', 'single', 'callback', 'cgui_tree(''mtr_t_move1'')', ...
    'tooltipstring', 'move single node');
cgui.mtr.ui.t_move2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.mtr.ui.cX-2.25*cgui.ui.xrel cgui.mtr.ui.cY-11.5*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 0, ...
    'String', 'sel.', 'callback', 'cgui_tree(''mtr_t_move2'')', ...
    'tooltipstring', 'move selected nodes');
cgui.mtr.ui.t_move3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.mtr.ui.cX-1.5*cgui.ui.xrel cgui.mtr.ui.cY-11.5*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 0, ...
    'String', 'subtree', 'callback', 'cgui_tree(''mtr_t_move3'')', ...
    'tooltipstring', 'move subtree');
cgui.mtr.ui.t_move4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.mtr.ui.cX-.75*cgui.ui.xrel cgui.mtr.ui.cY-11.5*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 0, ...
    'String', 'goo', 'callback', 'cgui_tree(''mtr_t_move4'')', ...
    'tooltipstring', 'gooie move');

% _ged controler
%    top right coordinates:
cgui.ged.ui.cX = .99-.01-3*cgui.ui.xrel; cgui.ged.ui.cY = .975-23.5*cgui.ui.yrel-.0225;
cgui.ged.ui.c = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [1 1 .7], 'Style', 'frame', ...
    'Position', [cgui.ged.ui.cX-3.05*cgui.ui.xrel cgui.ged.ui.cY-8.05*cgui.ui.yrel ...
    3.1*cgui.ui.xrel 8.1*cgui.ui.yrel], ...
    'tooltipstring', 'tree positioner panel');
cgui.ged.ui.r1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [1 1 .7], 'Style', 'radiobutton', 'value', 1, ...
    'Position', [cgui.ged.ui.cX-3*cgui.ui.xrel cgui.ged.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''ged_r1'')', ...
    'tooltipstring', 'toggle plot other trees on/off');
cgui.ged.ui.r2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', [1 1 .7], 'Style', 'radiobutton', 'value', 0, ...
    'Position', [cgui.ged.ui.cX-2.5*cgui.ui.xrel cgui.ged.ui.cY-cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'callback', 'cgui_tree(''ged_r2'')', ...
    'tooltipstring', 'toggle brainbow plot on/off');
cgui.ged.ui.t1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.ged.ui.cX-1.95*cgui.ui.xrel cgui.ged.ui.cY-cgui.ui.yrel ...
    .65*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 0, ...
    'String', 'scale', 'callback', 'cgui_tree(''ged_scaleedit'')', ...
    'tooltipstring', 'scale tree on edit');
cgui.ged.ui.t2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.ged.ui.cX-1.3*cgui.ui.xrel cgui.ged.ui.cY-cgui.ui.yrel ...
    .65*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 0, ...
    'String', 'rotate', 'callback', 'cgui_tree(''ged_rotedit'')', ...
    'tooltipstring', 'rotate tree on edit');
cgui.ged.ui.t3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.ged.ui.cX-.65*cgui.ui.xrel cgui.ged.ui.cY-cgui.ui.yrel ...
    .65*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'value', 1, ...
    'String', 'move', 'callback', 'cgui_tree(''ged_moveedit'')', ...
    'tooltipstring', 'move tree on edit');
cgui.ged.ui.t_group = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.toggle, 'Style', 'toggle', ...
    'Position', [cgui.ged.ui.cX-3*cgui.ui.xrel cgui.ged.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', 'String', 'G', 'callback', '', ...
    'tooltipstring', 'apply on all trees in the group');
cgui.ged.ui.b1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-2.5*cgui.ui.xrel cgui.ged.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'scale', 'callback', 'cgui_tree(''ged_scale'')', ...
    'tooltipstring', 'scale tree');
cgui.ged.ui.ed_scale1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.ged.ui.cX-2*cgui.ui.xrel cgui.ged.ui.cY-2*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '2', 'callback', 'cgui_tree(''ged_ed1'')', ...
    'tooltipstring', 'scaling factor');
cgui.ged.ui.b2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-cgui.ui.xrel cgui.ged.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', ':', 'callback', 'cgui_tree(''ged_scale1'')', ...
    'tooltipstring', 'scaling 90%');
cgui.ged.ui.b3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-.5*cgui.ui.xrel cgui.ged.ui.cY-2*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'x', 'callback', 'cgui_tree(''ged_scale2'')', ...
    'tooltipstring', 'scaling 110%');
cgui.ged.ui.b4 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-3*cgui.ui.xrel cgui.ged.ui.cY-3*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '<', 'callback', 'cgui_tree(''ged_tran1'')', ...
    'tooltipstring', 'translate tree x - 1um');
cgui.ged.ui.b5 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-2.5*cgui.ui.xrel cgui.ged.ui.cY-3*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '>', 'callback', 'cgui_tree(''ged_tran2'')', ...
    'tooltipstring', 'translate tree x + 1um');
cgui.ged.ui.b6 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-2*cgui.ui.xrel cgui.ged.ui.cY-3*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '<', 'callback', 'cgui_tree(''ged_tran3'')', ...
    'tooltipstring', 'translate tree y - 1um');
cgui.ged.ui.b7 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-1.5*cgui.ui.xrel cgui.ged.ui.cY-3*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '>', 'callback', 'cgui_tree(''ged_tran4'')', ...
    'tooltipstring', 'translate tree y + 1um');
cgui.ged.ui.b8 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-cgui.ui.xrel cgui.ged.ui.cY-3*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '<', 'callback', 'cgui_tree(''ged_tran5'')', ...
    'tooltipstring', 'translate tree z - 1um');
cgui.ged.ui.b9 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-.5*cgui.ui.xrel cgui.ged.ui.cY-3*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '>', 'callback', 'cgui_tree(''ged_tran6'')', ...
    'tooltipstring', 'translate tree z + 1um');
cgui.ged.ui.ed_tran1 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.ged.ui.cX-3*cgui.ui.xrel cgui.ged.ui.cY-4*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '0', 'callback', 'cgui_tree(''ged_traned1'')', ...
    'tooltipstring', 'root x position');
cgui.ged.ui.ed_tran2 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.ged.ui.cX-2*cgui.ui.xrel cgui.ged.ui.cY-4*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '0', 'callback', 'cgui_tree(''ged_traned2'')', ...
    'tooltipstring', 'root y position');
cgui.ged.ui.ed_tran3 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.edit, 'Style', 'edit', ...
    'Position', [cgui.ged.ui.cX-cgui.ui.xrel cgui.ged.ui.cY-4*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '0', 'callback', 'cgui_tree(''ged_traned3'')', ...
    'tooltipstring', 'root z position');
cgui.ged.ui.b10 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-3*cgui.ui.xrel cgui.ged.ui.cY-5*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '0', 'callback', 'cgui_tree(''ged_zero'')', ...
    'tooltipstring', 'zero root position');
cgui.ged.ui.b12 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-2*cgui.ui.xrel cgui.ged.ui.cY-5*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'pcrot', 'callback', 'cgui_tree(''ged_rotpc'')', ...
    'tooltipstring', 'rotate according to principal components');
cgui.ged.ui.b13 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-1.25*cgui.ui.xrel cgui.ged.ui.cY-5*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '2', 'callback', 'cgui_tree(''ged_rotpc2d'')', ...
    'tooltipstring', 'rotate according to 2D principal components');
cgui.ged.ui.b14 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-cgui.ui.xrel cgui.ged.ui.cY-5*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'mrot', 'callback', 'cgui_tree(''ged_rotmean'')', ...
    'tooltipstring', 'rotate according to mean XY axis');
cgui.ged.ui.b15 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-3*cgui.ui.xrel cgui.ged.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '-', 'callback', 'cgui_tree(''ged_rot10'')', ...
    'tooltipstring', 'rotate -10 deg around x axis');
cgui.ged.ui.b16 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-2.25*cgui.ui.xrel cgui.ged.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '+', 'callback', 'cgui_tree(''ged_rot20'')', ...
    'tooltipstring', 'rotate +10 deg around x axis');
cgui.ged.ui.b17 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-2*cgui.ui.xrel cgui.ged.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '-', 'callback', 'cgui_tree(''ged_rot30'')', ...
    'tooltipstring', 'rotate -10 deg around y axis');
cgui.ged.ui.b18 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-1.25*cgui.ui.xrel cgui.ged.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '+', 'callback', 'cgui_tree(''ged_rot40'')', ...
    'tooltipstring', 'rotate +10 deg around y axis');
cgui.ged.ui.b19 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-cgui.ui.xrel cgui.ged.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '-', 'callback', 'cgui_tree(''ged_rot50'')', ...
    'tooltipstring', 'rotate -10 deg around z axis');
cgui.ged.ui.b20 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-.25*cgui.ui.xrel cgui.ged.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '+', 'callback', 'cgui_tree(''ged_rot60'')', ...
    'tooltipstring', 'rotate +10 deg around z axis');
cgui.ged.ui.b21 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-2.75*cgui.ui.xrel cgui.ged.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '<', 'callback', 'cgui_tree(''ged_rot1'')', ...
    'tooltipstring', 'rotate -1 deg around x axis');
cgui.ged.ui.b22 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-2.5*cgui.ui.xrel cgui.ged.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '>', 'callback', 'cgui_tree(''ged_rot2'')', ...
    'tooltipstring', 'rotate +1 deg around x axis');
cgui.ged.ui.b23 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-1.75*cgui.ui.xrel cgui.ged.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '<', 'callback', 'cgui_tree(''ged_rot3'')', ...
    'tooltipstring', 'rotate -1 deg around y axis');
cgui.ged.ui.b24 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-1.5*cgui.ui.xrel cgui.ged.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '>', 'callback', 'cgui_tree(''ged_rot4'')', ...
    'tooltipstring', 'rotate +1 deg around y axis');
cgui.ged.ui.b25 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-.75*cgui.ui.xrel cgui.ged.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '<', 'callback', 'cgui_tree(''ged_rot5'')', ...
    'tooltipstring', 'rotate -1 deg around z axis');
cgui.ged.ui.b26 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-.5*cgui.ui.xrel cgui.ged.ui.cY-6*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '>', 'callback', 'cgui_tree(''ged_rot6'')', ...
    'tooltipstring', 'rotate +1 deg around z axis');
cgui.ged.ui.b27 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-3*cgui.ui.xrel cgui.ged.ui.cY-7*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'flipx', 'callback', 'cgui_tree(''ged_flipx'')', ...
    'tooltipstring', 'flip x values of tree');
cgui.ged.ui.b28 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-2*cgui.ui.xrel cgui.ged.ui.cY-7*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'flipy', 'callback', 'cgui_tree(''ged_flipy'')', ...
    'tooltipstring', 'flip y values of tree');
cgui.ged.ui.b29 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-cgui.ui.xrel cgui.ged.ui.cY-7*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'flipz', 'callback', 'cgui_tree(''ged_flipz'')', ...
    'tooltipstring', 'flip z values of tree');
cgui.ged.ui.b30 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-3*cgui.ui.xrel cgui.ged.ui.cY-8*cgui.ui.yrel ...
    cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'concat', 'callback', 'cgui_tree(''ged_concat'')', ...
    'tooltipstring', 'concatenate tree with n-1 tree');
cgui.ged.ui.b31 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-2*cgui.ui.xrel cgui.ged.ui.cY-8*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'D+', 'callback', 'cgui_tree(''ged_dp1'')', ...
    'tooltipstring', 'increase tree diameters by 1um');
cgui.ged.ui.b32 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-1.5*cgui.ui.xrel cgui.ged.ui.cY-8*cgui.ui.yrel ...
    .5*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'D-', 'callback', 'cgui_tree(''ged_dm1'')', ...
    'tooltipstring', 'increase tree diameters by 1um');
cgui.ged.ui.b33 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-cgui.ui.xrel cgui.ged.ui.cY-8*cgui.ui.yrel ...
    .75*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', 'spread', 'callback', 'cgui_tree(''ged_spread'')', ...
    'tooltipstring', 'spread tree coordinates');
cgui.ged.ui.b34 = uicontrol('Parent', cgui.ui.F, 'units', 'normalized', ...
    'BackgroundColor', cgui.NColor.button, 'Style', 'push', ...
    'Position', [cgui.ged.ui.cX-.25*cgui.ui.xrel cgui.ged.ui.cY-8*cgui.ui.yrel ...
    .25*cgui.ui.xrel cgui.ui.yrel], 'enable', 'off', ...
    'String', '.', 'callback', 'cgui_tree(''ged_unspread'')', ...
    'tooltipstring', 'unspread tree coordinates if possible');