#Brief explanation of how to run simulations and extract information
#run this file, or other files with series of commands, with the following command
# at -f NeuroRDexample.bat NOW
#
# this first line runs the simulation for Model_0842...  A batch file to run all simulations is in NeuroRD.bat 
java -jar stochdiff2.1.9.jar Model_0842_0113_0428_0031_Gi_p4LR_Ca_1xGibind.xml > Model_0842_0113_0428_0031_Gi_p4LR_Ca_1xGibind.log &

# The second and third lines extract Epac1 and Epac1cAMP concentration (note the -m[Epac1cAMP] flag). 
NRDPostAB -i[Model_0842_0113_0428_0031_Gi_p4LR_Ca_1xGibind-dt100-conc.txt] -r[Model_0842_0113_0428_0031_Gi_p4LR_Ca_1xGibind-mesh.txt] -m[Epac1cAMP] -n -o[Model_0842_SW_Gibind1x_Ca]
NRDPostAB -i[Model_0842_0113_0428_0031_Gi_p4LR_Ca_1xGibind-dt100-conc.txt] -r[Model_0842_0113_0428_0031_Gi_p4LR_Ca_1xGibind-mesh.txt] -m[Epac1] -n -o[Model_0842_SW_Gibind1x_Ca]
#
# the python program: NRDpost.py will create a file with the appropriate pairs of lines for each Model*.xml file in the directory
# NRDpostAutoEdited.bat is an example of such a file
#
# This can be changed to any molecules species listed in the IO*.xml file associated with the simulation.
# For example, NRDpostMol.bat contains to commands used to extract other molecules, such as phosphorylated PDE4 or active PKA
# sum different molecule forms using the python program: SumMoleculeForms.py
#

# This fourth line calculates fret from Epac1 and Epac1cAMP. 
# Specify prefix=Model_* will calculate fret from ALL files, or specify prefix=Model_0838* will only evaluate a single model 
python BatchFRET.py
#
#This last line will extract the peaks and calculate the difference between NMDA after ISO and NMDA alone
#Must specify pairs of files to process within the program
python Fret_peaks.py




