#Calculate the peak fret values for bar plots
#calculates 1 sec mean around the peak

import os
from numpy import *
from pylab import *
from string import *
from pprint import pprint as pp
import glob

#fname set is list of models to process, excluding the word Model_ and -fret.txt
fnamelist=[
#        ['0720_DR_Gbgl_Ep10x_Ca', '0718_DR_Gbgl_Ep10x_LCa'],
#        ['0721_DR_Gbgl_Ep20x_Ca', '0719_DR_Gbgl_Ep20x_LCa'],
#        ['0768_pPDE40x_PKAc3x_Ca', '0769_pPDE40x_PKAc3x_LCa'],
#        ['0766_pPDE40x_PKAc10x_Ca', '0767_pPDE40x_PKAc10x_LCa'],
#        ['0778_pPDE4x_4xPDEsm_Ca', '0779_pPDE4x_4xPDEsm_LCa'],
#        ['0774_pPDE4x_4xPDEsm_Ca', '0775_pPDE4x_4xPDEsm_LCa'],
#        ['0772_pPDE40x_4xPDEsm_Ca', '0773_pPDE40x_4xPDEsm_LCa'],
#        ['0782_pPDE2x_Ca', '0783_pPDE2x_LCa'],
#        ['0784_pPDE4x_Ca', '0785_pPDE4x_LCa'],
#        ['0788_pPDE10x_Ca', '0789_pPDE10x_LCa'],
#        ['0782_GapGs10pPDE2x_Ca', '0783_GapGs10pPDE2x_LCa'],
#        ['0784_GapGs10pPDE4x_Ca', '0785_GapGs10pPDE4x_LCa'],
#        ['0788_GapGs10pPDE10x_Ca', '0789_GapGs10pPDE10x_LCa'],
#        ['0790_pPDE40x_Ca', '0791_pPDE40x_LCa'],
#        ['0790_GapGs10_40xpPDE4_Ca', '0791_GapGs10_40xpPDE4_LCa'],
#        ['0792_pPDE4x_PKAc10x_Ca', '0793_pPDE4x_PKAc10x_LCa'],
#        ['0794_pPDE4x_PKAc3x_Ca', '0795_pPDE4x_PKAc3x_LCa'],
#        ['0796_pPDE10x_PKAc10x_Ca', '0797_pPDE10x_PKAc10x_LCa'],
#        ['0798_pPDE10x_PKAc3x_Ca', '0799_pPDE10x_PKAc3x_LCa'],
#    ['0842_SW_Gibind1x_Ca', '0843_SW_Gibind1x_LCa'],
#    ['0842_SW_Gibind1x_s155_Ca','0843_SW_Gibind1x_s155_LCa'], 
#    ['0842_SW_Gibind1x_s156_Ca','0843_SW_Gibind1x_s156_LCa'],
#        ['0857_SW_Gibindp2_Ca','0839_SW_Gibindp2_LCa'],
#        ['0856_SW_Gibindp5_Ca','0841_SW_Gibindp5_LCa'],
#        ['0858_SW_Gibind2x_Ca','0845_SW_Gibind2x_LCa'],
#        ['0857_SW_Gibindp2_Ca','0850_SW_Gip2_ItN4'],
#        ['0842_SW_Gibind1x_Ca','0851_SW_Gi1x_ItN4'],
#        ['0856_SW_Gibindp5_Ca','0852_SW_Gip5_ItN4'],
#        ['0858_SW_Gibind2x_Ca', '0855_SW_Gibind2x_ItN4'],
#        ['0935_SW_noACGi_Ca', '0854_SW_noACGi_ItN4']
#        ['0881_DR_PKA10x_Ca','0901_DR_PKA10x_LCa'],
#        ['0882_DR_PKA3x_Ca','0902_DR_PKA3x_LCa'],
#        ['0883_DR_PKA3d_Ca','0903_DR_PKA3d_LCa'],
#        ['0884_DR_PKA50x_Ca','0904_DR_PKA50x_LCa'],
#        ['0885_DR_Ep10_Diff2_Ca','0905_DR_Ep10_Diff2_LCa'],
#        ['0886_DR_Ep10_Diffp6_Ca','0906_DR_Ep10_Diffp6_LCa'],
#        ['0887_DR_Ep20_Diff2_Ca','0907_DR_Ep20_Diff2_LCa'],
#        ['0888_DR_Ep20_Diffp6_Ca','0908_DR_Ep20_Diffp6_LCa'],
#        ['0890_DR_pPDE1x_Ca','0891_DR_pPDE1x_LCa'],
#        ['0892_DR_pPDE10x_Ca', '0893_DR_pPDE10x_LCa'],
#        ['0894_DR_pPDE20x_Ca','0895_DR_pPDE20x_LCa'],
#        ['0896_DR_pPDE40x_Ca','0897_DR_pPDE40x_LCa']
#    ['0912_SW_Rol_Ca', '0911_SW_Rol_LCa'],
#    ['0914_DR_Rol_Ca', '0913_DR_Rol_LCa'], 
#        ['0922_DR_Gbg_Ep20x_Ca', '0919_DR_Gbg_Ep20x_LCa'],
#        ['0921_DR_Gbg_Ep10x_Ca', '0918_DR_Gbg_Ep10x_LCa'],
    ['0929_DR_GrkGapGs10_Ca', '0928_DR_GrkGapGs10_LCa']
#    ['0926_DR_Grk_Ca', '0920_DR_Grk_LCa'],
#    ['0926_DR_Grk_Ca', '0927_DR_Grkhalf_LCa'],
#    ['0924_DR_Grk_Rol_Ca','0925_DR_Grk_Rol_LCa'],
#    ['0942_SW_2site_Ca','0943_SW_2site_LCa']
#        ['0936_SW_nopLR_Ca','0916_SW_nopLR_LCa'],
#        ['0935_SW_noACGi_Ca','0915_SW_noACGi_LCa'],
#        ['0937_SW_nopPDE_Ca','0917_SW_nopPDE4_LCa'],
#        ['0933_SW_H89_Ca', '0923_SW_H89_LCa'],
#        ['0968_DR_Ep1_PKA50x_Ca', '0964_DR_Ep1_PKA50x_LCa'],
#        ['0967_DR_Ep1_PKA3d_Ca', '0963_DR_Ep1_PKA3d_LCa'],
#        ['0966_DR_Ep1_PKA3x_Ca', '0962_DR_Ep1_PKA3x_LCa'],
#        ['0965_DR_Ep1_PKA10x_Ca', '0961_DR_Ep1_PKA10x_LCa']
]
#fnamelist=['0846_SW_Iso10u_LCa', '0847_SW_Isop1u_LCa', '0848_SW_Isop2u_LCa', '0849_SW_Isop4u_LCa']

prninfo=1
datadir="/home/avrama/HippoAkap/ChayEtAl/fixedslowGsdeg/"
prefix='Model_'
suffix='-fret.txt'
exper_type=['LCa', 'Ca','ItN4']
regionAbbrev=['_dsm', '_dcyt', '_ssm','_scyt']

#sample rate of data, and time points (in sec) limiting where to search for peaks
dt=0.1
#row0:isopeak,row1:NMDApeak,row2:ItNdiff,row3:isoend,row4: ItNpeak
isopeak=[int(30/dt),int(220/dt)]
isoend=[int(210/dt),int(220/dt)]
#For ItN use the following:
#isoend=[int(330/dt),int(340/dt)]
ItNtime=[isoend[1],int(600/dt)]
samples=int(10/dt)

def getdata(fname):
        fullname=datadir+prefix+fname+suffix
        f = open(fullname, 'r+')
        dataheader=f.readline()
        if (prninfo==1):
            print "FILE: ", fullname, "\n", 'HEADER: ', dataheader
        else:
            print "header not printed"
        alldata=loadtxt(fullname,skiprows=1)
        print alldata[0]
        f.close()
        return alldata

def extractvalues(fname,alldata, values,exper_type,regionAbbrev):
        if fname.split('_')[-1]==exper_type[0] or fname.split('_')[-1]==exper_type[2]:
            if prninfo:
                    print fname, 'LCa, extracting Iso, ItN peaks',",values shape", np.shape(values)
            for colnum in arange(1,len(regionAbbrev)+1):
                maxloc=isopeak[0]+alldata[isopeak[0]:isopeak[1],colnum].argmax()
                values[0,colnum-1]=(alldata[maxloc-samples:maxloc+samples,colnum].mean()-1)*100
                stdev[0,colnum-1]=alldata[maxloc-samples:maxloc+samples,colnum].std()*100
                values[3,colnum-1]=(alldata[isoend[0]:isoend[1],colnum].mean()-1)*100
                stdev[3,colnum-1]=alldata[isoend[0]:isoend[1],colnum].std()*100
                maxloc=ItNtime[0]+alldata[ItNtime[0]:ItNtime[1],colnum].argmax()
                values[4,colnum-1]=(alldata[maxloc-samples:maxloc+samples,colnum].mean()-1)*100
                stdev[4,colnum-1]=alldata[maxloc-samples:maxloc+samples,colnum].std()*100
                values[2,colnum-1]=values[4,colnum-1]-values[3,colnum-1]
        else:
            if fname.split('_')[-1]==exper_type[1]:
                if prninfo:
                        print fname, 'Ca, extracting NMDA peak',",values shape", np.shape(values)
                for colnum in arange(1,len(regionAbbrev)+1):
                    maxloc=alldata[:,colnum].argmax()
                    values[1,colnum-1]=(alldata[maxloc-samples:maxloc+samples,colnum].mean()-1)*100
                    stdev[1,colnum-1]=alldata[maxloc-samples:maxloc+samples,colnum].std()*100
            else:
                print "WHOOPS, unknown experiment type"
        return values,stdev

def writedata(fname,values,stdev,header):
        print fname, "\nPeak values:", values
        outfname="peaks"+fname[0:rfind(fname,'_')]+".txt"
        outdata=column_stack((values[:,0],stdev[:,0],values[:,1], stdev[:,1],values[:,2], stdev[:,2],values[:,3],stdev[:,3]))
        f=open(outfname,'w')
        savetxt(outfname, outdata, fmt='%.4f', delimiter=' ', header=str(header))
        f.close()
 
header=' '
for abbrev in regionAbbrev:
        header=header+"mean"+abbrev+" std"+abbrev+" "

if size(np.shape(fnamelist)) == 2:
        for fnum in arange(len(fnamelist)):
                values=zeros((5,len(regionAbbrev)))
                stdev=zeros((5,len(regionAbbrev)))
                for fname in fnamelist[fnum]:
                        alldata=getdata(fname)
                        values,stdev=extractvalues(fname,alldata,values,exper_type,regionAbbrev)
                writedata(fname,values,stdev,header)
else:
        for fname in fnamelist:
                values=zeros((5,len(regionAbbrev)))
                stdev=zeros((5,len(regionAbbrev)))
                alldata=getdata(fname)
                values,stdev=extractvalues(fname,alldata,values,exper_type,regionAbbrev)
                writedata(fname,values,stdev,header)
