#Python program to generate batch file for NRDPostAB processing

import os
from numpy import *
from pylab import *
from string import *
import glob
from pprint import pprint as pp
#######################################################
#Edit this part to indicate which files and which molecules
#Use glob on the .xml file
prefix='Model_'
suffix=['.xml','-mesh.txt','-dt100-conc.txt']
prninfo=1
molecule=['Epac1', 'Epac1cAMP']
NRDpost="/home/neuroware/NRDpost/NRDPostAB"
#######################################################

#1. Find all the files
pattern=prefix+'*'+suffix[0]
filenames = sorted(glob.glob(pattern))
pp(filenames)

#2. open file for writing
outfname='NRDpostAuto.bat'
f=open(outfname,'w')

#3. loop over all files and construct the processing line
for fname in filenames:
    concfile=fname[0:-4]+suffix[2]
    meshfile=fname[0:-4]+suffix[1]
    outname=fname[0:11]
    for mol in molecule:
        textline=NRDpost+" -i["+concfile+"] -r["+meshfile+"] -m["+mol+"] -n -o["+outname+"]\n"
        #output file for each input file
        f.write(textline) 
f.close()

        
