# at -f NRDpostAutoEdited.bat NOW
# in order to process the NeuroRD output files into 
# NRDpost output files. NRDpost output files consist of a time-series of concentrations for 
# one species of molecule and can thus be easily plotted, or further process with FRET.py.
# 
# Also, in this batch file, the species being processed is Epac1cAMP (note the -m[Epac1cAMP] 
# flag). This can be changed to any molecules species listed in the IO*.xml file associated 
# with the simulation.
# 
#pPDE4 for basic:
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[pPDE4] -n -o[Model_0783_pPDE2x_LCa]
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[pPDE4cAMP] -n -o[Model_0783_pPDE2x_LCa]

#pPDE4 for switching and DR
../batch/NRDPostAB -i[Model_0843_0113_0428_0029_Gi_p4LR_LCa_1xGibind-dt100-conc.txt] -r[Model_0843_0113_0428_0029_Gi_p4LR_LCa_1xGibind-mesh.txt] -m[pPDE4] -n -o[Model_0843_SW_Gibind1x_LCa]
../batch/NRDPostAB -i[Model_0843_0113_0428_0029_Gi_p4LR_LCa_1xGibind-dt100-conc.txt] -r[Model_0843_0113_0428_0029_Gi_p4LR_LCa_1xGibind-mesh.txt] -m[pPDE4cAMP] -n -o[Model_0843_SW_Gibind1x_LCa]
../batch/NRDPostAB -i[Model_0903_0112_0467_0029_noGi_p4LR_LCa_10xkcatPDE4D5sm_thirdPKAphos-dt100-conc.txt] -r[Model_0903_0112_0467_0029_noGi_p4LR_LCa_10xkcatPDE4D5sm_thirdPKAphos-mesh.txt] -m[pPDE4cAMP] -n -o[Model_0903_DR_PKA3d_LCa]
../batch/NRDPostAB -i[Model_0903_0112_0467_0029_noGi_p4LR_LCa_10xkcatPDE4D5sm_thirdPKAphos-dt100-conc.txt] -r[Model_0903_0112_0467_0029_noGi_p4LR_LCa_10xkcatPDE4D5sm_thirdPKAphos-mesh.txt] -m[pPDE4] -n -o[Model_0903_DR_PKA3d_LCa]
../batch/NRDPostAB -i[Model_0901_0112_0465_0029_noGi_p4LR_LCa_10xkcatPDE4D5sm_10xPKAphos-dt100-conc.txt] -r[Model_0903_0112_0467_0029_noGi_p4LR_LCa_10xkcatPDE4D5sm_thirdPKAphos-mesh.txt] -m[pPDE4] -n -o[Model_0901_DR_10xPKA_LCa]
../batch/NRDPostAB -i[Model_0901_0112_0465_0029_noGi_p4LR_LCa_10xkcatPDE4D5sm_10xPKAphos-dt100-conc.txt] -r[Model_0903_0112_0467_0029_noGi_p4LR_LCa_10xkcatPDE4D5sm_thirdPKAphos-mesh.txt] -m[pPDE4cAMP] -n -o[Model_0901_DR_10xPKA_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[pPDE4] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[pPDE4cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]

#PKAc for basic LCa:
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[PKAcPDE4] -n -o[Model_0783_pPDE2x_LCa]
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[PKAc] -n -o[Model_0783_pPDE2x_LCa]
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[PKAcPDE4cAMP] -n -o[Model_0783_pPDE2x_LCa]
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[I1PKAc] -n -o[Model_0783_pPDE2x_LCa]

#PKAc for basic Ca:
../batch/NRDPostAB -i[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-dt100-conc.txt] -r[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-mesh.txt] -m[PKAcPDE4] -n -o[Model_0782_pPDE2x_Ca]
../batch/NRDPostAB -i[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-dt100-conc.txt] -r[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-mesh.txt] -m[PKAc] -n -o[Model_0782_pPDE2x_Ca]
../batch/NRDPostAB -i[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-dt100-conc.txt] -r[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-mesh.txt] -m[PKAcPDE4cAMP] -n -o[Model_0782_pPDE2x_Ca]
../batch/NRDPostAB -i[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-dt100-conc.txt] -r[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-mesh.txt] -m[I1PKAc] -n -o[Model_0782_pPDE2x_Ca]

#PKAc for DR
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[PKAcPDE4] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[PKAcPDE4cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[PKAc] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[I1PKAc] -n -o[Model_0893_DR_pPDE10x_LCa]

###Other molecules for DR to understand dynamics
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[GasGTP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AC1GasGTP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AC1GasGTPCaMCa4] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AC1GasGTPCaMCa4ATP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[CaMCa4] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AC1CamCa4] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AC1CamCa4ATP] -n -o[Model_0893_DR_pPDE10x_LCa]

###Other molecules for basic LCa to understand dynamics
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[GasGTP] -n -o[Model_0783_pPDE2x_LCa]
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[AC1GasGTP] -n -o[Model_0783_pPDE2x_LCa]
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[AC1GasGTPCaMCa4] -n -o[Model_0783_pPDE2x_LCa]
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[AC1GasGTPCaMCa4ATP] -n -o[Model_0783_pPDE2x_LCa]
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[CaMCa4] -n -o[Model_0783_pPDE2x_LCa]
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[AC1CamCa4] -n -o[Model_0783_pPDE2x_LCa]
../batch/NRDPostAB -i[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-dt100-conc.txt] -r[Model_0783_0113_0401_0029_noGi_2xpPDE4_LCa-mesh.txt] -m[AC1CamCa4ATP] -n -o[Model_0783_pPDE2x_LCa]

###Other molecules for basic Ca to understand dynamics
../batch/NRDPostAB -i[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-dt100-conc.txt] -r[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-mesh.txt] -m[GasGTP] -n -o[Model_0782_pPDE2x_Ca]
../batch/NRDPostAB -i[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-dt100-conc.txt] -r[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-mesh.txt] -m[AC1GasGTP] -n -o[Model_0782_pPDE2x_Ca]
../batch/NRDPostAB -i[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-dt100-conc.txt] -r[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-mesh.txt] -m[AC1GasGTPCaMCa4] -n -o[Model_0782_pPDE2x_Ca]
../batch/NRDPostAB -i[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-dt100-conc.txt] -r[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-mesh.txt] -m[AC1GasGTPCaMCa4ATP] -n -o[Model_0782_pPDE2x_Ca]
../batch/NRDPostAB -i[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-dt100-conc.txt] -r[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-mesh.txt] -m[CaMCa4] -n -o[Model_0782_pPDE2x_Ca]
../batch/NRDPostAB -i[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-dt100-conc.txt] -r[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-mesh.txt] -m[AC1CamCa4] -n -o[Model_0782_pPDE2x_Ca]
../batch/NRDPostAB -i[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-dt100-conc.txt] -r[Model_0782_0113_0401_0031_noGi_2xpPDE4_Ca-mesh.txt] -m[AC1CamCa4ATP] -n -o[Model_0782_pPDE2x_Ca]

#Membrane PDE4D5 for dynamic redistribution
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcyPDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcycAMP2PDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcycAMP4PDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcyPDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcycAMP2PDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcycAMP4PDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcypPDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcycAMP2pPDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcycAMP4pPDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcypPDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcycAMP2pPDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcycAMP4pPDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcyPKAcPDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPcyPKAcPDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[PDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[PDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[PKAcPDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[PKAcPDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[pPDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[pPDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPsmPDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPsmPDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPsmPKAcPDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPsmPKAcPDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPsmpPDE4D5] -n -o[Model_0893_DR_pPDE10x_LCa]
../batch/NRDPostAB -i[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-dt100-conc.txt] -r[Model_0893_0112_0455_0029_noGi_p4LR_LCa_10xPDE4D5bindrel_10xkcatPDE4D5sm-mesh.txt] -m[AKAPsmpPDE4D5cAMP] -n -o[Model_0893_DR_pPDE10x_LCa]


#PKAc for switching - different ISO concentrations
#../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[PKAc] -n -o[Model_0846_SW_Iso10u_LCa]
#../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[PKAc] -n -o[Model_0847_SW_Isop1u_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[PKAc] -n -o[Model_0843_SW_Gibind1x_LCa]

#../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[PKAcPDE4] -n -o[Model_0846_SW_Iso10u_LCa]
#../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[PKAcPDE4] -n -o[Model_0847_SW_Isop1u_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[PKAcPDE4] -n -o[Model_0843_SW_Gibind1x_LCa]

#../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[PKAcPDE4cAMP] -n -o[Model_0846_SW_Iso10u_LCa]
#../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[PKAcPDE4cAMP] -n -o[Model_0847_SW_Isop1u_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[PKAcPDE4cAMP] -n -o[Model_0843_SW_Gibind1x_LCa]

#../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[PKAcLR] -n -o[Model_0846_SW_Iso10u_LCa]
#../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[PKAcLR] -n -o[Model_0847_SW_Isop1u_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[PKAcLR] -n -o[Model_0843_SW_Gibind1x_LCa]

#../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[PKAcpLR] -n -o[Model_0846_SW_Iso10u_LCa]
#../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[PKAcpLR] -n -o[Model_0847_SW_Isop1u_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[PKAcpLR] -n -o[Model_0843_SW_Gibind1x_LCa]

#../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[PKAcppLR] -n -o[Model_0846_SW_Iso10u_LCa]
#../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[PKAcppLR] -n -o[Model_0847_SW_Isop1u_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[PKAcppLR] -n -o[Model_0843_SW_Gibind1x_LCa]

#../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[PKAcpppLR] -n -o[Model_0846_SW_Iso10u_LCa]
#../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[PKAcpppLR] -n -o[Model_0847_SW_Isop1u_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[PKAcpppLR] -n -o[Model_0843_SW_Gibind1x_LCa]

#../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[I1PKAc] -n -o[Model_0846_SW_Iso10u_LCa]
#../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[I1PKAc] -n -o[Model_0847_SW_Isop1u_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[I1PKAc] -n -o[Model_0843_SW_Gibind1x_LCa]

../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[I1PKAc] -n -o[Model_0849_SW_Isop4u_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[PKAc] -n -o[Model_0849_SW_Isop4u_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[PKAcLR] -n -o[Model_0849_SW_Isop4u_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[PKAcpLR] -n -o[Model_0849_SW_Isop4u_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[PKAcppLR] -n -o[Model_0849_SW_Isop4u_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[PKAcpppLR] -n -o[Model_0849_SW_Isop4u_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[PKAcPDE4] -n -o[Model_0849_SW_Isop4u_LCa]

../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[pPDE4] -n -o[Model_0846_SW_Iso10u_LCa]
../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[pPDE4] -n -o[Model_0847_SW_Isop1u_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[pPDE4] -n -o[Model_0849_SW_Isop4u_LCa]

../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[pPDE4cAMP] -n -o[Model_0846_SW_Iso10u_LCa]
../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[pPDE4cAMP] -n -o[Model_0847_SW_Isop1u_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[pPDE4cAMP] -n -o[Model_0849_SW_Isop4u_LCa]

../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[pPDE4] -n -o[Model_0843_SW_Gibind1x_LCa]
../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[pPDE4cAMP] -n -o[Model_0843_SW_Gibind1x_LCa]

###Other molecules for switching to understand dynamics
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GasGTP] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[GasGTP] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[GasGDP] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[GaiGTP] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[Gi] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[GaiGDP] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GasGTPCaMCa4] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GasGTPCaMCa4ATP] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GaiGTP] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GaiGTPCaMCa4] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GaiGTPCaMCa4ATP] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GasGTPGaiGTP] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GasGTPGaiGTPCaMCa4] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GsGiCaMCa4ATP] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1CaMCa4ATP] -n -o[Model_0843_SW_Gibind1x_LCa]
#../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1CaMCa4] -n -o[Model_0843_SW_Gibind1x_LCa]

../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GaiGTPCaMCa4] -n -o[Model_0843_SW_Gibind1x_LCa]
../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GsGiCaMCa4ATP] -n -o[Model_0843_SW_Gibind1x_LCa]
../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GasGTPGaiGTP] -n -o[Model_0843_SW_Gibind1x_LCa]
../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GaiGTPCaMCa4ATP] -n -o[Model_0843_SW_Gibind1x_LCa]
../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GasGTPGaiGTPCaMCa4] -n -o[Model_0843_SW_Gibind1x_LCa]
../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[GaiGTP] -n -o[Model_0843_SW_Gibind1x_LCa]

../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[AC1GaiGTPCaMCa4] -n -o[Model_0846_SW_Iso10u_LCa]
../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[AC1GsGiCaMCa4ATP] -n -o[Model_0846_SW_Iso10u_LCa]
../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[AC1GasGTPGaiGTP] -n -o[Model_0846_SW_Iso10u_LCa]
../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[AC1GasGTPGaiGTPCaMCa4] -n -o[Model_0846_SW_Iso10u_LCa]
../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[AC1GaiGTPCaMCa4ATP] -n -o[Model_0846_SW_Iso10u_LCa]
../batch/NRDPostAB -i[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-dt100-conc.txt] -r[Model_0846_0113_0428_0030_Gi_p4LR_LCa_1xGibind_10uISO-mesh.txt] -m[GaiGTP] -n -o[Model_0846_SW_Iso10u_LCa]

../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[AC1GaiGTPCaMCa4] -n -o[Model_0847_SW_Isop1_LCa]
../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[AC1GsGiCaMCa4ATP] -n -o[Model_0847_SW_Isop1_LCa]
../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[AC1GasGTPGaiGTP] -n -o[Model_0847_SW_Isop1_LCa]
../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[AC1GasGTPGaiGTPCaMCa4] -n -o[Model_0847_SW_Isop1_LCa]
../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[AC1GaiGTPCaMCa4ATP] -n -o[Model_0847_SW_Isop1_LCa]
../batch/NRDPostAB -i[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-dt100-conc.txt] -r[Model_0847_0113_0428_0028_Gi_p4LR_LCa_1xGibind_0.1uISO-mesh.txt] -m[GaiGTP] -n -o[Model_0847_SW_Isop1_LCa]

../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[AC1GaiGTPCaMCa4] -n -o[Model_0849_SW_Isop4_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[AC1GsGiCaMCa4ATP] -n -o[Model_0849_SW_Isop4_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[AC1GasGTPGaiGTP] -n -o[Model_0849_SW_Isop4_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[AC1GasGTPGaiGTPCaMCa4] -n -o[Model_0849_SW_Isop04_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[AC1GaiGTPCaMCa4ATP] -n -o[Model_0849_SW_Isop4_LCa]
../batch/NRDPostAB -i[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-dt100-conc.txt] -r[Model_0849_0113_0428_0040_Gi_p4LR_LCa_1xGibind_0.4uISO-mesh.txt] -m[GaiGTP] -n -o[Model_0849_SW_Isop4_LCa]

../batch/NRDPostAB -i[Model_0859_0113_0428_0038_Gi_p4LR_LCa_1xGibind_0.04uISO-dt100-conc.txt] -r[Model_0859_0113_0428_0038_Gi_p4LR_LCa_1xGibind_0.04uISO-mesh.txt] -m[AC1GaiGTPCaMCa4] -n -o[Model_0859_SW_Isop04_LCa]
../batch/NRDPostAB -i[Model_0859_0113_0428_0038_Gi_p4LR_LCa_1xGibind_0.04uISO-dt100-conc.txt] -r[Model_0859_0113_0428_0038_Gi_p4LR_LCa_1xGibind_0.04uISO-mesh.txt] -m[AC1GsGiCaMCa4ATP] -n -o[Model_0859_SW_Isop04_LCa]
../batch/NRDPostAB -i[Model_0859_0113_0428_0038_Gi_p4LR_LCa_1xGibind_0.04uISO-dt100-conc.txt] -r[Model_0859_0113_0428_0038_Gi_p4LR_LCa_1xGibind_0.04uISO-mesh.txt] -m[AC1GasGTPGaiGTP] -n -o[Model_0859_SW_Isop04_LCa]
../batch/NRDPostAB -i[Model_0859_0113_0428_0038_Gi_p4LR_LCa_1xGibind_0.04uISO-dt100-conc.txt] -r[Model_0859_0113_0428_0038_Gi_p4LR_LCa_1xGibind_0.04uISO-mesh.txt] -m[AC1GasGTPGaiGTPCaMCa4] -n -o[Model_0859_SW_Isop04_LCa]
../batch/NRDPostAB -i[Model_0859_0113_0428_0038_Gi_p4LR_LCa_1xGibind_0.04uISO-dt100-conc.txt] -r[Model_0859_0113_0428_0038_Gi_p4LR_LCa_1xGibind_0.04uISO-mesh.txt] -m[AC1GaiGTPCaMCa4ATP] -n -o[Model_0859_SW_Isop04_LCa]

../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GasGTP] -n -o[Model_0843_SW_Gibind1x_LCa]
../batch/NRDPostAB -i[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-dt100-conc.txt] -r[Model_0938_0113_0531_0029_Gi_p4LR_LCa_1xGibind_slowGsdeg-mesh.txt] -m[AC1GasGTPCaMCa4ATP] -n -o[Model_0843_SW_Gibind1x_LCa]

python ../batch/SumMoleculeForms.py