/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *    Plot2DCompanion.java
 *    Copyright (C) 2000 Mark Hall
 *
 */


package weka.gui.visualize;

import java.awt.Graphics;

/**
 * Interface for classes that need to draw to the Plot2D panel *before*
 * Plot2D renders anything (eg. VisualizePanel may need to draw polygons
 * etc.)
 *
 * @author Mark Hall (mhall@cs.waikato.ac.nz)
 * @version $Revision: 1.1.1.1 $
 */
public interface Plot2DCompanion {

  /**
   * Something to be drawn before the plot itself
   * @param gx the graphics context to render to
   */
  void prePlot(Graphics gx);
}
