!    -*- f95 -*-
module qsort_c_module

    implicit none
    public :: QsortC
    private :: Partition

    contains

    recursive subroutine QsortC(A)
        real*8, intent(in out), dimension(:) :: A
        integer :: iq
        if(size(A) > 1) then
            call Partition(A, iq)
            call QsortC(A(:iq-1))
            call QsortC(A(iq:))
        endif
    end subroutine QsortC

    subroutine Partition(A, marker)
        real*8, intent(in out), dimension(:) :: A
        integer, intent(out) :: marker
        integer :: i, j
        real*8 :: temp
        real*8 :: x      ! pivot point
        x = A(1)
        i= 0
        j= size(A) + 1
        do
            j = j-1
            do
                if (A(j) <= x) exit
                j = j-1
            end do
            i = i+1
            do
                if (A(i) >= x) exit
                i = i+1
            end do
            if (i < j) then
                ! exchange A(i) and A(j)
                temp = A(i)
                A(i) = A(j)
                A(j) = temp
            elseif (i == j) then
                marker = i+1
                return
            else
                marker = i
                return
            endif
        end do
    end subroutine Partition

end module qsort_c_module
