import numpy as np
import make_timetables as mp
import subprocess
sim_name = 'MSsim'

ISIs = [-.23,-.13,-.08,-.06,-.07,-0.04,-.2,-.1,-.05,-.03,-.02,-0.01,-0.005,0.005,.01,.02,.03,.05,.1,.2]
text_sim_1 = '''include SimParams.g 
  include MScell/globals.g
include MScell/Ca_constants.g
include MScell/SynParamsCtx.g
include MScell/spineParams.g
include MScell/MScellSynSpines	      // access make_MS_cell 
include InOut/add_output.g            //functions for ascii file output
include InOut/IF.g                    //function to create pulse generator for current injection, also IF & IV curves
include InOut/HookUp.g              

setclock 0 {simdt}         
setclock 1 {simdt}

str DA = "UI"
str Location = "tertdend1_1"
str jitter = "No"
int jitter_int = 0
int seedvalue = 5757538

'''
#here Protocol and Timing

text_sim_2 = """
GABAYesNo = 0
gCaL13soma_UI = 0
gCaL13dend_UI = 0

gCaL12soma_UI = 0
gCaL12dend_UI = 0

gCaL12spine = 0
gCaL13spine = 0
str diskpath="SimData/No_L_"@{Protocol}@"_"@{DA}@"_"@{Timing}@"_"@{Location}@"_randseed_"@{seedvalue}@"_high_res"

int totspine={make_MS_cell_SynSpine {neuronname} {pfile} {spinesYesNo} {DA}}
reset
Vmhead={add_outputVm {comps} {Vmfile} {neuronname}}
if ({CaOut})
    if ( {calciumdye} == 0)
        Cafile = "Ca_plasticity"
    elif  ( {calciumdye} == 1)
        Cafile = "Ca_Fura_2_plasticity"
    elif  ( {calciumdye} == 2)
        Cafile = "Ca_Fluo_5f_plasticity"
    elif  ( {calciumdye} == 3)
        Cafile = "Ca_Fluo_4_plasticity"
    else
        Cafile = "Ca_unnkown_dye_plasticity"
    end
    Cahead={add_outputCal {comps} {CaBufs} {Cafile} {neuronname}}
else
    Cafile="X_plasticity"
    Cahead=""
end
if ({GkOut})
    Gkfile="Gk_plasticity"
    Gkhead={add_outputGk {comps} {chans} {Gkfile} {neuronname}}
else
    Gkfile="X_plasticity"
    Gkhead=""
end

str stimcomp= {Location}
str spinefile="spine_plasticity"


ce /

"""
#here include paradigm
#and change ISI
text_sim_fino = '''inject = 0.57e-9
'''
text_sim_3 = '''

float newTrainFreq = {burstFreq}/{numbursts}
echo {newTrainFreq}
HookUp {prestim} {Protocol} {Timing} {stimcomp} {diskpath} {numAP} {inject} {AP_durtime} {APinterval} {ISI} {pulseFreq} {pulses} {burstFreq} {numbursts} {newTrainFreq} 1 {jitter_int}
reset
step 1.5 -time

fileFLUSH {Vmfile} 
fileFLUSH {Cafile} 
fileFLUSH {Gkfile} 
fileFLUSH {spinefile}
fileFLUSH {somainjfile}
'''
if __name__ == '__main__':
     params = mp.read_file('SimParams.g')
     gabaYesNo = mp.find_value(params,'GABAYesNo','Pre')
     spines = mp.find_string(params,'whichSpines','Pre')
     stim_start = mp.find_value(params,'initSim','Pre')
     too_fast = mp.find_value(params,'TooFast','Pre')
     print gabaYesNo, spines, stim_start, too_fast
     protocols = ['InOut/Fino.g']#,'InOut/P_K.g']
     timings = ['Pre']
     paradigm_names = ['Fino']#,'P_and_K']
     for ISI in ISIs:

        
          for timing in timings:
               for i, protocol in enumerate(protocols):
                    print protocol
                    text = mp.read_file(protocol)
                    #find pulseFreq
                    freq = mp.find_value(text, 'pulseFreq',timing)
                    npulses = mp.find_value(text, 'pulses',timing)     
                    nbursts = mp.find_value(text, 'numbursts',timing)
                    burstfreq = mp.find_value(text, 'burstFreq',timing)
                    ntrains = mp.find_value(text, 'numtrains',timing)
                    trainfreq = mp.find_value(text, 'trainFreq',timing)
                    print freq, npulses, nbursts, burstfreq, ntrains, trainfreq
                    if npulses == None:
                         npulses = 1
                    
   
                    fname_base = paradigm_names[i]+'_'+timing+'_stimulation_'
                    spine_list = ['spine_1']
    

                    mp.distribute(freq,npulses,burstfreq,nbursts,trainfreq,ntrains,stim_start,fname_base,spine_list)
                
        



                    sim_file = 'No_L_'+sim_name+'_'+paradigm_names[i]+'_ISI_'+str(ISI)+'.g'
                    print sim_file
                    fil = open(sim_file,'w')
                    fil.write(text_sim_1)
                    fil.write('str Protocol = "'+paradigm_names[i]+'"\n')
                    fil.write('str Timing = "'+timing+'"\n')
                    fil.write(text_sim_2)
                    fil.write("include "+protocol+'\n')
                    fil.write("ISI = "+str(ISI)+'\n')
                    if paradigm_names[i] == 'Fino':
                         fil.write(text_sim_fino)
                    fil.write(text_sim_3)
                    fil.close()
                    
                    process = subprocess.Popen(['/home/asia/genesis-2.4/chemesis','-nox','-notty','-batch',sim_file])
                    ret = process.wait()

            

            

    
