/* rate_const.c */
/* This function computes the voltage dependent rate constants 
  from the parameters.  For non-voltage dependent rate constants, make
  the rate constant = min, and make max = 0.   Slope may not be 0.  Can be used
  to compute hh sigmoid and exponential rate constants, but no linoid types.
*/

/* modified Jun 3, 1998 to include fast approx to exp by Nicol Schraudolf */

#include "chan_ext.h"


vdep_rate_const (rate_const, vm, min, max, v0, slope, in_exp,
		out_exp, in_offset, out_offset)

float *rate_const;
register double vm;
float min;
float max;
float v0;
float slope;
float in_exp;
float out_exp;
float in_offset;
float out_offset;

{

float expon;

if (debug > 1) 
printf (" vdep_rate_const: min=%f max=%f in_exp=%f out_exp=%f in_offset=%f out_offset=%f v0=%f slope=%f \n",
	min, max, in_exp, out_exp, in_offset, out_offset, v0, slope);

  if (slope == 0)
    printf (" vdep_rate_const: slope = 0\n");
  else

    if (in_exp == 0)
      printf (" vdep_rate_const: in_exp = 0\n");
    else if (in_exp == 1)
      expon = (vm-v0)/slope;
    else
      expon = pow(((vm-v0)/slope), in_exp);

    *rate_const = min + max * pow((out_offset + exp(expon + in_offset)), out_exp);

if (debug > 1)
printf ("rate_const = %f\n", *rate_const);
				  		      
}

cadep_rate_const (channel, ligand, type, min, max, v0, slope, minb, mina, maxb, maxa, v0b, v0a, slopeb, slopea)

struct vdep_cadep_chan_type *channel;
double ligand;
int type; 
float *min, *max, *v0, *slope;
float mina, minb;
float maxa, maxb;
float v0a, v0b;
float slopea, slopeb;

{
  switch (type) {
   case 1:  /* linear */
     *min = mina + minb*ligand;
     *max = maxa + maxb*ligand;
     *v0 = v0a  + v0b*ligand;
     *slope = slopea + slopeb*ligand;
     break;
   case 2:  /* log */
     *min = mina + minb*log10(ligand);
     *max = maxa + maxb*log10(ligand);
     *v0 = v0a  + v0b*log10(ligand);
     *slope = slopea + slopeb*log10(ligand);
     break;
   case 3: /* sigmoid */
     *min = minb*ligand / (mina + ligand);
     *max = maxb*ligand / (maxa + ligand);
     *v0 = v0b*ligand / (v0a + ligand);
     *slope = slopeb*ligand / (slopea + ligand);
      break;
  }
	if (debug > 1)
	  printf (" rate_const: type, min, max, slp, v0 = %d %f %f %f %f \n",
		  type, *min, *max, *slope, *v0);
}

lig_rate_const (channel, inf, tau, forward, backward, concen, rxn_ord, bindsite)

struct ligand1_chan_type *channel;
float *inf;
float *tau;
float forward;
float backward;
float concen;
float rxn_ord;
int bindsite; /* 0 for binding to forward rate constant, 1 for binding to backward rate constant */

{
float time_const;
float effective_ligand;

	if (backward == 0)
	   ErrorMessage("lig_rate_const","backward rate const is 0",
			      channel);
	else
	   {
	        if (rxn_ord < 0)
		  ErrorMessage("lig_rate_const", "rxn_ord < 0", channel);
		else if (rxn_ord == 0)
		  effective_ligand = 1;
		else if (rxn_ord == 1)
		  effective_ligand = concen;
		else  /* (rxn_ord > 1) */
		  effective_ligand = pow(concen, rxn_ord);	
  
		if (bindsite == 0)
		  {
		    time_const = backward + forward * effective_ligand;
		    *inf = 1 - (backward / time_const); 
             /* equivalent to inf = (forward*effective_ligand)/time_const */
	  }
		else /* bindsite == 1 */
		  {
		    time_const = backward * effective_ligand + forward;
		    *inf = forward / time_const;
		  }
		*tau = time_const;			  		      
				  		      
	   }
}

