/* chan_struct.h */

#include "../genesis/src/newconn/newconn_defs.h"
#define CALCIUM            5
#include "struct_defs.h"

struct vdep_rate_const_type
{

/* formula for voltage dependent rate constant:
 *	rate_const(v) = min + max * 
 *	{out_exp_offset + exp[((v - v0)/slope)^in_exp_power + in_exp_offset]}
 *       ^out_exp_power
 *	
 *	for hh channels (Sigmoid type), 
 *		out_exp_power = -1, 
 *		in_exp_power = 1, 
 *		out_exp_offset = 1, 
 *		in_exp_offset = 0
 *      for voltage-independent channels make
 *               max = 0, 
 *               min = desired rate constant
 *               slope != 0
*/	
	float min;
	float max;
	float v0;
	float slope;
	float in_exp_power;
	float out_exp_power;
	float in_exp_offset;
	float out_exp_offset;
	float rate_const;
};

struct vdep_ligdep_rate_const_type
{

/* formula for voltage-dependent ligand-dependent rate constant:
 *	rate_const(v) = min + max * 
 *	{offset + exp[(v - v0)/slope]}^power
 *      where min = min_slp*f(Ca) + min_int
 *            max = max_slp*f(Ca) + max_int
 *            v0 = v0_slp*f(Ca) + v0_int
 *            slope = slope_slp*f(Ca) + slope_int
 *	
 *	for hh channels (Sigmoid type), 
 *		power = -1, 
 *		offset = 1
 *      for voltage-independent channels make
 *               max = 0, 
 *               min = desired rate constant
 *               slope != 0
 *      for linear functions of Ca make max = 0 (slope != 0)
*/	
        float min;
	float min_slp;
        float min_int;
        float max;
	float max_slp;
        float max_int;
        float v0;
	float v0_slp;
        float v0_int;
        float slope;
	float slope_slp;
        float slope_int;
	float power;
	float offset;
	float rate_const;
};

struct vdep_ligdep_chan_type
{
  SEGMENT_TYPE
  struct vdep_ligdep_rate_const_type act_ssv;     /* steady state activation */
  struct vdep_ligdep_rate_const_type act_tauv;	/* activation time constant */
  struct vdep_ligdep_rate_const_type inact_tauv;	/* inactivation time const. */
  struct vdep_ligdep_rate_const_type inact_ssv;	/* steady state inactivation */
  struct vdep_rate_const_type act_ssca;     /* steady state activation */
  struct vdep_rate_const_type act_tauca;	/* activation time constant */
  struct vdep_rate_const_type inact_tauca;	/* inactivation time const. */
  struct vdep_rate_const_type inact_ssca;	/* steady state inactivation */
  double act;    /* activation at time t */
  double inact;  /* inactivation at time t */
  float  act_power;
  float  inact_power;
  float  ligand; /* concentration of second messenger seen by channel */
  float Vr;      /* reversal potential of channel */
  float Vm;      /* voltage sensed by channel */
  float I;       /* channel  current */
  float G;       /* channel  conductance */
  float Gbar;    /* max channel conductance */
  int   inact_ss_type;
  int   inact_tau_type;
  int   act_tau_type;
  int   act_ss_type;    /* type of interaction of ligand and Voltage
		    0 = separable (vdep coef * ligdep coef
		    1 = nonseparable (vdep coef = f(ligand), linear
		    2 = nonseparable, log
		    3 = nonseparable, sigmoid */
};

struct ligand1_chan_type
{
	SEGMENT_TYPE
	struct vdep_rate_const_type alpha; 	/* forward rate constant */
	struct vdep_rate_const_type beta;	/* backward constant */
	struct vdep_rate_const_type gamma; 	/* forward rate constant for lig-dep inact */
	struct vdep_rate_const_type delta;	/* backward constant for lig-dep inact*/
        struct vdep_rate_const_type inact_tau;	/* v dep inactivation time constant */
        struct vdep_rate_const_type inact_ss;	/* v dep steady state inactivation */
	float act_inf;		/* steady state activation */
	float act_tau;		/* activation time constant */
        float inact_inf;        /* steady state inact due to lig dep */
        float inact_rate;      /* inact rate const due to lig dep */
        float  act_power;
        float  inact_power;
        int  inact_type;        /* 0 for v dep, 1 for lig dep */
        double inact;           /* inactivation at time t */
        double act;	        /* activation at time t */
	float Vr;		/* reversal potential of channel */
	float Vm;		/* voltage sensed by channel */
	float ligand;		/* transmitter concentration seen by receptor */
        float modulator[4];        /* modulator of rate const. */
	float rxn_ord;		/* number of ligand molecules that bind receptor */
	float inact_rxn_ord;	/* number of ligand molecules that bind inactivation receptor */
	float I;		/* channel current */
	float G;		/* channel conductance */
	float Gbar;		/* max channel conductance */
};

struct ligand2_chan_type
{
	SEGMENT_TYPE
	float a11;		/* r1 c1 matrix value */
	float a12;		/* r1 c2 matrix malue */
	float a21;		/* r2 c1 matrix value */
	float a22;		/* r2 c2 matrix value */
	float b1;		/* r1 forcing fucntion */
	float b2;		/* r2 forcing fucntion */
	double TR1;		/* state 1 fraction */
	double TR2;		/* state 2 fraction */
	struct vdep_rate_const_type k2f; 	/* 2nd stage forward rate const */
	struct vdep_rate_const_type k2b;	/* 2nd stagebackward rate const */
	struct vdep_rate_const_type gamma; 	/* 3nd stage forward rate const */
	struct vdep_rate_const_type delta;	/* 3nd stagebackward rate const */
	struct vdep_rate_const_type k1f;	/* 1st stage forward rate const */
	struct vdep_rate_const_type k1b;	/* 1st stage backward rate const */
	float Vr;		/* reversal potential of channel */
	float Vm;		/* voltage sensed by channel */
	float ligand;		/* ligand concentration seen by channel */
	float rxn_ord1;		/* number of ligand molecules that bind first stage of receptor */
	float rxn_ord2;		/* number of ligand molecules that bind second stage of receptor */

	float I;		/* channel current */
	float G;		/* channel conductance */
	float Gbar;		/* max conductance of conducting state */
	int cond_state;		/* which state is the conducting state */
};

#define SYNCHAN_TYPE                         \
    CHAN_TYPE                                \
    CHANNELC2_TYPE                           \
    float       frequency;                   \
    short	nsynapses;                   \
    short   normalize_weights;               \
    double  time_last_event;                 \
    Element *hsolve;                         \
    int     solve_index;                     \
    unsigned short synapse_size;             \
    int         event_buffer_size;           \
    int         pending_events;              \
    SynapticEventPtr FreeSynapticEvents;     \
    SynapticEventPtr PendingSynapticEvents;  \
    float       nodes_per_synapse;           \
    short       list_alloced;                \
    short       allocednodes;       

struct caplasSynapse_type 
{
  MsgIn*	mi;
  float	weight;
  float	delay;  
  double         X;
  double         Y;
  float          pre_activity;
  unsigned short spike_flags;
};
 
typedef struct caplasSynapse_type caplasSynapse;

struct caplasSynchan_type 
{
  SYNCHAN_TYPE
  struct caplasSynapse_type *synapse;
  /* The following fields are specific to the Hebbian synchans: */
  /* 1) presynaptic fields: */
  float       pre_tau1;  
  float       pre_tau2;  
  float       pre_thresh_lo; 
  float       pre_thresh_hi; 
  double      pre_xconst;
  double      pre_yconst1;
  double      pre_yconst2;
  float       pre_norm;
  /* 2) postsynaptic fields: */
  float       avg_Vm; 
  float       post_tau; 
  double      post_const;
  float       post_thresh_lo; 
  float       post_thresh_hi;
  float       dur_lo; 
  float       dur_hi;
  float       how_long_lo; 
  float       how_long_hi;
  
  float       post_scale;          /* scaling factor for postsynaptic activities */
  /* 3) other fields: */
  float       weight_change_rate_dep; 
  float       weight_change_rate_pot; 

  float       min_weight;
  float       max_weight;
  short       change_weights;      /* flag: nonzero means weights can be changed */
  double      avg_Ca;
};
