// genesis
// chanlib.g
/************************************************************************
**                      SHELL COMMANDS                    	     **
************************************************************************
*/

/*
*************************************************************************
**                              OBJECT TABLE                           **
*************************************************************************
*/

//==========================================================================
//	name		data            function	class	
//==========================================================================
// under list of messages, the value 0, 1, etc., immediately following the all 
// caps NAME of the message must correspond with the case number in MSGLOOP 
// of the code.  The short name, e.g. Vm, at the end of the message line
// must correspond to ?. The caps NAME of the message must correspond to
// the caps NAME in the sendmsg statement. (the variable name following the 
// caps NAME in the sendmsg statement must be a defined field
// in the object structure.)
//
//     object name	type (*.h)		function (*.c)      class

object ligand1_chan 	ligand1_chan_type 	ligand1_chan segment channel\
	-author		"Avrama Blackwell ERIM 05/95 "\
	-actions	INIT RESET PROCESS CHECK SAVE2 RESTORE2 \
	-messages       VOLTAGE 0 1 Vm \
                        LIGAND 1 1 ligand \
			MODULATE 2 2 modulation which \
	-fields		"alpha: structure - rate const of binding " \
			"beta: structure - rate const of unbinding " \
			"gamma: structure - rate const of binding for inact" \
			"delta: structure - rate const of unbinding for inact" \
			"inact_ss: structure - for v dep inactivation gate " \
			"inact_tau: structure - for v dep inactivation gate " \
			"inact_type: 0 for v dep inf and tau, 1 for v dep, lig dep gamma and delta" \
			"ligand: transmitter (or other 2nd messenger) concentration in mM " \
			"act_power: exponent indicated # independent gates " \ 
			"inact_power: exponent indicating # independent gates " \
			"rxn_ord:  number of molecules binding to receptor " \
			"inact_rxn_ord:  number of molecules binding to inactivation molecule " \
			"Vr: reversal potential of channel" \
			"Gbar: Maximum channel conductance" \
			"Vm: voltage sensed by channel" \
			"I:  channel current " \
			"G:  Channel conductance" \
			"act_inf: ss activation computed from alpha and beta" \
			"act_tau: time const of act computed from alpha and beta" \
			"inact_inf:  ss inact computed from gamma and delta" \
			"inact_rate: ss rate of inact from gamma and delta" \
			"act: computed activation" \
			"inact: computed inactivation" \
			"modulator[4]: array of rate const modulation."\
	-description	" This function computes channel conductance of a one state kinetic " \
			" channel which is ligand-gated (and possibly voltage-dependent) according to: " \
			"   [R] + n[G] <-> [R-G^n] " \
			"   where n is the number of molecules of ligand G that binds to the " \
			"   receptor.  alpha and beta are forward and backward rate constant. " \
			"  inact_ss and inact_tau are rate constants for optional inact gate. "\
			" gamma and delta are forward and backward rate constants for " \
			" optional ligand dependent inact gate. (ligand multiplies delta" \
			"all rate constant structures have the following fields: rate_const(v or mod) = " \
			"min + max * {out_exp_offset + exp[((v - v0)/slope)^in_exp_power + in_exp_offset]} " \
			" ^out_exp_power " \
 			" *	for hh channels (Sigmoid type), " \
			" *		out_exp_power = -1,  " \
			" *		in_exp_power = 1, " \
			" *		out_exp_offset = 1, " \
			" *		in_exp_offset = 0 " \
			" *      for voltage-independent channels make " \
			" *               max = 0, " \
			" *               min = desired rate constant " \
			" *               slope != 0 "  \
			" Units are milliVolts, nanoAmps, microSiemens, milliSeconds, milli (or micro) moles"


object ligand2_chan 	ligand2_chan_type 	ligand2_chan segment channel\
        -author         "Avrama Blackwell ERIM 04/95 "\
        -actions        INIT RESET PROCESS CHECK \
        -messages       VOLTAGE 0 1 Vm \
                        LIGAND 1 1 ligand \
	-fields		"k1f structure - rate const of binding " \
			"k1b structure - rate const of unbinding " \
			"k2f structure - vdep transformation of 2nd reaction " \
			"k2b structure - vdep transformation of 2nd reaction" \
			"gamma structure - vdep transformation of 3d reaction " \
			"delta structure - vdep transformation of 3d reaction" \
			"ligand = transmitter (or other 2nd messenger) concentration in mM " \
			"rxn_ord1 = number of molecules binding to receptor, 1st stage " \
			"rxn_ord2 = number of molecules binding to receptor, 2nd stage " \
			"Vr: reversal potential of channel" \
			"Gbar: Maximum channel conductance" \
			"Vm: voltage sensed by channel" \
			"I:  channel current"  \
			"G:  Channel conductance" \
	-description	" This function computes channel conductance of a two state kinetic channel " \
			" which is voltage and ligand dependent.  It computes the fraction of " \
			" receptors in each state; the channel conductance and current is computed " \
			" from the fraction of receptors in the conducting state. " \
			" Equations implemented in this function: " \
			"            k1f*T      k2f*T " \
			"   Receptor <-> T-R1 <-> T-R2 " \
			"            k1b      k2b " \
			"            gamma" \
			" Also, T-R2 <-> T + R " \
			"            delta *T*T" \
			"all rate constant structures have the following fields: rate_const(v) = " \
			"min + max * {out_exp_offset + exp[((v - v0)/slope)^in_exp_power + in_exp_offset]} " \
			" ^out_exp_power " \
 			" *	for hh channels (Sigmoid type), " \
			" *		out_exp_power = -1,  " \
			" *		in_exp_power = 1, " \
			" *		out_exp_offset = 1, " \
			" *		in_exp_offset = 0 " \
			" *      for voltage-independent channels make " \
			" *               max = 0, " \
			" *               min = desired rate constant " \
			" *               slope != 0 "  \
			" Units are milliVolts, nanoAmps, microSiemens, milliSeconds, millimoles"

                          
object vdep_ligdep_chan 	vdep_ligdep_chan_type 	vdep_ligdep_chan segment channel\
	-author		"Avrama Blackwell ERIM 05/95 "\
	-actions	INIT RESET PROCESS CHECK SAVE2 RESTORE2 \
	-messages       VOLTAGE 0 1 Vm \
			LIGAND 1 1 ligand \
	-fields		"act_ssv: structure - for v dep activation gate " \
			"act_tauv: structure - for v dep activation gate " \
			"inact_ssv: structure - for v dep inactivation gate " \
			"inact_tauv: structure - for v dep inactivation gate " \
			"act_ssca: structure - for ligand dep activation gate " \
			"act_tauca: structure - for ligand dep activation gate " \
			"inact_ssca: structure - for ligand dep inactivation gate " \
			"inact_tauca: structure - for ligand dep inactivation gate " \
			"act_power: exponent indicated # independent gates " \ 
			"inact_power: exponent indicating # independent gates " \
			"type: type of interaction of ligand and Voltage" \
			"Vr: reversal potential of channel" \
			"Gbar: Maximum channel conductance" \
			"Vm: voltage sensed by channel" \
			"I:  channel current " \
			"G:  Channel conductance" \
	-description	" This function computes voltage-dependent and ligand-dependent (e.g. Calcium " \
			"dependent) channel currents given the parameters specified as inf (steady state value) and tau (time const)." \
			" Type of rate constants depends on the interaction of ligand and voltage: " \
		    	" 0 = separable (vdep coef * ligdep coef) " \
		    	" 1 = nonseparable linear: (vdep coef = int + slp * ligand " \
		    	" 2 = nonseparable log: (vdep coef = int + slp * log(ligand) " \
		    	" 3 = nonseparable sigmoid: (vdep coef =  slp * ligand / (int + ligand)" \
			"all rate constant structures have the following fields: rate_const(v) = " \
			"min + max * offset + exp[(v - v0)/slope]}^power,   where: " \
			"  min = min_slp * f(Ca) + min_int " \
			"  max = max_slp * f(Ca) + max_int " \
			"  v0 = v0_slp * f(Ca) + v0_int " \
			"  slope = slope_slp * f(Ca) + slope_int " \
 			" *   for hh channels (Sigmoid type), " \
			" *		power = -1,  " \
			" *		offset = 1, " \
			" *   for separable,  " \
			"	use v dep and ligand dep gates;	make slp = 0 and int = desired value " \
			" *   for non-separable, use v dep gate only; specify slp and int"  \
			" Units are milliVolts, nanoAmps, microSiemens, milliSeconds, millimoles"


object  caplas_synchan     caplasSynchan_type caplas_synchan segment channel synchannel                    \
        -author         "Avrama Blackwell 2013 GMU"                                                 \
        -actions        CREATE INIT PROCESS RESET RECALC CHECK SAVE2 RESTORE2 EVENT                \
                        ADDMSGIN DELETEMSGIN MSGINDELETED RESETBUFFER DELETE COPY SET SHOW         \
        -messages       VOLTAGE         0       1 Vm                                               \
                        ACTIVATION      1       1 activation                                       \
                        RAND_ACTIVATION 2       2 probability amplitude                            \
                        MOD             3       1 modulation                                       \
                        WEIGHT_CHANGE_MOD  4    1 modulation                                       \
                        SPIKE          -1       0                                                  \
                        CALCIUM         5       1 Ca                                               \
	-readonly       activation            "driving force for channel conductance"                    \
	-readonly       Ik                    "channel current"                                          \
	-readonly       Gk                    "conductance of channel"                                   \
	-readwrite      Ek                    "reversal potential of channel"                            \
        -hidden         X                     "internal variable for synaptic conductances"              \
        -hidden         Y                     "internal variable for synaptic conductances"              \
        -hidden         xconst1               "internal constant for synaptic conductances"              \
        -hidden         xconst2               "internal constant for synaptic conductances"              \
        -hidden         yconst1               "internal constant for synaptic conductances"              \
        -hidden         yconst2               "internal constant for synaptic conductances"              \
        -hidden         norm                  "normalization factor for psp amplitude"                   \
        -readwrite      tau1                  "first time constant of channel activation"                \
        -readwrite      tau2                  "second time constant of channel activation"               \
        -readwrite      gmax                  "peak conductance"                                         \
        -readwrite      frequency             "random activation frequency" 0.0                          \
        -readonly       nsynapses             "Number of incoming spike messages"                        \
	-hidden		synapse_size          "size of synapse in bytes"                                 \
        -readonly       event_buffer_size     "size of event buffer" 0                                   \
        -readonly       pending_events        "number of pending spike events in event buffer" 0         \
        -hidden         FreeSynapticEvents    "free list of synaptic event nodes"                        \
        -hidden         PendingSynapticEvents "list of pending synaptic events"                          \
        -readwrite      nodes_per_synapse     "number of event nodes to allocate per synapse" 1.0        \
        -hidden         list_alloced          "flag for whether the freelist has been allocated"   0     \
        -hidden         allocednodes          "number of nodes that are the head of a malloced block" 0  \ 
        -readwrite      synapse               "synapse buffer"                                           \
	-readwrite      pre_tau1              "first time constant for presynaptic averaging"   0.010    \
	-readwrite      pre_tau2              "second time constant for presynaptic averaging"  0.100    \
	-readwrite      pre_thresh_lo         "lower presynaptic threshold" 3.0                          \ 
        -readwrite      pre_thresh_hi         "upper presynaptic threshold" 3.0                          \ 
        -hidden         pre_xconst            "internal constant for presynaptic averaging"              \
	-hidden         pre_yconst1           "internal constant for presynaptic averaging"              \
	-hidden         pre_yconst2           "internal constant for presynaptic averaging"              \
	-hidden         pre_norm              "normalization factor for presynaptic averaging"           \
	-readonly       avg_Ca                "averaged calcium" 0                             \
	-readwrite      post_tau              "time constant of postsynaptic averaging"                  \
	-hidden         post_const            "internal constant for postsynaptic averaging"             \
	-readwrite      post_thresh_lo        "lower postsynaptic threshold" .12e-3                      \
	-readwrite      post_thresh_hi        "upper postsynaptic threshold" .6e-3                      \
    -readwrite      dur_lo        "depression duration postsynaptic threshold" 13e-3 \                     
	-readwrite      dur_hi        "potentiation duration postsynaptic threshold" 1e-3 \
    -hidden         how_long_lo        "how long betweend depression and potentiation thresholds"  \                     
	-hidden         how_long_hi          "how long over potentiation threshold"  \
	-readwrite      post_scale            "scaling factor for postsynaptic activities" 0.001         \
	-readwrite      weight_change_rate_dep    "rate of weight change of depression" 1.0                                \
    -readwrite      weight_change_rate_pot    "rate of weight change of potentiation" 1.0                                \
	-readwrite      min_weight            "minimum weight" 0.0                                       \
	-readwrite      max_weight            "maximum weight" 100.0                                     \
	-readwrite      change_weights        "flag: nonzero means weights can be changed" 1             \
	-description    "Like Hebbsynchan, but weights are dynamically modified"  \
                        "according to a function of the postsynaptic" \
                        "calcium."  

 

