/* ligand2_chan.c */

/* Avrama Blackwell, GMU, October 1997
   modified from two-state-recept0.c 

   ** modified on 1-13-99 to allow for T-R2 to directly transform into 
   unbound receptor.  Thus, added rate  constants gamma and delta **

** old T-R2' equation:

   T-R2' = alpha T-R1 + -beta T-R2

** old a21, a22, b2:

a21 = alpha
a22 = - beta
b2 = 0

*/

/* This function computes channel conductance of a two state kinetic
   channel which is voltage and ligand dependent.  It computes the 
   fraction of receptors in each state; the channel conductance and current
   is computed from the fraction of receptors in the conducting state.

   This function was designed initially to compute GABA induced chloride currents 
    in the Hermissenda B cell, as measured in Alkon et al., 1992 PNAS.
   Assumptions: Channel protein for activation is ligand-gated
    	        No magnesium block or other co-factors.
                No inactivation gate or desensitization.
*/   
/* Equations implemented in this function:

                                  k1      alpha
   Transmitter/Ligand + Receptor <-> T-R1 <-> T-R2
                                  k2      beta
			^                       ^
                        |                       |
			|          gamma        |
			 _______________________
			           delta
                          
 This biochemical reaction equation leads to the following differential eqn:
 
   T-R1' =  (-alpha - k2 - k1 T) T-R1  + (beta - k1 T) T-R2 + k1 T

   T-R2' = (alpha - delta T) T-R1 + (-beta - gamma - delta T) T-R2 + delta T
      
 Put this in the form of a matrix solution:
 
TR' = A TR + B     with 

a11 = -alpha - k2 - k1 T
a12 = beta - k1 T
a21 = alpha - delta T
a22 = -beta - gamma - delta T
b1 = k1 T
b2 = delta T
*/

/* modified on 08-20-02 to allow to stages of binding.  
   Also allows for the first (unbound) state to be the conducting state 

Remove call to direct integrate since it doesn't work (with genesis2)

replace alpha with k2f, beta with k2b, k1 with k1f, k2 with k1b

#       k1f * T        k2f * T
# kc  <------->  TR1 <------->  TTR2
#         k1b            k2b
   ^                           ^
   |                           |
   |          gamma            |
    ___________________________
	      delta
                          
 
T-R1'= k1f *T *(1-TR1-TTR2) - (k2f*T+k1b)*TR1 + k2b*TTR2

rewrite this as

T-R1' = (-k1f * T -k1b -k2f*T) TR1 + (k2b - k1f*t) TTR2 + k1f*T

This differs from original in that k2f (alpha) is multiplied by T

TT-R2'=k2f*T*TR1 - k2b*TTR2

Now, add in the gamma-delta inactivation step, which only affectst TTR2

TT-R2' = k2f*T*TR1 - k2b * TTR2  -gamma*TTR2 + delta*T*T (1-TR1-TTR2)

rewrite this as

TT-R2' = (k2f*T -delta*T*T)*TR1 + (-k2b -gamma -delta*T*T) *TR2 + delta*T*T

a11 = -k2f*T -k1b -k1f*T
a12 = k2b - k1f*T
a21 = k2f*T - delta*T*T
a22 = -k2b - gamma - delta*T*T
b1 = k1f*T
b2 = delta*T*T

open=1-TR1-TTR2
*/

#include "chan_ext.h"

#define	Field(F) (channel->F)

ligand2_chan (channel,action)

register struct ligand2_chan_type *channel;
Action		*action;
{
double 	v;			/* Voltage from compartment */
double  ligand;			/* ligand concentration */
double  lig1;                /* ligand**rxn_ord1 */
double  lig2;                /* ligand**rxn_ord2 */
int 	int_method = -1;	/* Forward Euler */
double 	state1, state2;		/* temp storage of TR1 and TR2 */
double 	TR1pr, TR2pr;		/* derivatives of TR1 and TR2 */
double 	dt;			/* time step */
MsgIn	*msg;
int     n;                      /* for counting messages */

  if (debug > 1) {
     ActionHeader("ligand2_chan", channel,action);
  }

    SELECT_ACTION(action)
    {
    case INIT:
	channel->activation = 0;
	break;
    
    case PROCESS:
    
 /* Get the current voltage and transmitter concentration */	
	v = 0;
	ligand = 0;
	
	MSGLOOP(channel,msg)
	{
	case 0:		
		v = MSGVALUE(msg,0);
		Field(Vm) = v; 
		break;
	
	case 1:
		ligand = MSGVALUE(msg,0);
		Field(ligand) = ligand;
		break;
	}

    	dt = Clockrate(channel);

/* calculate voltage dependent parts of k2f and k2b from v	
   For voltage independence, make min - desired value and max = 0*/

	vdep_rate_const (&channel->k2f.rate_const, v, 
		channel->k2f.min,
		channel->k2f.max,
		channel->k2f.v0,
		channel->k2f.slope,
		channel->k2f.in_exp_power,
		channel->k2f.out_exp_power,
		channel->k2f.in_exp_offset,
		channel->k2f.out_exp_offset);
		
	vdep_rate_const (&channel->k2b.rate_const, v, 
		channel->k2b.min,
		channel->k2b.max,
		channel->k2b.v0,
		channel->k2b.slope,
		channel->k2b.in_exp_power,
		channel->k2b.out_exp_power,
		channel->k2b.in_exp_offset,
		channel->k2b.out_exp_offset);

	vdep_rate_const (&channel->k1f.rate_const, v, 
		channel->k1f.min,
		channel->k1f.max,
		channel->k1f.v0,
		channel->k1f.slope,
		channel->k1f.in_exp_power,
		channel->k1f.out_exp_power,
		channel->k1f.in_exp_offset,
		channel->k1f.out_exp_offset);

	vdep_rate_const (&channel->k1b.rate_const, v, 
		channel->k1b.min,
		channel->k1b.max,
		channel->k1b.v0,
		channel->k1b.slope,
		channel->k1b.in_exp_power,
		channel->k1b.out_exp_power,
		channel->k1b.in_exp_offset,
		channel->k1b.out_exp_offset);
		
	vdep_rate_const (&channel->gamma.rate_const, v, 
		channel->gamma.min,
		channel->gamma.max,
		channel->gamma.v0,
		channel->gamma.slope,
		channel->gamma.in_exp_power,
		channel->gamma.out_exp_power,
		channel->gamma.in_exp_offset,
		channel->gamma.out_exp_offset);
		
	vdep_rate_const (&channel->delta.rate_const, v, 
		channel->delta.min,
		channel->delta.max,
		channel->delta.v0,
		channel->delta.slope,
		channel->delta.in_exp_power,
		channel->delta.out_exp_power,
		channel->delta.in_exp_offset,
		channel->delta.out_exp_offset);

/* Calculate the matrix values */

    if (channel->rxn_ord1 == 0) {
            lig1=1.0;
            }
        else if (channel->rxn_ord1 > 1) 
          {
	   lig1 = pow(ligand,channel->rxn_ord1);
          } 
        else 
          {
           lig1 = ligand;
          }

       if (channel->rxn_ord2 == 0) {
            lig2=1.0;
            }
       else if (channel->rxn_ord2 > 1) 
          {
	   lig2 = pow(ligand,channel->rxn_ord2);
          } 
        else 
          {
           lig2 = ligand;
          }


	channel->a11 = -channel->k2f.rate_const*lig2 - 
		channel->k1b.rate_const - channel->k1f.rate_const * lig1;
	channel->a12 = channel->k2b.rate_const - channel->k1f.rate_const * lig1;
	channel->b1 = channel->k1f.rate_const * lig1;

	channel->a21 = channel->k2f.rate_const*lig2 - 
	  channel->delta.rate_const * lig1*lig2;
	channel->a22 = -channel->k2b.rate_const - channel->gamma.rate_const -
	  channel->delta.rate_const * lig1*lig2;
	channel->b2 = channel->delta.rate_const * lig1*lig2;

/* Calculate the fraction of state TR1 and TR2 */
/* first, calculate the derivative */

	TR1pr = channel->a11 * channel->TR1 + 
	   channel->a12 * channel->TR2 + channel->b1;
	TR2pr = channel->a21 * channel->TR1 + 
	  channel->a22 * channel->TR2 + channel->b2;

	if (debug > 0)
	printf ("2 state: TR1=%f TR2=%f TR1'=%f TR2'=%f\n", 
		channel->TR1, channel->TR2, TR1pr, TR2pr);
	
/* next, pass the derivative, dt, and the previous state to the
 integration method. */

	state1 = channel->TR1;
	state2 = channel->TR2;
	
/* Evaluate derivative numerically using several methods */	
/* this is not working for some reason
    channel->TR1 = IntegrateMethod (channel->object->method, channel, state1, TR1pr, 0, dt, "TR1");
    channel->TR2 = IntegrateMethod (channel->object->method, channel, state2, TR2pr, 0, dt, "TR2");

	if (debug > 0)
	printf ("After Integration: TR1=%f TR2=%f \n", 
		channel->TR1, channel->TR2);

Hard code the forward euler integration */
	
	channel->TR1 += TR1pr*dt;
	channel->TR2 += TR2pr*dt;

	if (debug > 0)
	printf ("After Euler: TR1=%f TR2=%f \n", 
		channel->TR1, channel->TR2);

/* Calculate the conductance and current */

	if (channel->cond_state == 1)
		channel->G = channel->TR1* channel->Gbar;
	else if (channel->cond_state == 2)
		channel->G = channel->TR2* channel->Gbar;
	else if (channel->cond_state == 0)
	    channel->G = (1-channel->TR1 - channel->TR2) * channel->Gbar;

	channel->I = (v - channel->Vr) * channel->G;
	break;
    
    case RESET:

 /* Get the current voltage and transmitter concentration */	
	v = 0;
	ligand = 0;
	
	MSGLOOP(channel,msg)
	{
	case 0:		
		v = MSGVALUE(msg,0);
		Field(Vm) = v; 
		break;
	
	case 1:
		ligand = MSGVALUE(msg,0);
		Field(ligand) = ligand;
		break;
	}

/* calculate the forward and backward rate constants from ligand and v 	*/

	vdep_rate_const (&channel->k2f.rate_const, v, 
		channel->k2f.min,
		channel->k2f.max,
		channel->k2f.v0,
		channel->k2f.slope,
		channel->k2f.in_exp_power,
		channel->k2f.out_exp_power,
		channel->k2f.in_exp_offset,
		channel->k2f.out_exp_offset);
		

	vdep_rate_const (&channel->k2b.rate_const, v, 
		channel->k2b.min,
		channel->k2b.max,
		channel->k2b.v0,
		channel->k2b.slope,
		channel->k2b.in_exp_power,
		channel->k2b.out_exp_power,
		channel->k2b.in_exp_offset,
		channel->k2b.out_exp_offset);

	vdep_rate_const (&channel->k1f.rate_const, v, 
		channel->k1f.min,
		channel->k1f.max,
		channel->k1f.v0,
		channel->k1f.slope,
		channel->k1f.in_exp_power,
		channel->k1f.out_exp_power,
		channel->k1f.in_exp_offset,
		channel->k1f.out_exp_offset);

	vdep_rate_const (&channel->k1b.rate_const, v, 
		channel->k1b.min,
		channel->k1b.max,
		channel->k1b.v0,
		channel->k1b.slope,
		channel->k1b.in_exp_power,
		channel->k1b.out_exp_power,
		channel->k1b.in_exp_offset,
		channel->k1b.out_exp_offset);


	vdep_rate_const (&channel->gamma.rate_const, v, 
		channel->gamma.min,
		channel->gamma.max,
		channel->gamma.v0,
		channel->gamma.slope,
		channel->gamma.in_exp_power,
		channel->gamma.out_exp_power,
		channel->gamma.in_exp_offset,
		channel->gamma.out_exp_offset);
		
	vdep_rate_const (&channel->delta.rate_const, v, 
		channel->delta.min,
		channel->delta.max,
		channel->delta.v0,
		channel->delta.slope,
		channel->delta.in_exp_power,
		channel->delta.out_exp_power,
		channel->delta.in_exp_offset,
		channel->delta.out_exp_offset);

/* Calculate the matrix values */

        if (channel->rxn_ord1 == 0) {
            lig1=1.0;
            }
        else if (channel->rxn_ord1 > 1) 
          {
	   lig1 = pow(ligand,channel->rxn_ord1);
          } 
        else 
          {
           lig1 = ligand;
          }

         if (channel->rxn_ord2 == 0) {
            lig2=1.0;
            }
        else if (channel->rxn_ord2 > 1) 
          {
	   lig2 = pow(ligand,channel->rxn_ord2);
          } 
        else 
          {
           lig2 = ligand;
          }


	channel->a11 = -channel->k2f.rate_const*lig2 - 
		channel->k1b.rate_const - channel->k1f.rate_const * lig1;
	channel->a12 = channel->k2b.rate_const - channel->k1f.rate_const * lig1;
	channel->b1 = channel->k1f.rate_const * lig1;

	channel->a21 = channel->k2f.rate_const*lig2 - 
	  channel->delta.rate_const * lig1*lig2;
	channel->a22 = -channel->k2b.rate_const - channel->gamma.rate_const -
	  channel->delta.rate_const * lig1*lig2;
	channel->b2 = channel->delta.rate_const * lig1*lig2;



/* Calculate the steady state values of the channel */

	    channel->TR1 = (Field(b2) * Field(a12) + Field(b1) * Field(a22)) / 
			(Field(a21) * Field(a12) - Field(a22) * Field(a11));

	    channel->TR2 = -(Field(b2) * Field(a11) + Field(b1) * Field(a21)) / 
			(Field(a21) * Field(a12) - Field(a22) * Field(a11));

/* Calculate the current */

	if (channel->cond_state == 1)
		channel->G = channel->TR1* channel->Gbar;
	else if (channel->cond_state == 2)
		channel->G = channel->TR2* channel->Gbar;
	else if (channel->cond_state == 0)
	    channel->G = (1-channel->TR1 - channel->TR2) * channel->Gbar;

	channel->I = (v - channel->Vr) * channel->G;


	break;

    case CHECK:
      n=0;
      MSGLOOP(channel,msg){
        case 0:
	  n +=1;
	  break;
        case 1:
	  n+=1;
	  break;
      }
      if(n != 2) {
	 ErrorMessage(" ligand2_chan","Missing v or ligand msg.",
			      channel);
      }
      break;
  }
}
