#!/bin/bash

cd ~/jcneurosci_code/network_c++_code/ # cd to the executables
fileprefix="FILEPREFIX"; # This is the directory in CCV where all the output will be there
connectionfileprefix="CONNPREFIX"; # This is the directory that stores the connectivity files
mscriptfileprefix="MSCRIPTPREFIX"; #  This is the directory that stores the master scripts
connectionfile="syn_sorted_PATTERN.DAT"; # This is the INPUT file you have to provide for the connectivity matrix
connectionsizefile="syn_size.DAT";
configfile="config.dat" # INPUT FILE TO STORE THE RANDOM SEED VALUES AND NUMBER OF NEURONS per processor (generated by the system)
cpoutfile="cpout.dat"; # (NOT USED NOW)
dataoutfile="dataout.dat"; # (NOT USED NOW)
spikeoutfile="spikeout.dat"; # OUTPUT FILES for spike reading in each processor
spikegrandfile="spike.dat"; # OUTPUT FILE for spike reading
lfp23outfile="LFP_L23.dat"; # OUTPUT FILE for LFP reading L23
lfp4outfile="LFP_L4.dat"; # OUTPUT FILE for LFP reading L4
lfp5outfile="LFP_L5.dat"; # OUTPUT FILE for LFP reading L5
lfp6outfile="LFP_L6.dat"; # OUTPUT FILE for LFP reading L6
lfpinoutfile="LFP_in.dat"; # OUTPUT FILE for LFP reading interneurons
K23outfile="K_L23.dat"; # OUTPUT FILE for K reading L23
K4outfile="K_L4.dat"; # OUTPUT FILE for K reading L4
K5outfile="K_L5.dat"; # OUTPUT FILE for K reading L5
Kinoutfile="K_in.dat"; # OUTPUT FILE for K reading L6
Ca23outfile="Ca_L23.dat"; # OUTPUT FILE for Ca L23
Cainoutfile="Ca_in.dat"; # OUTPUT FILE for Ca interneurons
KB23outfile="KB_L23.dat"; # OUTPUT FILE for KB L23
KBinoutfile="KB_in.dat"; # OUTPUT FILE for KB interneuron

rs_iext=IEXTRS; # Making sure I starts at ~3.5 # external bias current for RS cells (threshold for spike ~-0.07uA/cm2)
ib_iext=IEXTIB; # external bias current for IB cells (threshold for spike ~-0.08uA/cm2)
fs_iext=IEXTFS; # external bias current for FS cells (threshold for spike ~0.11uA/cm2)
poss_rate=POSS_RATE; # Poisson rate (events per ms per selected cell) default 2 Hz
poss_incr=POSS_INCR; # Increment (strength) for each poison event (default 0.25)
#vmd_gezero=0.005; # VmD ge_0 (mS/cm2)
#vmd_gezero_e=0.007; # VmD ge_0 (mS/cm2)
#vmd_sigmae_e=0.0015; # VmD sigma_e (mS/cm2)
#vmd_gizero_e=0.024;
#vmd_sigmai_e=0.0072;
#vmd_gezero_i=0.007; # VmD ge_0 (mS/cm2)
#vmd_sigmae_i=0.0015; # VmD sigma_e (mS/cm2)
#vmd_gizero_i=0.024;
#vmd_sigmai_i=0.0072;
vmd_gezero_e=Gee; # VmD ge_0 (mS/cm2)
vmd_sigmae_e=See; # VmD sigma_e (mS/cm2)
vmd_gizero_e=Gie;
vmd_sigmai_e=Sie;
vmd_gezero_i=Gei; # VmD ge_0 (mS/cm2)
vmd_sigmae_i=Sei; # VmD sigma_e (mS/cm2)
vmd_gizero_i=Gii;
vmd_sigmai_i=Sii;

k_for=GGLIAFOR
k_for_in=GGLIAFORIN
k_for_in_2=GGLIAFORIN2

k_back=GGLIABACK
k_back_in=GGLIABACKIN
k_back_in_2=GGLIABACKIN2


Ko_eq_pump=GGLIAKEQPUMP
Ko_eq_pump_in=GGLIAKEQPUMPIN
Ko_eq_pump_in_2=GGLIAKEQPUMPIN2

Ko_eq_glia=GGLIAKEQGLIA
Ko_eq_glia_in=GGLIAKEQGLIAIN
Ko_eq_glia_in_2=GGLIAKEQGLIAIN2

max_pump_current=GGLIAMAXPUMP
max_pump_current_in=GGLIAMAXPUMPIN
max_pump_current_in_2=GGLIAMAXPUMPIN2

rise=GGLIARISE
rise_in=GGLIARISEIN
rise_in_2=GGLIARISEIN2

stim_start=STIMSTART
stim_start_in=STIMSTARTIN

stim_end=STIMEND
stim_end_in=STIMENDIN

stim_strength=STIMSTRENGTH
stim_strength_in=STIMSTRENGTHIN

inhib_ramp_factor=INHIBRAMPFACTOR

use_vmd_flag=1; # 0 = use poisson; 1 = use vmd
lfp_sample=5; # Number of LFP sample points PER DIMENSION
sim_time=92000; # Time for simulation (in ms)--Note: for 64 cores roughly 0.9-1.8 hrs of run time per 1000 ms of sim time (depending on the compute nodes, number of spikes and how many LFP calculations to do--how many sites do you want to sample)

#delay=2.0; # synapse delay in ms
delay=0.5; # synapse delay in ms

delay_var=0; # synapase delay variance in ms (make sure delay>delay_var/2) default 0.25


#numproc=64; # default 32 (number of MPI process)
#npernode=4; # default 4 (number of MPI processes per node)
#numproc=16
#npernode=16
numproc=8
npernode=8

module load openmpi/1.8
perl write_connection_strength.pl ${connectionfileprefix} EE EI IE II PATTERN
wait
./cortical_assignment_main_custom $numproc ${fileprefix}${configfile}  # generate the random seeds and number of neurons
wait
mpirun -np $numproc -npernode $npernode ./test_neurons_openmp_dev ${connectionfileprefix}${connectionfile} ${connectionfileprefix}${connectionsizefile} ${fileprefix}${configfile} ${fileprefix}${cpoutfile} ${fileprefix}${dataoutfile} ${fileprefix}${spikeoutfile} ${fileprefix}${lfp23outfile} ${fileprefix}${lfp4outfile}  ${fileprefix}${lfp5outfile} ${fileprefix}${lfp6outfile} ${fileprefix}${lfpinoutfile} ${fileprefix}${K23outfile} ${fileprefix}${K4outfile}  ${fileprefix}${K5outfile} ${fileprefix}${Kinoutfile} ${fileprefix}${Ca23outfile} ${fileprefix}${Cainoutfile} ${fileprefix}${KB23outfile} ${fileprefix}${KBinoutfile} ${rs_iext} ${ib_iext} ${fs_iext} ${use_vmd_flag} ${poss_rate} ${poss_incr} ${poss_rate} ${poss_incr} ${vmd_gezero_e} ${vmd_sigmae_e} ${vmd_gizero_e} ${vmd_sigmai_e} ${vmd_gezero_i} ${vmd_sigmae_i} ${vmd_gizero_i} ${vmd_sigmai_i} ${lfp_sample} ${sim_time} ${delay} ${delay_var} ${k_for} ${k_back} ${rise} ${Ko_eq_pump} ${Ko_eq_glia} ${max_pump_current} ${k_for_in} ${k_back_in} ${rise_in} ${Ko_eq_pump_in} ${Ko_eq_glia_in} ${max_pump_current_in}  ${k_for_in_2} ${k_back_in_2} ${rise_in_2} ${Ko_eq_pump_in_2} ${Ko_eq_glia_in_2} ${max_pump_current_in_2} ${stim_start} ${stim_end} ${stim_strength} ${stim_start_in} ${stim_end_in} ${stim_strength_in} ${inhib_ramp_factor}


 # main programme
wait
./prep_spike_timing ${numproc}  ${fileprefix}${spikeoutfile} ${fileprefix}${spikegrandfile} # combine all the spike information into one big file
wait
perl sort_spike.pl ${fileprefix}${spikegrandfile} # sort the spike information





 
 
