clc; clear all; close all;
% *************************************************************************
% Fig S3 shows the error of position estimates and grid score pattern under
% the influence of bias-free and biased Gaussian noise.
% To update the data run SimNoiseWoutBias.m and SimNoiseWithBias.m.
%
%   Copyright (C) 2015  Florian Raudies, 05/02/2015, Palo Alto, CA.
%   License, GNU GPL, free software, without any warranty.
% *************************************************************************

WoutBias    = load('SimNoiseWoutBias'); % Load the simulation data.
WithBias    = load('SimNoiseWithBias');
LABEL_SIZE  = 16;                       % Label size in points.

figure('Position',[50 50 1200 800]);
subplot(2,4,1);
    imagesc(WoutBias.SpikeRateVelVCO); axis xy equal tight off;
    title(sprintf('%s\n%s\n%s\n%s','Moving Feature System',...
        sprintf('GS %2.2f',WoutBias.gsVelVCO), ...
        sprintf('mu %2.2f deg/sec', WoutBias.muNoiseForVel*180/pi),...
        sprintf('sigma %2.2f deg/sec', WoutBias.sigmaNoiseForVel*180/pi)),...
            'FontSize',LABEL_SIZE);
subplot(2,4,2);
    imagesc(WoutBias.SpikeRateAngVCO); axis xy equal tight off;
    title(sprintf('%s\n%s\n%s\n%s','Static Feature System',...
        sprintf('GS %2.2f',WoutBias.gsAngVCO), ...
        sprintf('mu %2.2f deg', WoutBias.muNoiseForAng*180/pi),...
        sprintf('sigma %2.2f deg', WoutBias.sigmaNoiseForAng*180/pi)),...
            'FontSize',LABEL_SIZE);
subplot(2,4,3);
    imagesc(WithBias.SpikeRateVelVCO); axis xy equal tight off;
    title(sprintf('%s\n%s\n%s\n%s','Moving Feature System',...
        sprintf('GS %2.2f',WithBias.gsVelVCO), ...
        sprintf('mu %2.2f deg/sec', WithBias.muNoiseForVel*180/pi),...
        sprintf('sigma %2.2f deg/sec', WithBias.sigmaNoiseForVel*180/pi)),...
            'FontSize',LABEL_SIZE);
subplot(2,4,4);
    imagesc(WithBias.SpikeRateAngVCO); axis xy equal tight off;
    title(sprintf('%s\n%s\n%s\n%s','Static Feature System',...
        sprintf('GS %2.2f',WithBias.gsAngVCO), ...
        sprintf('mu %2.2f deg', WithBias.muNoiseForAng*180/pi),...
        sprintf('sigma %2.2f deg', WithBias.sigmaNoiseForAng*180/pi)),...
            'FontSize',LABEL_SIZE);
subplot(2,4,5);
    imagesc(WoutBias.SpikeRateVelAtt); axis xy equal tight off;
    title(sprintf('%s\n%s\n%s\n%s','Moving Feature System',...
        sprintf('GS %2.2f',WoutBias.gsVelAtt), ...
        sprintf('mu %2.2f deg/sec', WoutBias.muNoiseForVel*180/pi),...
        sprintf('sigma %2.2f deg/sec', WoutBias.sigmaNoiseForVel*180/pi)),...
            'FontSize',LABEL_SIZE);
subplot(2,4,6);
    imagesc(WoutBias.SpikeRateAngAtt); axis xy equal tight off;
    title(sprintf('%s\n%s\n%s\n%s','Static Feature System',...
        sprintf('GS %2.2f',WoutBias.gsAngAtt), ...
        sprintf('mu %2.2f deg', WoutBias.muNoiseForAng*180/pi),...
        sprintf('sigma %2.2f deg', WoutBias.sigmaNoiseForAng*180/pi)),...
            'FontSize',LABEL_SIZE);        
subplot(2,4,7);
    imagesc(WithBias.SpikeRateVelAtt); axis xy equal tight off;
    title(sprintf('%s\n%s\n%s\n%s','Moving Feature System',...
        sprintf('GS %2.2f',WithBias.gsVelAtt), ...
        sprintf('mu %2.2f deg/sec', WithBias.muNoiseForVel*180/pi),...
        sprintf('sigma %2.2f deg/sec', WithBias.sigmaNoiseForVel*180/pi)),...
            'FontSize',LABEL_SIZE);
subplot(2,4,8);
    imagesc(WithBias.SpikeRateAngAtt); axis xy equal tight off;
    title(sprintf('%s\n%s\n%s\n%s','Static Feature System',...
        sprintf('GS %2.2f',WithBias.gsAngAtt), ...
        sprintf('mu %2.2f deg', WithBias.muNoiseForAng*180/pi),...
        sprintf('sigma %2.2f deg', WithBias.sigmaNoiseForAng*180/pi)),...
            'FontSize',LABEL_SIZE);
print('-depsc','FigS3');
