function M = rotMatrixForAngles(Rot)
% rotMatrixForAngles
%   Rot - 3D vector with Euler angles for pitch, yaw, and roll.
%
% RETURNS
%   M   - 4 x 4 rotation matrix.
%
% DESCRIPTION
%   See Shirley & Marschner (2009). Fundamentals of computer graphics (3rd
%   edition). A.K. Peters, Ltd. Natick MA 01760, pages 126.
%
%   Copyright (C) 2015  Florian Raudies, 05/02/2015, Palo Alto, CA.
%   License, GNU GPL, free software, without any warranty.
%

M = [1 0            0            0; ...
     0 +cos(Rot(1)) -sin(Rot(1)) 0; ...
     0 +sin(Rot(1)) +cos(Rot(1)) 0; ...
     0 0            0            1] * ...
    [+cos(Rot(2)) 0 +sin(Rot(2)) 0; ...
     0            1  0           0; ...
     -sin(Rot(2)) 0 +cos(Rot(2)) 0; ...
     0            0  0           1] * ...
    [+cos(Rot(3)) -sin(Rot(3)) 0 0; ...
     +sin(Rot(3)) +cos(Rot(3)) 0 0; ...
     0            0            1 0; ...
     0            0            0 1];

