function [fitresult, gof] = CAP_vs_distance(CAP_cond, Distance_distaltosoma)
%CREATEFIT(CAP_COND,DISTANCE_DISTALTOSOMA)
%  Create a fit.
%
%  Data for 'Exponential' fit:
%      X Input: CAP_cond
%      Y Output: Distance_distaltosoma
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 18-Jan-2024 13:02:46


%% Fit: 'CaP vs distance'.
[xData, yData] = prepareCurveData( CAP_cond, Distance_distaltosoma );

% Set up fittype and options.
ft = fittype( 'exp2' );
opts = fitoptions( 'Method', 'NonlinearLeastSquares' );
opts.Display = 'Off';
opts.StartPoint = [202.818143675863 -1.59815037720448 156.790064686504 -0.0117363387798465];

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% Plot fit with data.
figure( 'Name', 'Exponential' );
h = plot( fitresult, xData, yData );
legend( h, 'Distance_to_soma vs. CAP_cond', 'Exponential', 'Location', 'NorthEast', 'Interpreter', 'none' );
% Label axes
xlabel( 'CAP_cond', 'Interpreter', 'none' );
ylabel( 'Distance to soma', 'Interpreter', 'none' );
grid on


