function [fitresult, gof] = CaP_vs_length(CAP_cond, Lengthbr)
%CREATEFIT(CAP_vs_length,LENGTHBR)
%  Create a fit.
%
%  Data for 'CAP vs length' fit:
%      X Input: CAP_cond
%      Y Output: Lengthbr
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 18-Jan-2024 13:00:57


%% Fit: 'Exponential'.
[xData, yData] = prepareCurveData( CAP_cond, Lengthbr );

% Set up fittype and options.
ft = fittype( 'exp2' );
opts = fitoptions( 'Method', 'NonlinearLeastSquares' );
opts.Display = 'Off';
opts.StartPoint = [252.58093141911 -0.828749556306012 402.703707464801 -0.427948320044836];

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% Plot fit with data.
figure( 'Name', 'Exponential' );
h = plot( fitresult, xData, yData );
legend( h, 'Lengthbr vs. CAP_cond', 'Exponential', 'Location', 'NorthEast', 'Interpreter', 'none' );
% Label axes
xlabel( 'CAP_cond', 'Interpreter', 'none' );
ylabel( 'Length', 'Interpreter', 'none' );
grid on


