This is the readme for the model which replicates Settings 1/2 in Figure 1/2/3 in the paper:

> Kořenek J, Sanda P, Hlinka J: Higher order definition of causality by optimally conditioned transfer entropy. Physical Review E 111, L042302, 2025.

It is essentially model of Gidon et al., 2020 [doi:10.1126/science.aax6239](http://dx.doi.org/10.1126/science.aax6239), code taken from [modeldb.science/254217](https://modeldb.science/254217), with only few changes. To summarize them:

The model is run for longer time (100 [s]) and its synaptic input is modulated to represent binary input. The two inputs X1, X2 were generated as independent uniformly distributed random vectors of 0/1s. Each logical value was then translated into 250 ms block of input synaptic events ("1" was represented by random events generated from negative exponential distribution of mean 20 Hz as in Gidon et al., for "0" the distribution had mean 5 Hz). Inhibitory synapses and background synaptic noise (provided by 100 random synapses distributed over the whole dendritic tree) were set as in Gidon et. al. To allow higher spiking rate we decreased refractory period of dCaAP from 100 ms to 50 ms and for setting 1 in Fig 2. increased dCaAP weight from 1.6 to 3.

### Model usage:

This code was written in and requires NEURON (tested in version 8.1) which is freely available from [nrn.readthedocs.io](https://nrn.readthedocs.io/).

This model was run and tested under the linux operating system (Debian 11).

### Installing instructions:

- Download and expand this archive and compile the mod files located in the "`_mod`" folder with `nrnivmodl` ("`nrnivmodl _mod`").
- For running, stack size needs to be enlarged (see `NSTACK` argument) as we used more local variables for the input: `x84_64/special -NSTACK 2000 mosinit.hoc`.
- Once the code is running you can select a simulation from a menu offering Setting 1 or Setting 2 conditions.

If you need more help running NEURON on your platform, please consult: [nrn.readthedocs.io](https://nrn.readthedocs.io/).

For convenience, we add the two binary random vectors used for generating the input in the file "`uni_rand.txt`" (the lines 1001-1400 were used to produce tplay input in `syns.hoc`).

### Licensing:

To our knowledge, the original code of Gidon et al. does not have any license statement, thus we are not in a position to claim any license on this code. Our own changes are under MIT license.