# -*- coding: utf-8 -*-
"""
Created on Mon Dec  3 15:20:21 2018

@author: mkc156
"""

import logging


def load_MN_0(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_0_loaded')
    soma.diam = 22.0
    soma.L = 2952.0
    soma.g_pas = 8.109e-05
    soma.e_pas = -71.0
    soma.gbar_na3rp = 0.01
    soma.gbar_naps = 2.6e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.015
    soma.gcamax_mAHP = 6.4e-06
    soma.gkcamax_mAHP = 0.00045
    soma.taur_mAHP = 90.0
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.35546
    soma.ghbar_gh = 3e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1794.13
        sec.diam = 8.73071
        sec.g_pas = 7.93445e-05
        sec.e_pas = -71.0
        sec.gcabar_L_Ca_inact = 9.5e-05
        sec.Ra = 51.038
        sec.cm = 0.867781
        sec.ghbar_gh = 3e-05
        sec.half_gh = -77.0
            
    d1.gcabar_L_Ca_inact = 8.5e-05
    d2.gcabar_L_Ca_inact = 9.5e-05
    d3.gcabar_L_Ca_inact = 0.0001
    d4.gcabar_L_Ca_inact = 0.000115
    
    h.qinf_na3rp = 8.0
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -42.0
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 10.0
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0
    
            


def load_MN_1(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_1_loaded')
    soma.diam = 22.012031828254848
    soma.L = 2953.0723367590026
    soma.g_pas = 8.153454293628809e-05
    soma.e_pas = -71.00150387811634
    soma.gbar_na3rp = 0.010018047091412742
    soma.gbar_naps = 2.5990976121883654e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.015007519889196675
    soma.gcamax_mAHP = 6.4000092740003525e-06
    soma.gkcamax_mAHP = 0.0004502254847645429
    soma.taur_mAHP = 89.90976127423822
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.3562466759002771
    soma.ghbar_gh = 3.0300795013850418e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1794.7808918836565
        sec.diam = 8.735484819944599
        sec.g_pas = 7.948849861495845e-05
        sec.e_pas = -71.00150387811634
        sec.gcabar_L_Ca_inact = 9.504662049861496e-05
        sec.Ra = 51.02253458725762
        sec.cm = 0.8677999889196676
        sec.ghbar_gh = 3.0300795013850418e-05
        sec.half_gh = -77.0
    
    d1.gcabar_L_Ca_inact = 8.504963988919669e-05
    d2.gcabar_L_Ca_inact = 9.504963988919669e-05
    d3.gcabar_L_Ca_inact = 0.00010005714681440443
    d4.gcabar_L_Ca_inact = 0.00011505714681440443
        
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.99548806094183
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 9.96992049861496
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h


def load_MN_2(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_2_loaded')
    soma.diam = 22.04812731301939
    soma.L = 2956.289347036011
    soma.g_pas = 8.286817174515235e-05
    soma.e_pas = -71.00601551246537
    soma.gbar_na3rp = 0.010072188365650969
    soma.gbar_naps = 2.5963904487534626e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.015030079556786704
    soma.gcamax_mAHP = 6.400148384005647e-06
    soma.gkcamax_mAHP = 0.00045090193905817174
    soma.taur_mAHP = 89.63904509695291
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.3586067036011082
    soma.ghbar_gh = 3.1203180055401665e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1796.7335675346262
        sec.diam = 8.749809279778393
        sec.g_pas = 7.992049445983379e-05
        sec.e_pas = -71.00601551246537
        sec.gcabar_L_Ca_inact = 9.518648199445984e-05
        sec.Ra = 50.97613834903047
        sec.cm = 0.8678569556786704
        sec.ghbar_gh = 3.1203180055401665e-05
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 8.519855955678671e-05
    d2.gcabar_L_Ca_inact = 9.519855955678671e-05
    d3.gcabar_L_Ca_inact = 0.00010022858725761773
    d4.gcabar_L_Ca_inact = 0.00011522858725761773
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.98195224376731
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 9.879681994459833
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_3(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_3_loaded')
    soma.diam = 22.10828645429363
    soma.L = 2961.651030831025
    soma.g_pas = 8.50908864265928e-05
    soma.e_pas = -71.01353490304709
    soma.gbar_na3rp = 0.010162423822714681
    soma.gbar_naps = 2.5918785096952908e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.015067679002770083
    soma.gcamax_mAHP = 6.40075119402859e-06
    soma.gkcamax_mAHP = 0.0004520293628808864
    soma.taur_mAHP = 89.18785146814405
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.3625400831024932
    soma.ghbar_gh = 3.270715512465374e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1799.9880269529087
        sec.diam = 8.773683379501385
        sec.g_pas = 8.064048753462603e-05
        sec.e_pas = -71.01353490304709
        sec.gcabar_L_Ca_inact = 9.541958448753463e-05
        sec.Ra = 50.89881128531856
        sec.cm = 0.8679519002770083
        sec.ghbar_gh = 3.270715512465374e-05
        sec.half_gh = -77.0
    
    d1.gcabar_L_Ca_inact = 8.54467590027701e-05
    d2.gcabar_L_Ca_inact = 9.544675900277009e-05
    d3.gcabar_L_Ca_inact = 0.00010051432132963989
    d4.gcabar_L_Ca_inact = 0.00011551432132963989
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.95939254847645
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 9.729284487534626
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_4(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_4_loaded')
    soma.diam = 22.192509252077564
    soma.L = 2969.1573881440445
    soma.g_pas = 8.820268698060941e-05
    soma.e_pas = -71.0240620498615
    soma.gbar_na3rp = 0.010288753462603878
    soma.gbar_naps = 2.5855617950138504e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.015120318227146814
    soma.gcamax_mAHP = 6.402374144090362e-06
    soma.gkcamax_mAHP = 0.00045360775623268695
    soma.taur_mAHP = 88.55618038781164
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.3680468144044322
    soma.ghbar_gh = 3.481272022160665e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1804.5442701385043
        sec.diam = 8.807107119113574
        sec.g_pas = 8.164847783933517e-05
        sec.e_pas = -71.0240620498615
        sec.gcabar_L_Ca_inact = 9.574592797783935e-05
        sec.Ra = 50.79055339612188
        sec.cm = 0.8680848227146815
        sec.ghbar_gh = 3.481272022160665e-05
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 8.579423822714682e-05
    d2.gcabar_L_Ca_inact = 9.579423822714682e-05
    d3.gcabar_L_Ca_inact = 0.00010091434903047092
    d4.gcabar_L_Ca_inact = 0.00011591434903047092
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.927808975069254
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 9.518727977839335
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_5(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_5_loaded')
    soma.diam = 22.30079570637119
    soma.L = 2978.8084189750693
    soma.g_pas = 9.220357340720221e-05
    soma.e_pas = -71.03759695290859
    soma.gbar_na3rp = 0.01045117728531856
    soma.gbar_naps = 2.577440304709141e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.015187997229916896
    soma.gcamax_mAHP = 6.405796250220609e-06
    soma.gkcamax_mAHP = 0.0004556371191135734
    soma.taur_mAHP = 87.74403185595568
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.3751268975069253
    soma.ghbar_gh = 3.7519875346260385e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1810.402297091413
        sec.diam = 8.85008049861496
        sec.g_pas = 8.294446537396122e-05
        sec.e_pas = -71.03759695290859
        sec.gcabar_L_Ca_inact = 9.616551246537397e-05
        sec.Ra = 50.65136468144044
        sec.cm = 0.8682557229916897
        sec.ghbar_gh = 3.7519875346260385e-05
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 8.62409972299169e-05
    d2.gcabar_L_Ca_inact = 9.62409972299169e-05
    d3.gcabar_L_Ca_inact = 0.00010142867036011081
    d4.gcabar_L_Ca_inact = 0.00011642867036011081
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.887201523545706
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 9.24801246537396
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_6(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_6_loaded')
    soma.diam = 22.433145817174516
    soma.L = 2990.6041233241
    soma.g_pas = 9.709354570637119e-05
    soma.e_pas = -71.05413961218837
    soma.gbar_na3rp = 0.010649695290858725
    soma.gbar_naps = 2.5675140387811633e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.015270716011080331
    soma.gcamax_mAHP = 6.412019104457455e-06
    soma.gkcamax_mAHP = 0.0004581174515235457
    soma.taur_mAHP = 86.75140587257617
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.3837803324099724
    soma.ghbar_gh = 4.0828620498614956e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1817.5621078116344
        sec.diam = 8.90260351800554
        sec.g_pas = 8.452845013850415e-05
        sec.e_pas = -71.05413961218837
        sec.gcabar_L_Ca_inact = 9.667833795013851e-05
        sec.Ra = 50.481245141274236
        sec.cm = 0.8684646011080333
        sec.ghbar_gh = 4.0828620498614956e-05
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 8.678703601108034e-05
    d2.gcabar_L_Ca_inact = 9.678703601108034e-05
    d3.gcabar_L_Ca_inact = 0.00010205728531855957
    d4.gcabar_L_Ca_inact = 0.00011705728531855956
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.83757019390582
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 8.917137950138503
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_7(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_7_loaded')
    soma.diam = 22.589559584487535
    soma.L = 3004.5445011911356
    soma.g_pas = 0.00010287260387811634
    soma.e_pas = -71.07369002770083
    soma.gbar_na3rp = 0.010884307479224377
    soma.gbar_naps = 2.5557829972299166e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.01536847457063712
    soma.gcamax_mAHP = 6.422266874847491e-06
    soma.gkcamax_mAHP = 0.00046104875346260387
    soma.taur_mAHP = 85.57830243767313
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.3940071191135734
    soma.ghbar_gh = 4.473895567867036e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1826.0237022991691
        sec.diam = 8.96467617728532
        sec.g_pas = 8.640043213296399e-05
        sec.e_pas = -71.07369002770083
        sec.gcabar_L_Ca_inact = 9.728440443213296e-05
        sec.Ra = 50.280194775623265
        sec.cm = 0.8687114570637119
        sec.ghbar_gh = 4.473895567867036e-05
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 8.743235457063712e-05
    d2.gcabar_L_Ca_inact = 9.743235457063712e-05
    d3.gcabar_L_Ca_inact = 0.00010280019390581718
    d4.gcabar_L_Ca_inact = 0.00011780019390581717
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.77891498614959
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 8.526104432132964
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_8(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_8_loaded')
    soma.diam = 22.77003700831025
    soma.L = 3020.629552576177
    soma.g_pas = 0.00010954074792243767
    soma.e_pas = -71.09624819944598
    soma.gbar_na3rp = 0.011155013850415512
    soma.gbar_naps = 2.5422471800554017e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.015481272908587257
    soma.gcamax_mAHP = 6.437986305445784e-06
    soma.gkcamax_mAHP = 0.0004644310249307479
    soma.taur_mAHP = 84.22472155124653
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.4058072576177287
    soma.ghbar_gh = 4.925088088642659e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1835.7870805540167
        sec.diam = 9.036298476454293
        sec.g_pas = 8.856041135734072e-05
        sec.e_pas = -71.09624819944598
        sec.gcabar_L_Ca_inact = 9.798371191135734e-05
        sec.Ra = 50.048213584487534
        sec.cm = 0.8689962908587258
        sec.ghbar_gh = 4.925088088642659e-05
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 8.817695290858726e-05
    d2.gcabar_L_Ca_inact = 9.817695290858726e-05
    d3.gcabar_L_Ca_inact = 0.00010365739612188365
    d4.gcabar_L_Ca_inact = 0.00011865739612188365
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.71123590027701
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 8.07491191135734
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_9(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_9_loaded')
    soma.diam = 22.97457808864266
    soma.L = 3038.859277479224
    soma.g_pas = 0.00011709797783933517
    soma.e_pas = -71.12181412742382
    soma.gbar_na3rp = 0.011461814404432133
    soma.gbar_naps = 2.5269065872576177e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.015609111024930747
    soma.gcamax_mAHP = 6.460846716315866e-06
    soma.gkcamax_mAHP = 0.00046826426592797785
    soma.taur_mAHP = 82.6906632132964
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.4191807479224379
    soma.ghbar_gh = 5.436439612188365e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1846.8522425761773
        sec.diam = 9.117470415512466
        sec.g_pas = 9.100838781163435e-05
        sec.e_pas = -71.12181412742382
        sec.gcabar_L_Ca_inact = 9.877626038781165e-05
        sec.Ra = 49.78530156786703
        sec.cm = 0.8693191024930748
        sec.ghbar_gh = 5.436439612188365e-05
        sec.half_gh = -77.0
    
    d1.gcabar_L_Ca_inact = 8.902083102493075e-05
    d2.gcabar_L_Ca_inact = 9.902083102493075e-05
    d3.gcabar_L_Ca_inact = 0.000104628891966759
    d4.gcabar_L_Ca_inact = 0.000119628891966759
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.63453293628809
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 7.563560387811634
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_10(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_10_loaded')
    soma.diam = 23.203182825484763
    soma.L = 3059.233675900277
    soma.g_pas = 0.00012554429362880885
    soma.e_pas = -71.15038781163435
    soma.gbar_na3rp = 0.011804709141274237
    soma.gbar_naps = 2.509761218836565e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.01575198891966759
    soma.gcamax_mAHP = 6.4927400035297455e-06
    soma.gkcamax_mAHP = 0.0004725484764542936
    soma.taur_mAHP = 80.97612742382272
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.4341275900277008
    soma.ghbar_gh = 6.007950138504155e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1859.219188365651
        sec.diam = 9.208191994459835
        sec.g_pas = 9.374436149584487e-05
        sec.e_pas = -71.15038781163435
        sec.gcabar_L_Ca_inact = 9.966204986149585e-05
        sec.Ra = 49.49145872576177
        sec.cm = 0.869679891966759
        sec.ghbar_gh = 6.007950138504155e-05
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 8.99639889196676e-05
    d2.gcabar_L_Ca_inact = 9.99639889196676e-05
    d3.gcabar_L_Ca_inact = 0.00010571468144044321
    d4.gcabar_L_Ca_inact = 0.00012071468144044321
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.54880609418282
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 6.992049861495845
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_11(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_11_loaded')
    soma.diam = 23.455851218836564
    soma.L = 3081.7527478393354
    soma.g_pas = 0.00013487969529085874
    soma.e_pas = -71.18196925207756
    soma.gbar_na3rp = 0.012183698060941828
    soma.gbar_naps = 2.4908110747922436e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.015909906592797785
    soma.gcamax_mAHP = 6.5357806391679005e-06
    soma.gkcamax_mAHP = 0.0004772836565096953
    soma.taur_mAHP = 79.08111418282549
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.4506477839335181
    soma.ghbar_gh = 6.639619667590028e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1872.8879179224377
        sec.diam = 9.308463213296399
        sec.g_pas = 9.67683324099723e-05
        sec.e_pas = -71.18196925207756
        sec.gcabar_L_Ca_inact = 0.00010064108033240998
        sec.Ra = 49.166685058171744
        sec.cm = 0.8700786592797785
        sec.ghbar_gh = 6.639619667590028e-05
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 9.100642659279779e-05
    d2.gcabar_L_Ca_inact = 0.00010100642659279779
    d3.gcabar_L_Ca_inact = 0.0001069147645429363
    d4.gcabar_L_Ca_inact = 0.0001219147645429363
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.45405537396122
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 6.360380332409972
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_12(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_12_loaded')
    soma.diam = 23.73258326869806
    soma.L = 3106.416493296399
    soma.g_pas = 0.00014510418282548474
    soma.e_pas = -71.21655844875346
    soma.gbar_na3rp = 0.012598781163434903
    soma.gbar_naps = 2.4700561551246537e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.01608286404432133
    soma.gcamax_mAHP = 6.592305671319281e-06
    soma.gkcamax_mAHP = 0.00048246980609418285
    soma.taur_mAHP = 77.00562349030471
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.4687413296398892
    soma.ghbar_gh = 7.331448199445983e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1887.8584312465375
        sec.diam = 9.41828407202216
        sec.g_pas = 0.00010008030055401662
        sec.e_pas = -71.21655844875346
        sec.gcabar_L_Ca_inact = 0.00010171335180055403
        sec.Ra = 48.81098056509695
        sec.cm = 0.8705154044321329
        sec.ghbar_gh = 7.331448199445983e-05
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 9.214814404432134e-05
    d2.gcabar_L_Ca_inact = 0.00010214814404432134
    d3.gcabar_L_Ca_inact = 0.00010822914127423824
    d4.gcabar_L_Ca_inact = 0.00012322914127423822
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.35028077562327
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 5.668551800554017
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_13(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_13_loaded')
    soma.diam = 24.03337897506925
    soma.L = 3133.2249122714684
    soma.g_pas = 0.00015621775623268698
    soma.e_pas = -71.25415540166205
    soma.gbar_na3rp = 0.013049958448753462
    soma.gbar_naps = 2.447496459833795e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.016270861274238227
    soma.gcamax_mAHP = 6.664874724081306e-06
    soma.gkcamax_mAHP = 0.00048810692520775625
    soma.taur_mAHP = 74.74965534626038
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.4884082271468144
    soma.ghbar_gh = 8.083435734072022e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1904.1307283379501
        sec.diam = 9.53765457063712
        sec.g_pas = 0.00010368026592797784
        sec.e_pas = -71.25415540166205
        sec.gcabar_L_Ca_inact = 0.00010287886426592799
        sec.Ra = 48.42434524653739
        sec.cm = 0.8709901274238228
        sec.ghbar_gh = 8.083435734072022e-05
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 9.338914127423824e-05
    d2.gcabar_L_Ca_inact = 0.00010338914127423823
    d3.gcabar_L_Ca_inact = 0.00010965781163434904
    d4.gcabar_L_Ca_inact = 0.00012465781163434903
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.237482299168974
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 4.916564265927978
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_14(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_14_loaded')
    soma.diam = 24.358238337950137
    soma.L = 3162.178004764543
    soma.g_pas = 0.00016822041551246538
    soma.e_pas = -71.29476011080332
    soma.gbar_na3rp = 0.013537229916897505
    soma.gbar_naps = 2.4231319889196673e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.016473898282548475
    soma.gcamax_mAHP = 6.756269997559871e-06
    soma.gkcamax_mAHP = 0.0004941950138504155
    soma.taur_mAHP = 72.31320975069252
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.5096484764542937
    soma.ghbar_gh = 8.895582271468143e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1921.7048091966758
        sec.diam = 9.666574709141274
        sec.g_pas = 0.00010756822853185595
        sec.e_pas = -71.29476011080332
        sec.gcabar_L_Ca_inact = 0.00010413761772853186
        sec.Ra = 48.00677910249307
        sec.cm = 0.8715028282548476
        sec.ghbar_gh = 8.895582271468143e-05
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 9.472941828254847e-05
    d2.gcabar_L_Ca_inact = 0.00010472941828254847
    d3.gcabar_L_Ca_inact = 0.0001112007756232687
    d4.gcabar_L_Ca_inact = 0.0001262007756232687
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -41.115659944598335
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 4.104417728531857
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_15(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_15_loaded')
    soma.diam = 24.70716135734072
    soma.L = 3193.275770775623
    soma.g_pas = 0.00018111216066481997
    soma.e_pas = -71.33837257617729
    soma.gbar_na3rp = 0.014060595567867035
    soma.gbar_naps = 2.3969627423822716e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.016691975069252078
    soma.gcamax_mAHP = 6.869496267869338e-06
    soma.gkcamax_mAHP = 0.0005007340720221607
    soma.taur_mAHP = 69.6962867036011
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.532462077562327
    soma.ghbar_gh = 9.76788781163435e-05
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1940.5806738227147
        sec.diam = 9.805044487534627
        sec.g_pas = 0.00011174418836565098
        sec.e_pas = -71.33837257617729
        sec.gcabar_L_Ca_inact = 0.00010548961218836565
        sec.Ra = 47.55828213296399
        sec.cm = 0.8720535069252078
        sec.ghbar_gh = 9.76788781163435e-05
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 9.616897506925208e-05
    d2.gcabar_L_Ca_inact = 0.00010616897506925208
    d3.gcabar_L_Ca_inact = 0.00011285803324099723
    d4.gcabar_L_Ca_inact = 0.00012785803324099723
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -40.98481371191136
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 3.23211218836565
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_16(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_16_loaded')
    soma.diam = 25.080148033240995
    soma.L = 3226.518210304709
    soma.g_pas = 0.00019489299168975067
    soma.e_pas = -71.38499279778394
    soma.gbar_na3rp = 0.014620055401662047
    soma.gbar_naps = 2.3689887202216068e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.01692509163434903
    soma.gcamax_mAHP = 7.007780887132542e-06
    soma.gkcamax_mAHP = 0.0005077240997229917
    soma.taur_mAHP = 66.89888620498616
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.5568490304709142
    soma.ghbar_gh = 0.00010700352354570636
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1960.7583222160665
        sec.diam = 9.953063905817174
        sec.g_pas = 0.00011620814542936288
        sec.e_pas = -71.38499279778394
        sec.gcabar_L_Ca_inact = 0.00010693484764542937
        sec.Ra = 47.07885433795013
        sec.cm = 0.8726421634349031
        sec.ghbar_gh = 0.00010700352354570636
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 9.770781163434902e-05
    d2.gcabar_L_Ca_inact = 0.00010770781163434902
    d3.gcabar_L_Ca_inact = 0.00011462958448753463
    d4.gcabar_L_Ca_inact = 0.00012962958448753463
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -40.844943601108035
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 2.2996476454293635
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_17(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_17_loaded')
    soma.diam = 25.47719836565097
    soma.L = 3261.9053233518007
    soma.g_pas = 0.00020956290858725762
    soma.e_pas = -71.43462077562327
    soma.gbar_na3rp = 0.015215609418282547
    soma.gbar_naps = 2.339209922437673e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.017173247977839336
    soma.gcamax_mAHP = 7.17457378348079e-06
    soma.gkcamax_mAHP = 0.0005151650969529086
    soma.taur_mAHP = 63.92100825484765
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.5828093351800554
    soma.ghbar_gh = 0.00011692975900277008
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 1982.2377543767313
        sec.diam = 10.11063296398892
        sec.g_pas = 0.0001209600997229917
        sec.e_pas = -71.43462077562327
        sec.gcabar_L_Ca_inact = 0.000108473324099723
        sec.Ra = 46.56849571745152
        sec.cm = 0.8732687977839335
        sec.ghbar_gh = 0.00011692975900277008
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 9.934592797783934e-05
    d2.gcabar_L_Ca_inact = 0.00010934592797783934
    d3.gcabar_L_Ca_inact = 0.0001165154293628809
    d4.gcabar_L_Ca_inact = 0.00013151542936288088
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -40.69604961218837
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 1.307024099722991
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_18(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_18_loaded')
    soma.diam = 25.898312354570635
    soma.L = 3299.4371099168975
    soma.g_pas = 0.0002251219113573407
    soma.e_pas = -71.4872565096953
    soma.gbar_na3rp = 0.01584725761772853
    soma.gbar_naps = 2.307626349030471e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.017436444099722993
    soma.gcamax_mAHP = 7.3735474610538585e-06
    soma.gkcamax_mAHP = 0.0005230570637119113
    soma.taur_mAHP = 60.7626528531856
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.6103429916897507
    soma.ghbar_gh = 0.0001274575844875346
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 2005.018970304709
        sec.diam = 10.277751662049862
        sec.g_pas = 0.0001260000512465374
        sec.e_pas = -71.4872565096953
        sec.gcabar_L_Ca_inact = 0.00011010504155124654
        sec.Ra = 46.027206271468145
        sec.cm = 0.8739334099722992
        sec.ghbar_gh = 0.0001274575844875346
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 0.00010108332409972299
    d2.gcabar_L_Ca_inact = 0.00011108332409972299
    d3.gcabar_L_Ca_inact = 0.00011851556786703601
    d4.gcabar_L_Ca_inact = 0.000133515567867036
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -40.538131745152356
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = 0.2542415512465386
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

def load_MN_19(soma,dend,d1,d2,d3,d4,h):
    # logging.info('MN_19_loaded')
    soma.diam = 26.34349
    soma.L = 3339.11357
    soma.g_pas = 0.00024157
    soma.e_pas = -71.5429
    soma.gbar_na3rp = 0.016515
    soma.gbar_naps = 2.274238e-05
    soma.sh_na3rp = 1.0
    soma.sh_naps = 5.0
    soma.ar_na3rp = 1.0
    soma.ar_naps = 1.0
    soma.gMax_kdrRL = 0.01771468
    soma.gcamax_mAHP = 7.608597e-06
    soma.gkcamax_mAHP = 0.0005314
    soma.taur_mAHP = 57.42382
    soma.ek = -80.0
    soma.Ra = 0.001
    soma.cm = 1.63945
    soma.ghbar_gh = 0.000138587
    soma.half_gh = -77.0
    
    for sec in dend:
        sec.L = 2029.10197
        sec.diam = 10.45442
        sec.g_pas = 0.000131328
        sec.e_pas = -71.5429
        sec.gcabar_L_Ca_inact = 0.00011183
        sec.Ra = 45.454986
        sec.cm = 0.874636
        sec.ghbar_gh = 0.000138587
        sec.half_gh = -77.0

    d1.gcabar_L_Ca_inact = 0.00010292
    d2.gcabar_L_Ca_inact = 0.00011292
    d3.gcabar_L_Ca_inact = 0.00012063
    d4.gcabar_L_Ca_inact = 0.00013563
    
    h.qinf_na3rp = 8.0
    h.thinf_na3rp = -50.0
    h.vslope_naps = 5.0
    h.asvh_naps = -90.0
    h.bsvh_naps = -22.0
    h.mvhalfca_mAHP = -20.0
    h.mtauca_mAHP = 2.0
    h.celsius = 37.0
    h.theta_m_L_Ca_inact = -40.37119
    h.tau_m_L_Ca_inact = 40.0
    h.theta_h_L_Ca_inact = -0.8587000000000007
    h.tau_h_L_Ca_inact = 2500.0
    h.kappa_h_L_Ca_inact = 5.0
    h.htau_gh = 30.0

    return soma, dend, d1, d2, d3, d4, h

#def load_MN_0(soma,dend,d1,d2,d3,d4,h):
#    # logging.info('MN_TEST_loaded')
#    soma.diam = 0.1
#    soma.L = 0.1
#    soma.g_pas = 0.1
#    soma.e_pas = 0.1
#    soma.gbar_na3rp = 0.1
#    soma.gbar_naps = 0.1
#    soma.sh_na3rp = 0.1
#    soma.sh_naps = 0.1
#    soma.ar_na3rp = 0.1
#    soma.ar_naps = 0.1
#    soma.gMax_kdrRL = 0.1
#    soma.gcamax_mAHP = 0.1
#    soma.gkcamax_mAHP = 0.1
#    soma.taur_mAHP = 0.1
#    soma.ek = 0.1
#    soma.Ra = 0.1
#    soma.cm = 0.1
#    soma.ghbar_gh = 0.1
#    soma.half_gh = 0.1
#    
#    for sec in dend:
#        sec.L = 0.1
#        sec.diam = 0.1
#        sec.g_pas = 0.1
#        sec.e_pas = 0.1
#        sec.gcabar_L_Ca_inact = 0.1
#        sec.Ra = 0.1
#        sec.cm = 0.1
#        sec.ghbar_gh = 0.1
#        sec.half_gh = 0.1
#            
#    d1.gcabar_L_Ca_inact = 0.1
#    d2.gcabar_L_Ca_inact = 0.1
#    d3.gcabar_L_Ca_inact = 0.1
#    d4.gcabar_L_Ca_inact = 0.1
#    
#    h.qinf_na3rp = 0.1
#    h.qinf_na3rp = 0.1
#    h.thinf_na3rp = 0.1
#    h.vslope_naps = 0.1
#    h.asvh_naps = 0.1
#    h.bsvh_naps = 0.1
#    h.mvhalfca_mAHP = 0.1
#    h.mtauca_mAHP = 0.1
#    h.celsius = 0.1
#    h.theta_m_L_Ca_inact = 0.1
#    h.tau_m_L_Ca_inact = 0.1
#    h.theta_h_L_Ca_inact = 0.1
#    h.tau_h_L_Ca_inact = 0.1
#    h.kappa_h_L_Ca_inact = 0.1
#    h.htau_gh = 0.1
#    
#    return soma, dend, d1, d2, d3, d4, h




