TITLE Calcium removal via outward pump

COMMENT
file modified from Komendantov et al., 2004 J Neurophysiol
written by Antonios Dougalis, 18 Sept 2015, Ulm
ENDCOMMENT 
 
INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}

UNITS {
        (molar) = (1/liter)
        (pA) =  (picoamp)
	(mV) =	(millivolt)
        (uS) =  (micromho)
	(mA) =	(milliamp)
	(mM) =	(millimolar)
}

COMMENT
INDEPENDENT {v FROM -100 TO 50 WITH 50 (mV)}
ENDCOMMENT

NEURON {
	SUFFIX capumpmod
	USEION ca READ cai WRITE ica
	RANGE  icapump,icapumpmax,kmp
 
}


PARAMETER {
        dt  (ms)
		v (mV)
        cai (mM)
		cainit = 0.000184 (mM)
        icapumpmax  = 0.01056 (mA/cm2)
        kmp = 0.0001 (mM)
       
}

ASSIGNED { 
           ica	   (mA/cm2)
           icapump (mA/cm2)
}

BREAKPOINT {
        icapump = icapumpmax*(cai/(cai + kmp))
        ica = icapump
}

INITIAL{
       cai = cainit
}