TITLE  Hyperpolarisation-activated cation current (H-current)

COMMENT
Current description is based on voltage clamp recordings from Dougalis et al., 2016 J Comp Neurosci
written by Antonios Dougalis, Aug 2015, Ulm  
ENDCOMMENT

INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}

UNITS {
        (S) = (siemens)
        (mA) = (milliamp)
        (mV) = (millivolt)
}
 
NEURON {
        SUFFIX H
        NONSPECIFIC_CURRENT ih 
        RANGE ghbar,ih,eh
        RANGE minf
		RANGE tau_m
		RANGE vhalfAct,slopeAct
		RANGE vhalfTact,slopeTact
}
 
PARAMETER {
        v   (mV)
        dt  (ms)
		ghbar  = 0.0002 (S/cm2)
        eh = -40 (mV) 
		vhalfAct = -92 (mV)
		slopeAct = -11.8
		vhalfTact = -100 (mV)
		slopeTact = 7.4
}
 
STATE {
        m
}
 
ASSIGNED {
        ih (mA/cm2)
        minf
	    tau_m 
}
 
BREAKPOINT {
        SOLVE states METHOD cnexp
        ih = ghbar*m*(v - eh)      
}
 
UNITSOFF

INITIAL {
        m = minf
}

DERIVATIVE states { 
        LOCAL minf,tau_m
        minf = 1/(1 + exp(-(v - vhalfAct)/slopeAct))
		tau_m = 114 + 386/(1 + exp(-(v - vhalfTact)/slopeTact))
        m' = (minf-m)/tau_m
}
 
UNITSON

