TITLE Intracellular Calcium ion accumulation without diffusion

COMMENT
file modified from computational paper Komendantov et al., 2004 J Neurophysiol
written by Antonios Dougalis, 18th Sept 2015, Ulm
ENDCOMMENT

INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}

NEURON {
	SUFFIX cabalanmod
	USEION ca READ cai, ica WRITE cai
	RANGE cainit,fCa
	
}

UNITS {
	(mM) = (milli/liter)
	(um) = (micron)
	(mA) = (milliamp)
	FARADAY = (faraday) (coulomb)
	PI = (pi) (1)
}

PARAMETER {
        cainit = 0.00002(mM)
        fCa = 0.025
		
}

ASSIGNED {
	ica (mA/cm2)
	diam (um)
}

STATE {
	cai (mM) <1e-4>
}

BREAKPOINT {
	SOLVE state METHOD sparse
}

INITIAL{
        cai=cainit
}

KINETIC state {
	COMPARTMENT PI*diam*diam/4 {cai}
	~ cai << (-fCa*ica*PI*diam*(1e4)/(2*FARADAY))
}

