TITLE Calcium-activated potassium conductance (SK)
 
COMMENT
written by Antonios Dougalis, Aug 2015, Innsbruck
ENDCOMMENT

UNITS {
       (molar) = (1/liter)
        (pA) = (picoamp)
	(mV) =	(millivolt)
        (S) = (siemens)
	(mA) =	(milliamp)
	(mM) =	(millimolar)
}

COMMENT
INDEPENDENT {v FROM -100 TO 50 WITH 50 (mV)}
ENDCOMMENT

INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}


NEURON {
	SUFFIX gkca
	USEION ca READ cai
	USEION k READ ek WRITE ik 
	RANGE gkcabar,gkca,cai,kmkca,oinf,n,ik
	
 
}


PARAMETER {
        dt (ms)
        v (mV)
		kmkca = 0.00019    (mM)
        n = -0.00004
        cai (mM)
		cainit = 0.000184 (mM)
        gkcabar = 4e-4 (S/cm2)
        ek = -73 (mV)
}

ASSIGNED { 
           ik (mA/cm2)
		   gkca (S/cm2)
		   oinf 
           		   
}


BREAKPOINT {
    oinf = 1/(1 + exp((cai-kmkca)/n))
	gkca =oinf*gkcabar
	ik = gkca*(v - ek)
}

INITIAL{
       cai = cainit
}

