TITLE  A-type transient potassium current (A-current)

COMMENT
written by Antonios Dougalis, 25 Jan 2016, Ulm
based on voltage clamp data modified from Liss et al., 2001 EMBO 
ENDCOMMENT

INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}

UNITS {
        (S) = (siemens)
        (mA) = (milliamp)
        (mV) = (millivolt)
}
 
NEURON {
        SUFFIX A
        USEION k READ ek WRITE ik 
        RANGE gkAbar,ek,ik
        RANGE minf,hinf
		RANGE tau_m, tau_h
		RANGE vhalfAct,slopeAct,vhalfInact,slopeInact
		RANGE vhalfTact,slopeTact
}
 
PARAMETER {
        v   (mV)
        dt  (ms)
		gkAbar  = 0.01 (S/cm2)
        ek = -73 (mV) 
		vhalfAct = -37.5 (mV)
		vhalfInact = -73.0 (mV)
		slopeAct = 6.5
		slopeInact = -7.6
		vhalfTact = -28.8 (mV)
		slopeTact = -5.0
		tau_h = 50 (ms)
		
}
 
STATE {
        m h
}
 
ASSIGNED {
        ik (mA/cm2)
        minf
		hinf
	    tau_m 
		
}
 
BREAKPOINT {
        SOLVE states METHOD cnexp
        ik = gkAbar*m*h*(v - ek)      
}
 
UNITSOFF

INITIAL {
        m = minf
		h = hinf
}

DERIVATIVE states { 
        LOCAL minf,hinf,tau_m
        minf = 1/(1 + exp(-(v - vhalfAct)/slopeAct))
		hinf = 1/(1 + exp(-(v - vhalfInact)/slopeInact))
        tau_m = 2 + 3/(1 + exp(-(v - vhalfTact)/slopeTact))
        m' = (minf-m)/tau_m
        h' = (hinf-h)/tau_h
}
 
UNITSON

