NEURON {
	POINT_PROCESS AMPA
	RANGE tau1, tau2, g, e
	NONSPECIFIC_CURRENT i
	
}

UNITS {
	(nA) = (nanoamp)
	(mV) = (millivolt)
	(umho) = (micromho)
}

PARAMETER {
	tau1 = 0.2 (ms)
	tau2 = 2 (ms)
	e = 0	(mV)
	g = 0.00001 (umho)
}

ASSIGNED {
	v (mV)
	i (nA)
	factor
}

STATE {
	A (umho)
	B (umho)
}

INITIAL {
	LOCAL tp
	i = 0
	A = 0
	B = 0
	tp = (tau1*tau2)/(tau2 - tau1) * log(tau2/tau1)
	factor = -exp(-tp/tau1) + exp(-tp/tau2)
	factor = 1/factor
	
}

BREAKPOINT {
	SOLVE state METHOD cnexp
	g = B - A
	i = g*(v - e)
}

DERIVATIVE state {
	A' = -A/tau1
	B' = -B/tau2
}

NET_RECEIVE(weight (nS)) {
	state_discontinuity(A, A + weight*factor)
	state_discontinuity(B, B + weight*factor)
	i = g*(v - e) + weight
}
