TITLE 1.3l isoform of L-type calcium current with biexponential decay
 
COMMENT
Values for currents are taken from Nadine Ortner and her patch clamp data from transfected HEK293, Sept 2015, Innsbruck, Austria
currents fitted, described and written by Antonios Dougalis, 9th Sept, Ulm, Germany
ENDCOMMENT

INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}

UNITS {
       (molar) = (1/liter)
        (S) = (siemens)
         (mA) = (milliamp)
        (mV) = (millivolt)
         (mM) =  (millimolar)

}
 
NEURON {
        SUFFIX cal3l
        USEION ca READ eca WRITE ica
        RANGE gcal3lbar,gcal3l,ical3l
        RANGE dl3linf,fl3lFinf,fl3lSinf
		RANGE dl3ltau, fl3lFtau, fl3lStau
		RANGE Afl3lF, Afl3lS
		RANGE eca
}
 

 
PARAMETER {
        v (mV)
        dt (ms)
        gcal3lbar =  0 (S/cm2)
        eca = 120 (mV)
        Afl3lF = 0.7
		Afl3lS = 0.3
}
 
STATE {
        dl3l
		fl3lF
		fl3lS 
}
 
ASSIGNED {
        ica (mA/cm2)
		ical3l (mA/cm2)
		gcal3l (S/cm2)
		dl3linf (1)
		fl3lFinf (1)
		fl3lSinf (1)
		dl3ltau (ms)
		fl3lFtau (ms)
		fl3lStau (ms)
		
}
 
BREAKPOINT {
        SOLVE states METHOD cnexp
		gcal3l = (Afl3lF*gcal3lbar*dl3l*fl3lF) + (Afl3lS*gcal3lbar*dl3l*fl3lS)
		ical3l = gcal3l*(v - eca)
		ica = ical3l
        
		
}
 
UNITSOFF
 
INITIAL {
        dl3l = dl3linf
        fl3lF = fl3lFinf
        fl3lS = fl3lSinf
		
		
}

DERIVATIVE states {  
LOCAL dl3linf,fl3lFinf,fl3lSinf,dl3ltau,fl3lFtau,fl3lStau
        :steady state activation boltzmann functions
		dl3linf = boltz(v,-28.5,7.8) 
        :steady state inactivation boltzmann functions
		fl3lFinf = boltz(v,-49.6,-4.4) + 0.15
		fl3lSinf = boltz(v,-49.6,-4.4) + 0.15
		
		:note all activation time constants at offset according to data set max and minima
        dl3ltau = 1.7*boltz(v,-28.4,-17.1) + 0.3
        
		COMMENT
		incorporating a slow second voltage-dependent inactivation 
		Fittings of A1 and A2 contributions according to data at fixed level (fast and slow incativation contribution to max current amplitude is voltage-independent)
		ENDCOMMENT
		
		fl3lFtau = 178*boltz(v, 29.3, 12.2) + 35.1
		fl3lStau = 300*boltz(v,16.5,0.3) + 269
		
		
		COMMENT
		derivative states follow below
		ENDCOMMENT
		
		dl3l' = (dl3linf-dl3l)/dl3ltau
        fl3lF' = (fl3lFinf-fl3lF)/fl3lFtau
        fl3lS' = (fl3lSinf-fl3lS)/fl3lStau
		
}
 
FUNCTION boltz(x,y,z) {
                boltz = 1/(1 + exp(-(x - y)/z))
}

UNITSON

