TITLE 1.3s isoform of L-type calcium current with biexponential decay
 
COMMENT
Values for currents are taken from Nadine Ortner and her patch clamp data from transfected HEK293, Sept 2015, Innsbruck, Austria
currents fitted, described and written by Antonios Dougalis, 9th Sept, Ulm, Germany
ENDCOMMENT

INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}

UNITS {
       (molar) = (1/liter)
        (S) = (siemens)
         (mA) = (milliamp)
        (mV) = (millivolt)
         (mM) =  (millimolar)

}
 
NEURON {
        SUFFIX cal3s
        USEION ca READ eca WRITE ica
        RANGE gcal3sbar,gcal3s,ical3s
        RANGE dl3sinf,fl3sFinf,fl3sSinf
		RANGE dl3stau, fl3sFtau, fl3sStau
		RANGE Afl3sF, Afl3sS
		RANGE eca
}
 
PARAMETER {
        v (mV)
        dt (ms)
        gcal3sbar =  0 (S/cm2)
        eca = 120 (mV)
        
}
 
STATE {
        dl3s
		fl3sF
		fl3sS 
}
 
ASSIGNED {
        ica (mA/cm2)
		ical3s (mA/cm2)
		gcal3s (S/cm2)
		dl3sinf (1)
		fl3sFinf (1)
		fl3sSinf (1)
		dl3stau (ms)
		fl3sFtau (ms)
		fl3sStau (ms)
		Afl3sF 
		Afl3sS
}
 
BREAKPOINT {
        SOLVE states METHOD cnexp
		gcal3s = (Afl3sF*gcal3sbar*dl3s*fl3sF) + (Afl3sS*gcal3sbar*dl3s*fl3sS)
		ical3s = gcal3s*(v - eca)
		ica = ical3s
        
		
}
 
UNITSOFF
 
INITIAL {
        dl3s = dl3sinf
        fl3sF = fl3sFinf
        fl3sS = fl3sSinf
		
		
}

DERIVATIVE states {  
LOCAL dl3sinf,fl3sFinf,fl3sSinf,dl3stau,fl3sFtau,fl3sStau
        :steady state activation boltzmann functions
		dl3sinf = boltz(v,-34.0,7.0) 
        :steady state inactivation boltzmann functions
		fl3sFinf = boltz(v,-51.8,-4.4) + 0.1
		fl3sSinf = boltz(v,-51.8,-4.4) + 0.1
		
		:note all activation time constants at offset according to data set max and minima
        dl3stau = 2.53*boltz(v,-49.3,-15.0) + 0.34
        
		COMMENT
		incorporating a slow second voltage-dependent inactivation tau
		Fittings of A1 and A2 contributions according to data
		ENDCOMMENT
		
		fl3sFtau = 59.5*boltz(v, 19.5, 6.7)+ 26.4 
		fl3sStau = 100*boltz(v,-24.2,-0.25) + 188.3
		Afl3sF = 0.4*boltz(v,20.8,-11.7)+ 0.38
		Afl3sS = 1-Afl3sF
		
		COMMENT
		derivative states follow below
		ENDCOMMENT
		
		dl3s' = (dl3sinf-dl3s)/dl3stau
        fl3sF' = (fl3sFinf-fl3sF)/fl3sFtau
        fl3sS' = (fl3sSinf-fl3sS)/fl3sStau
		
}
 
FUNCTION boltz(x,y,z) {
                boltz = 1/(1 + exp(-(x - y)/z))
}

UNITSON

