TITLE N, L and R HVA calcium currents (three calcium currents) 
 
COMMENT
values for currents are taken from
N type and R HVA current from Kitai and Kang 1993 Neurosci Research
L type currents from computational paper Amini et al., 1999 J Neurophysiol
written by Antonios Dougalis, 18 Sept 2015, Ulm
ENDCOMMENT
 
INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}
 
UNITS {
       (molar) = (1/liter)
        (S) = (siemens)
         (mA) = (milliamp)
        (mV) = (millivolt)
        (mM) =  (millimolar)

}
 
NEURON {
        SUFFIX calcha
        USEION ca READ cai, eca WRITE ica
        RANGE gcanbar, gcalbar, gcarbar, ica, ican, ical, icar, kmn, kml
		RANGE eca
        GLOBAL dlinf,dninf,drinf,fninf,flinf,frinf
}
 

PARAMETER {
        v (mV)
        dt (ms)
        gcanbar =  5.0e-5  (S/cm2)
        gcalbar =  0.0e-5  (S/cm2)
        gcarbar =  5.0e-5  (S/cm2)
        kmn = 0.0001   (mM)
        kml = 0.00045  (mM)
        eca = 120 (mV)
        cai   (mM)
		cainit = 0.00002 (mM)

}
 
STATE {
        dl dn dr fr  
}
 
ASSIGNED {
        ica (mA/cm2)
        icar (mA/cm2)
        ical (mA/cm2)
        ican (mA/cm2)
        dlinf dninf drinf flinf fninf frinf
}
 
BREAKPOINT {
        SOLVE states METHOD cnexp
        fninf = kmn/(kmn + cai)
        flinf = kml/(kml + cai)
        icar = gcarbar*dr*fr*(v - eca)
        ical = gcalbar*dl*flinf*(v - eca)
        ican = gcanbar*dn*fninf*(v - eca)
        ica = icar + ical + ican 
}
 
UNITSOFF
 
INITIAL {
        dr = drinf
        dl = dlinf
        dn = dninf
        fr = frinf
        cai=cainit
}

DERIVATIVE states {  :Computes state variables m, h, and n 
LOCAL dlinf,dninf,drinf,frinf,dltau,dntau,drtau,frtau
        drinf = boltz(v,-10.0,10.0)
        dlinf = boltz(v,-50.0,3.0)
        dninf = boltz(v,-45.0,7.0)
        frinf = boltz(v,-48.0,-5.0)
        drtau = gaussian(v,0.1,13.0,62.0,0.05)
        dltau = gaussian(v,18.0,20.0,45.0,1.50)
        dntau = gaussian(v,18.0,25.0,70.0,0.30)
        frtau = gaussian(v,0.5,18.0,55.6,0.50)
        dr' = (drinf-dr)/drtau
        dl' = (dlinf-dl)/dltau
        dn' = (dninf-dn)/dntau
        fr' = (frinf-fr)/frtau
        
}
 
 
FUNCTION gaussian(v,a,b,c,d) {
        LOCAL arg
        arg= a*exp(-(c+v)*(v+c)/(b*b)) +d
        gaussian = arg
}
 
 
FUNCTION boltz(x,y,z) {
                boltz = 1/(1 + exp(-(x - y)/z))
}

 
UNITSON

