TITLE T type LVA calcium current 
 
COMMENT
original values for currents are taken from Wolfart and Roeper 2002 J Neurosci and Kang and Kitai et al., 1993 Neurosci Res
Data were modified by own data from barium currents for voltage dependence of activation and biexponential decay of inactivation time constants (Dougalis et al., 2015 unpublished observations) 
ENDCOMMENT
 
INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}
 
UNITS {
       (molar) = (1/liter)
        (S) = (siemens)
         (mA) = (milliamp)
        (mV) = (millivolt)
        (mM) =  (millimolar)

}
 
NEURON {
        SUFFIX calchaT
        USEION ca READ eca WRITE ica
        RANGE gcatbar, gcat, ica, icat
        RANGE dtinf,ftFinf,ftSinf
		RANGE dttau, ftFtau, ftStau
		RANGE AftF, AftS
		RANGE eca
}
 

 
PARAMETER {
        v (mV)
        dt (ms)
        gcatbar =  7.5e-5 (S/cm2)
        eca = 120 (mV)
        AftF = 0.7
		AftS = 0.3
}
 
STATE {
        d_t 
		ftF
		ftS
}
 
ASSIGNED {
        ica (mA/cm2)
        icat (mA/cm2)
        gcat (S/cm2)
		dtinf (1) 
		ftFinf (1)
		ftSinf (1)
		dttau (ms)
		ftFtau (ms)
		ftStau (ms)
		
}
 
BREAKPOINT {
        SOLVE states METHOD cnexp
        gcat = (AftF*gcatbar*d_t*ftF) + (AftS*gcatbar*d_t*ftS) : two inactivation processes, a fast and a slow, sharing the same incativation steady-state process
		icat = gcat*(v - eca)
        ica = icat
}
 
UNITSOFF
 
INITIAL {
        d_t = dtinf
        ftF = ftFinf
		ftS = ftSinf
}

DERIVATIVE states { 
LOCAL dtinf,ftFinf,ftSinf,dttau,ftFtau,ftStau
        :steady state activation
		dtinf = boltz(v,-56.3,4.9)
		
		:steady state inactivation
        ftFinf = boltz(v,-76.2,-3.0)
		ftSinf = boltz(v,-76.2,-3.0)
		
		:activation time constants
        dttau = 5*boltz(v,-35.6, -2.5) + 3
        
		:inactivation time constants
		ftFtau = 200*boltz(v,-69, -7.4) + 100
        ftStau = 2000*boltz(v, -62, -2) + 500
		
		
		:derivative states
		d_t' = (dtinf-d_t)/dttau
        ftF' = (ftFinf-ftF)/ftFtau
		ftS' = (ftSinf-ftS)/ftStau
}
 
 
FUNCTION boltz(x,y,z) {
                boltz = 1/(1 + exp(-(x - y)/z))
}

 
UNITSON

