TITLE 1.2 isoform of L-type calcium current with biexponential decay
 
COMMENT
Values for currents are taken from Nadine Ortner and her patch clamp data from transfected HEK293, Sept 2015, Innsbruck, Austria
currents fitted, described and written by Antonios Dougalis, 9th Sept, Ulm, Germany
ENDCOMMENT

INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}
 
UNITS {
       (molar) = (1/liter)
        (S) = (siemens)
         (mA) = (milliamp)
        (mV) = (millivolt)
         (mM) =  (millimolar)

}
 
NEURON {
        SUFFIX cal2
        USEION ca READ eca WRITE ica
        RANGE gcal2bar,gcal2,ical2
        RANGE dl2inf,fl2Finf,fl2Sinf
		RANGE dl2tau, fl2Ftau, fl2Stau
		RANGE Afl2F, Afl2S
		RANGE eca
}
 
 
PARAMETER {
        v (mV)
        dt (ms)
        gcal2bar =  0 (S/cm2)
        eca = 120 (mV)
        
}
 
STATE {
        dl2
		fl2F
		fl2S 
}
 
ASSIGNED {
        ica (mA/cm2)
		ical2 (mA/cm2)
		gcal2 (S/cm2)
		dl2inf (1)
		fl2Finf (1)
		fl2Sinf (1)
		dl2tau (ms)
		fl2Ftau (ms)
		fl2Stau (ms)
		Afl2F 
		Afl2S
}
 
BREAKPOINT {
        SOLVE states METHOD cnexp
		gcal2 = (Afl2F*gcal2bar*dl2*fl2F) + (Afl2S*gcal2bar*dl2*fl2S)
		ical2 = gcal2*(v - eca)
		ica = ical2
        
		
}
 
UNITSOFF
 
INITIAL {
        dl2 = dl2inf
        fl2F = fl2Finf
        fl2S = fl2Sinf
		
		
}

DERIVATIVE states {  
LOCAL dl2inf,fl2Finf,fl2Sinf,dl2tau,fl2Ftau,fl2Stau
        :steady state activation boltzmann functions
		dl2inf = boltz(v,-9.4,7.6) 
        
		:steady state inactivation functions
		fl2Finf = boltz(v,-36.6,-5.2) + 0.15
		fl2Sinf = boltz(v,-36.6,-5.2) + 0.15
		
		:note all activation time constants at offset according to data set max and minima
        dl2tau = 2.33*boltz(v,-32.4,-17.7) + 0.56
        
		COMMENT
		incorporating a second, slow, voltage-dependent inactivation tauS
		Fittings of A1 and A2 contributions according to data, which show a voltage-dependent contribution of fast and slow component to max current amplitude
		fl2tauF follows a second order polynomial equation
		ENDCOMMENT
		
		fl2Ftau = (42 + v + 0.07*v^2) 
		fl2Stau = 596*boltz(v,-27.4,-3.4) + 295
		Afl2F = 0.13*boltz(v,-9.7,5.4)+ 0.54
		Afl2S = 0.12*boltz(v,-10, 5.5) + 0.55
		
		COMMENT
		derivative states follow below
		ENDCOMMENT
		
		dl2' = (dl2inf-dl2)/dl2tau
        fl2F' = (fl2Finf-fl2F)/fl2Ftau
        fl2S' = (fl2Sinf-fl2S)/fl2Stau
		
}
 
FUNCTION boltz(x,y,z) {
                boltz = 1/(1 + exp(-(x - y)/z))
}

UNITSON

