TITLE IRK
: IRK
: Cai 2007



UNITS {
	(mA) = (milliamp)
	(S) = (siemens)
	(mV) = (millivolt)

}


NEURON {
	SUFFIX irk
	USEION k READ ek WRITE ik
        RANGE gbar, g, curr
	}


PARAMETER{
   ek (mV)
   celsius		(degC)
   gbar=.65 (nS/cm2)
   va_kir=-52 (mV)
   ka_kir=13  (mV)
   
   p1tmkir=17.0752
   p2tmkir=-17.8258
   p3tmkir=20.3154
   p4tmkir=-43.4414
   p5tmkir=11.1691
   p6tmkir=3.8329
  
}

ASSIGNED{
		 ik (mA/cm2)
		 g (S/cm2)
		 curr (mA/cm2)
		 v (mV)
        }
	

STATE {
	m 
}


BREAKPOINT {
	SOLVE states METHOD cnexp
	g=gbar*m
	curr = gbar*m*(v-ek)
	ik = gbar*m*(v-ek)

}


INITIAL {
	m=minf(v)

}

DERIVATIVE states {     
        m' = (minf(v) - m)/mtau(v)
		
	}



FUNCTION minf(v (mV)) { 
      
        minf=1/(1+exp((v-va_kir+30)/ka_kir))
	  
	  }
	  
FUNCTION mtau(v(mV)){
		
        mtau=p1tmkir/(exp(-(v-p2tmkir)/p3tmkir)+exp((v-p4tmkir)/p5tmkir))+p6tmkir
		
		}
		












