TITLE sk
: kcnl channels
: 



UNITS {
    (mA) = (milliamp)
	(S) = (siemens)
	(mV) = (millivolt)
	 (molar)=(1/liter)
	 (uM) =	(micromolar)
	 (mM)= (millimolar)
	 (M)= (molar)
	
}

NEURON {
	SUFFIX kcnl
	USEION k READ ek WRITE ik
	USEION ca READ eca
	RANGE  gbar, g, curr
	EXTERNAL caintra_caodmy
 
}


PARAMETER{
   eca (mV)
   ek (mV)
   celsius		(degC)
   ca_eq=0.05e-3 (mM)
   gbar=0.06 (nS)
   km=0.33e-3 (mM)
   t_sk=6.3 (ms)
      
    }

ASSIGNED{
		 ik (mA/cm2)
		 curr (mA/cm2)
		 cai (mM)
		 minf
        	 g (S/cm2)
		 v (mV)	
         		 
		
}	

STATE {
	m
}


BREAKPOINT {
	SOLVE state METHOD cnexp
	g=m
	curr=gbar*m*(v-ek)
	ik = gbar*m*(v-ek)

}


INITIAL {
	
	m=act(ca_eq)
	
}

DERIVATIVE state{  
        
        m' = (act(caintra_caodmy) - m)/t_sk
	
	}


FUNCTION act(ca (mM)) { 
	UNITSOFF
        act=(ca)/((ca)+km)
	UNITSON
	}
	


